/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.ripe.ipresource.ImmutableResourceSet;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceType;
import net.ripe.ipresource.UniqueIpResource;
import org.apache.commons.lang3.Validate;

public class IpResourceSet
implements Iterable<IpResource>,
Serializable {
    @Deprecated
    public static final IpResourceSet IP_PRIVATE_USE_RESOURCES = new IpResourceSet(ImmutableResourceSet.IP_PRIVATE_USE_RESOURCES);
    @Deprecated
    public static final IpResourceSet ASN_PRIVATE_USE_RESOURCES = new IpResourceSet(ImmutableResourceSet.ASN_PRIVATE_USE_RESOURCES);
    @Deprecated
    public static final IpResourceSet ALL_PRIVATE_USE_RESOURCES = new IpResourceSet(ImmutableResourceSet.ALL_PRIVATE_USE_RESOURCES);
    private static final long serialVersionUID = 1L;
    TreeMap<UniqueIpResource, IpResource> resourcesByEndPoint;

    public IpResourceSet() {
        this.resourcesByEndPoint = new TreeMap();
    }

    public IpResourceSet(IpResourceSet resources) {
        this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)resources.resourcesByEndPoint);
    }

    public IpResourceSet(ImmutableResourceSet resources) {
        this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)resources.resourcesByEndPoint);
    }

    public IpResourceSet(IpResource ... resources) {
        this();
        for (IpResource resource : resources) {
            this.add(resource);
        }
    }

    public IpResourceSet(Collection<? extends IpResource> resources) {
        this((Iterable<? extends IpResource>)resources);
    }

    public IpResourceSet(Iterable<? extends IpResource> resources) {
        if (resources instanceof IpResourceSet) {
            this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)((IpResourceSet)resources).resourcesByEndPoint);
        } else if (resources instanceof ImmutableResourceSet) {
            this.resourcesByEndPoint = new TreeMap<UniqueIpResource, IpResource>((SortedMap<UniqueIpResource, IpResource>)((ImmutableResourceSet)resources).resourcesByEndPoint);
        } else {
            this.resourcesByEndPoint = new TreeMap();
            for (IpResource ipResource : resources) {
                this.add(ipResource);
            }
        }
    }

    public void addAll(Iterable<? extends IpResource> resources) {
        for (IpResource ipResource : resources) {
            this.add(ipResource);
        }
    }

    public void add(IpResource resource) {
        IpResource potentialMatch;
        Validate.notNull((Object)resource, (String)"resource is null", (Object[])new Object[0]);
        UniqueIpResource start = resource.getStart();
        if (!start.equals(start.getType().getMinimum())) {
            start = start.predecessor();
        }
        Iterator iterator = this.resourcesByEndPoint.tailMap(start, true).values().iterator();
        while (iterator.hasNext() && resource.isMergeable(potentialMatch = (IpResource)iterator.next())) {
            iterator.remove();
            resource = resource.merge(potentialMatch);
        }
        this.resourcesByEndPoint.put(resource.getEnd(), this.normalize(resource));
    }

    public boolean isEmpty() {
        return this.resourcesByEndPoint.isEmpty();
    }

    public boolean contains(IpResource resource) {
        Map.Entry<UniqueIpResource, IpResource> potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        return potentialMatch != null && potentialMatch.getValue().contains(resource);
    }

    public boolean contains(Iterable<? extends IpResource> other) {
        for (IpResource ipResource : other) {
            if (this.contains(ipResource)) continue;
            return false;
        }
        return true;
    }

    public boolean containsType(IpResourceType type) {
        for (IpResource resource : this.resourcesByEndPoint.values()) {
            if (type != resource.getType()) continue;
            return true;
        }
        return false;
    }

    public static IpResourceSet parse(String s) {
        String[] resources = s.split(",");
        IpResourceSet result = new IpResourceSet();
        for (String r : resources) {
            String trimmed = r.trim();
            if (trimmed.isEmpty()) continue;
            result.add(IpResource.parse(trimmed));
        }
        return result;
    }

    @Override
    public Iterator<IpResource> iterator() {
        return this.resourcesByEndPoint.values().iterator();
    }

    @Override
    public Spliterator<IpResource> spliterator() {
        return Spliterators.spliterator(this.resourcesByEndPoint.values(), 5);
    }

    public Stream<IpResource> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean remove(IpResource resource) {
        boolean removed = false;
        Map.Entry<UniqueIpResource, IpResource> potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        while (potentialMatch != null && potentialMatch.getValue().overlaps(resource)) {
            this.resourcesByEndPoint.remove(potentialMatch.getKey());
            removed = true;
            for (IpResource ipResource : potentialMatch.getValue().subtract(resource)) {
                this.add(ipResource);
            }
            potentialMatch = this.resourcesByEndPoint.ceilingEntry(resource.getStart());
        }
        return removed;
    }

    public void removeAll(Iterable<? extends IpResource> other) {
        for (IpResource ipResource : other) {
            this.remove(ipResource);
        }
    }

    public void retainAll(IpResourceSet other) {
        if (this.isEmpty()) {
            return;
        }
        if (other.isEmpty()) {
            this.resourcesByEndPoint.clear();
            return;
        }
        TreeMap<UniqueIpResource, IpResource> temp = new TreeMap<UniqueIpResource, IpResource>();
        Iterator<IpResource> thisIterator = this.iterator();
        Iterator<IpResource> thatIterator = other.iterator();
        IpResource thisResource = thisIterator.next();
        IpResource thatResource = thatIterator.next();
        while (thisResource != null && thatResource != null) {
            int compareTo;
            IpResource intersect = thisResource.intersect(thatResource);
            if (intersect != null) {
                temp.put(intersect.getEnd(), this.normalize(intersect));
            }
            if ((compareTo = thisResource.getEnd().compareTo(thatResource.getEnd())) <= 0) {
                IpResource ipResource = thisResource = thisIterator.hasNext() ? thisIterator.next() : null;
            }
            if (compareTo < 0) continue;
            thatResource = thatIterator.hasNext() ? thatIterator.next() : null;
        }
        this.resourcesByEndPoint = temp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IpResourceSet)) {
            return false;
        }
        IpResourceSet other = (IpResourceSet)obj;
        return this.resourcesByEndPoint.equals(other.resourcesByEndPoint);
    }

    public int hashCode() {
        return this.resourcesByEndPoint.hashCode();
    }

    public String toString() {
        String s = this.resourcesByEndPoint.values().toString();
        return s.substring(1, s.length() - 1);
    }

    private IpResource normalize(IpResource resource) {
        return resource.isUnique() ? resource.getStart() : resource;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        if (!gf.defaulted("resourcesByEndPoint")) {
            this.resourcesByEndPoint = (TreeMap)gf.get("resourcesByEndPoint", null);
        } else {
            SortedSet resources = (SortedSet)gf.get("resources", null);
            this.resourcesByEndPoint = new TreeMap();
            for (IpResource resource : resources) {
                this.resourcesByEndPoint.put(resource.getEnd(), resource);
            }
        }
    }
}

