/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.database;

import java.util.concurrent.Callable;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.tasks.UpdateOsmDatabase;
import picocli.CommandLine;

@CommandLine.Command(name="update-osm", description={"Update OpenStreetMap data in Postgres."})
public class UpdateOsm
implements Callable<Integer> {
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The JDBC url of Postgres."}, required=true)
    private String database;
    @CommandLine.Option(names={"--srid"}, paramLabel="SRID", description={"The projection used by the database."})
    private int srid = 3857;
    @CommandLine.Option(names={"--replication-url"}, paramLabel="REPLICATION_URL", description={"The replication url of the OpenStreetMap server."})
    private String replicationUrl = "https://planet.osm.org/replication/hour";

    @Override
    public Integer call() throws Exception {
        new UpdateOsmDatabase((Object)this.database, Integer.valueOf(this.srid), this.replicationUrl).execute(new WorkflowContext());
        return 0;
    }
}

