/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ContextAwarePropertySource;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertySource;

@ServiceProvider(value=PropertySource.class)
public class SystemPropertiesPropertySource
extends ContextAwarePropertySource
implements PropertySource {
    private static final int DEFAULT_PRIORITY = 0;
    private static final String PREFIX = "log4j2.";
    private static final String DELIM = ".";
    private static volatile int hashcode = 0;
    private static final Map<String, Properties> systemPropertiesMap = new ConcurrentHashMap<String, Properties>();
    private static final Lock RELOAD_LOCK = new ReentrantLock();

    public SystemPropertiesPropertySource() {
        super(null, "*", true);
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void forEach(BiConsumer<String, String> action) {
        if (!this.refreshProperties()) {
            return;
        }
        Properties properties = systemPropertiesMap.get("*");
        for (String key : properties.stringPropertyNames()) {
            String keyStr = Objects.toString(key, null);
            action.accept(keyStr, properties.getProperty(keyStr));
        }
    }

    @Override
    public CharSequence getNormalForm(Iterable<? extends CharSequence> tokens) {
        return PREFIX + PropertySource.Util.joinAsCamelCase(tokens);
    }

    @Override
    public Collection<String> getPropertyNames() {
        return this.getPropertyNames("*");
    }

    @Override
    public Collection<String> getPropertyNames(String contextName) {
        this.refreshProperties();
        Properties properties = (Properties)this.propertiesMap.get(contextName);
        return properties != null ? properties.stringPropertyNames() : Collections.emptyList();
    }

    @Override
    public String getProperty(String contextName, String key) {
        if (contextName != null && !contextName.equals("*")) {
            return System.getProperty(PREFIX + contextName + DELIM + key, null);
        }
        String result = System.getProperty("log4j2.*." + key, null);
        if (result == null) {
            result = System.getProperty(key, null);
        }
        return result;
    }

    @Override
    public boolean containsProperty(String contextName, String key) {
        if (contextName != null && !contextName.equals("*")) {
            return System.getProperty(PREFIX + contextName + DELIM + key, null) != null;
        }
        return System.getProperty("log4j2.*." + key, null) != null || System.getProperty(key, null) != null;
    }

    @Override
    public Map<String, Properties> getPropertiesMap() {
        return systemPropertiesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshProperties() {
        Properties sysProps;
        boolean refresh = false;
        RELOAD_LOCK.lock();
        try {
            Properties props = System.getProperties();
            if (props == null) {
                boolean bl = false;
                return bl;
            }
            sysProps = new Properties();
            sysProps.putAll((Map<?, ?>)props);
        }
        finally {
            RELOAD_LOCK.unlock();
        }
        if (hashcode == 0) {
            refresh = true;
            hashcode = sysProps.hashCode();
        } else {
            int hash = sysProps.hashCode();
            if (hash != hashcode) {
                refresh = true;
                hashcode = hash;
            }
        }
        if (refresh) {
            Map<String, Properties> map = this.parseProperties(sysProps, "*", true);
            systemPropertiesMap.putAll(map);
        }
        if (refresh) {
            PropertiesUtil.getProperties().reload();
        }
        return true;
    }
}

