/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.net.UrlConnectionFactory;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.core.util.AuthorizationProvider;
import org.apache.logging.log4j.core.util.internal.LastModifiedSource;
import org.apache.logging.log4j.core.util.internal.Status;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertyEnvironment;

public final class HttpInputStreamUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int NOT_MODIFIED = 304;
    private static final int NOT_AUTHORIZED = 401;
    private static final int NOT_FOUND = 404;
    private static final int OK = 200;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result getInputStream(LastModifiedSource source, PropertyEnvironment props, AuthorizationProvider authorizationProvider, SslConfiguration sslConfiguration) {
        Result result = new Result();
        try {
            int code;
            HttpURLConnection connection;
            block28: {
                long lastModified = source.getLastModified();
                connection = (HttpURLConnection)UrlConnectionFactory.createConnection(source.getURI().toURL(), lastModified, sslConfiguration, authorizationProvider, props);
                connection.connect();
                code = connection.getResponseCode();
                switch (code) {
                    case 304: {
                        LOGGER.debug("Configuration not modified");
                        result.status = Status.NOT_MODIFIED;
                        Result result2 = result;
                        return result2;
                    }
                    case 404: {
                        LOGGER.debug("Unable to access {}: Not Found", (Object)source.toString());
                        result.status = Status.NOT_FOUND;
                        Result result3 = result;
                        return result3;
                    }
                    case 200: {
                        Result result4;
                        InputStream is = connection.getInputStream();
                        try {
                            source.setLastModified(connection.getLastModified());
                            LOGGER.debug("Content was modified for {}. previous lastModified: {}, new lastModified: {}", (Object)source.toString(), (Object)lastModified, (Object)connection.getLastModified());
                            result.status = Status.SUCCESS;
                            result.inputStream = new ByteArrayInputStream(is.readAllBytes());
                            result4 = result;
                            if (is == null) return result4;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (is == null) throw throwable;
                                try {
                                    is.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                try (InputStream es = connection.getErrorStream();){
                                    LOGGER.info("Error accessing configuration at {}: {}", (Object)source.toString(), (Object)es.readAllBytes());
                                    throw new ConfigurationException("Unable to access " + source.toString(), e);
                                }
                                catch (IOException ioe) {
                                    LOGGER.error("Error accessing configuration at {}: {}", (Object)source.toString(), (Object)e.getMessage());
                                }
                                throw new ConfigurationException("Unable to access " + source.toString(), e);
                            }
                        }
                        is.close();
                        return result4;
                    }
                    case 401: {
                        throw new ConfigurationException("Authorization failed");
                    }
                }
                if (code >= 0) break block28;
                LOGGER.info("Invalid response code returned");
                throw new ConfigurationException("Unable to access " + source.toString());
            }
            LOGGER.info("Unexpected response code returned {}", (Object)code);
            throw new ConfigurationException("Unable to access " + source.toString());
            finally {
                connection.disconnect();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error accessing {}: {}", (Object)source.toString(), (Object)e.getMessage());
            throw new ConfigurationException("Unable to access " + source.toString(), e);
        }
    }

    public static class Result {
        private InputStream inputStream;
        private Status status;

        public Result() {
        }

        public Result(Status status) {
            this.status = status;
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

