/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDateTimeFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateTimeNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalPlainDateTimeFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainDateTimeFunction> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainDateTimeFunctionBuiltins();

    protected TemporalPlainDateTimeFunctionBuiltins() {
        super(JSTemporalPlainDateTime.CLASS_NAME, TemporalPlainDateTimeFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainDateTimeFunction builtinEnum) {
        switch (builtinEnum) {
            case from: {
                return TemporalPlainDateTimeFunctionBuiltinsFactory.JSTemporalPlainDateTimeFromNodeGen.create(context, builtin, TemporalPlainDateTimeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case compare: {
                return TemporalPlainDateTimeFunctionBuiltinsFactory.JSTemporalPlainDateTimeCompareNodeGen.create(context, builtin, TemporalPlainDateTimeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainDateTimeFunction implements BuiltinEnum<TemporalPlainDateTimeFunction>
    {
        from(1),
        compare(2);

        private final int length;

        private TemporalPlainDateTimeFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSTemporalPlainDateTimeFromNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateTimeFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateTimeObject from(Object item, Object optParam, @Cached(value="create(getContext())") ToTemporalDateTimeNode toTemporalDateTime, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            JSDynamicObject options = this.getOptionsObject(optParam, this, errorBranch, optionUndefined);
            if (this.isObject(item) && JSTemporalPlainDateTime.isJSTemporalPlainDateTime(item)) {
                JSTemporalPlainDateTimeObject dtItem = (JSTemporalPlainDateTimeObject)item;
                TemporalUtil.toTemporalOverflow(options, getOptionNode);
                return JSTemporalPlainDateTime.create(this.getContext(), dtItem.getYear(), dtItem.getMonth(), dtItem.getDay(), dtItem.getHour(), dtItem.getMinute(), dtItem.getSecond(), dtItem.getMillisecond(), dtItem.getMicrosecond(), dtItem.getNanosecond(), dtItem.getCalendar(), this, errorBranch);
            }
            return toTemporalDateTime.execute(item, options);
        }
    }

    public static abstract class JSTemporalPlainDateTimeCompareNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateTimeCompareNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int compare(Object obj1, Object obj2, @Cached(value="create(getContext())") ToTemporalDateTimeNode toTemporalDateTime) {
            JSTemporalPlainDateTimeObject one = toTemporalDateTime.execute(obj1, Undefined.instance);
            JSTemporalPlainDateTimeObject two = toTemporalDateTime.execute(obj2, Undefined.instance);
            return TemporalUtil.compareISODateTime(one.getYear(), one.getMonth(), one.getDay(), one.getHour(), one.getMinute(), one.getSecond(), one.getMillisecond(), one.getMicrosecond(), one.getNanosecond(), two.getYear(), two.getMonth(), two.getDay(), two.getHour(), two.getMinute(), two.getSecond(), two.getMillisecond(), two.getMicrosecond(), two.getNanosecond());
        }
    }
}

