/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import com.google.errorprone.annotations.concurrent.LazyInit;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.Supplier;
import org.apache.logging.log4j.lang.Nullable;
import org.apache.logging.log4j.plugins.QualifierType;
import org.apache.logging.log4j.plugins.di.Keys;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.plugins.util.TypeUtil;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.Strings;

public class Key<T>
implements StringBuilderFormattable,
Comparable<Key<T>> {
    private final Type type;
    private final Class<T> rawType;
    private final @Nullable Class<? extends Annotation> qualifierType;
    private final String name;
    private final String namespace;
    private final OptionalInt order;
    private final int hashCode;
    @LazyInit
    private @Nullable String toString;
    private static final String TO_STRING_PREFIX = "Key[type: ";
    private static final String NAMESPACE = "; namespace: ";
    private static final String NAME = "; name: ";
    private static final String QUALIFIER_TYPE = "; qualifierType: ";

    protected Key() {
        this.type = TypeUtil.getSuperclassTypeParameter(this.getClass());
        this.rawType = TypeUtil.getRawType(this.type);
        AnnotatedType superclass = this.getClass().getAnnotatedSuperclass();
        Annotation qualifier = AnnotationUtil.getElementAnnotationHavingMetaAnnotation(superclass, QualifierType.class);
        this.qualifierType = qualifier != null ? qualifier.annotationType() : null;
        this.name = Keys.getName(superclass);
        this.namespace = Keys.getNamespace(superclass);
        this.order = AnnotationUtil.getOrder(superclass);
        this.hashCode = Objects.hash(this.type, this.qualifierType, this.name.toLowerCase(Locale.ROOT), this.namespace.toLowerCase(Locale.ROOT));
    }

    private Key(Type type, Class<T> rawType, @Nullable Class<? extends Annotation> qualifierType, String name, String namespace, OptionalInt order) {
        this.type = type;
        this.rawType = rawType;
        this.qualifierType = qualifierType;
        this.name = name;
        this.namespace = namespace;
        this.order = order;
        this.hashCode = Objects.hash(type, qualifierType, name.toLowerCase(Locale.ROOT), namespace.toLowerCase(Locale.ROOT));
    }

    public final Type getType() {
        return this.type;
    }

    public final Class<T> getRawType() {
        return this.rawType;
    }

    public final String getName() {
        return this.name;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public final @Nullable Class<? extends Annotation> getQualifierType() {
        return this.qualifierType;
    }

    public final OptionalInt getOrder() {
        return this.order;
    }

    public final <U> Key<U> withType(Type type) {
        Class rawType = TypeUtil.getRawType(type);
        return new Key(type, rawType, this.qualifierType, this.name, this.namespace, this.order);
    }

    public final Key<T> withName(String name) {
        return new Key<T>(this.type, this.rawType, this.qualifierType, name, this.namespace, this.order);
    }

    public final Key<T> withNamespace(String namespace) {
        return new Key<T>(this.type, this.rawType, this.qualifierType, this.name, namespace, this.order);
    }

    public final Key<T> withQualifierType(Class<? extends Annotation> qualifierType) {
        return new Key<T>(this.type, this.rawType, qualifierType, this.name, this.namespace, this.order);
    }

    public final <P> @Nullable Key<P> getSuppliedType() {
        if (this.type instanceof ParameterizedType && Supplier.class.isAssignableFrom(this.rawType)) {
            Type typeArgument = ((ParameterizedType)this.type).getActualTypeArguments()[0];
            return this.withType(typeArgument);
        }
        return null;
    }

    public final <P> @Nullable Key<P> getParameterizedTypeArgument(int arg) {
        if (arg < 0) {
            throw new IndexOutOfBoundsException(arg);
        }
        if (this.type instanceof ParameterizedType) {
            Type[] typeArguments = ((ParameterizedType)this.type).getActualTypeArguments();
            if (arg > typeArguments.length) {
                throw new IndexOutOfBoundsException(arg);
            }
            Type typeArgument = typeArguments[arg];
            return this.withType(typeArgument);
        }
        return null;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        return TypeUtil.isEqual(this.type, that.type) && this.name.equalsIgnoreCase(that.name) && this.namespace.equalsIgnoreCase(that.namespace) && Objects.equals(this.qualifierType, that.qualifierType);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        String string = this.toString;
        if (string == null) {
            StringBuilder sb = new StringBuilder(32);
            this.formatTo(sb);
            this.toString = string = sb.toString();
        }
        return string;
    }

    public void formatTo(StringBuilder buffer) {
        buffer.append(TO_STRING_PREFIX).append(this.type.getTypeName());
        if (!this.namespace.isEmpty()) {
            buffer.append(NAMESPACE).append(this.namespace);
        }
        if (!this.name.isEmpty()) {
            buffer.append(NAME).append(this.name);
        }
        if (this.qualifierType != null) {
            buffer.append(QUALIFIER_TYPE).append(this.qualifierType.getSimpleName());
        }
        buffer.append(']');
    }

    @Override
    public int compareTo(Key<T> o) {
        OptionalInt otherOrder = o.order;
        if (this.order.isPresent() && otherOrder.isPresent()) {
            return Integer.compare(this.order.getAsInt(), otherOrder.getAsInt());
        }
        if (this.order.isPresent()) {
            return -1;
        }
        if (otherOrder.isPresent()) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        return this.name.compareToIgnoreCase(o.name);
    }

    public static <T> Key<T> forClass(Class<T> clazz) {
        Builder<T> builder = Key.builder(clazz).setQualifierType(Key.getQualifierType(clazz)).setName(Keys.getName(clazz)).setNamespace(Keys.getNamespace(clazz));
        AnnotationUtil.getOrder(clazz).ifPresent(builder::setOrder);
        return builder.get();
    }

    public static <T> Key<T> forMethod(Method method) {
        Builder<T> builder = Key.builder(method.getGenericReturnType());
        AnnotationUtil.getOrder(method).ifPresent(builder::setOrder);
        return builder.setQualifierType(Key.getQualifierType(method)).setName(Keys.getName(method)).setNamespace(Keys.getNamespace(method)).get();
    }

    public static <T> Key<T> forParameter(Parameter parameter) {
        return Key.builder(parameter.getParameterizedType()).setQualifierType(Key.getQualifierType(parameter)).setName(Keys.getName(parameter)).setNamespace(Keys.getNamespace(parameter)).get();
    }

    public static <T> Key<T> forField(Field field) {
        return Key.builder(field.getGenericType()).setQualifierType(Key.getQualifierType(field)).setName(Keys.getName(field)).setNamespace(Keys.getNamespace(field)).get();
    }

    public static <T> Builder<T> builder(Type type) {
        return new Builder(type);
    }

    public static <T> Builder<T> builder(Class<T> type) {
        return new Builder<T>(type);
    }

    public static <T> Builder<T> builder(Key<T> original) {
        return new Builder<T>(original);
    }

    private static @Nullable Class<? extends Annotation> getQualifierType(AnnotatedElement element) {
        return AnnotationUtil.findAnnotatedAnnotations(element, QualifierType.class).map(annotatedAnnotation -> annotatedAnnotation.annotation().annotationType()).findFirst().orElse(null);
    }

    public static class Builder<T>
    implements Supplier<Key<T>> {
        private final Type type;
        private final Class<T> rawType;
        private @Nullable Class<? extends Annotation> qualifierType;
        private @Nullable String name;
        private @Nullable String namespace;
        private OptionalInt order = OptionalInt.empty();

        private Builder(Type type) {
            this.type = type;
            this.rawType = TypeUtil.getRawType(type);
        }

        private Builder(Class<T> type) {
            this.type = type;
            this.rawType = type;
        }

        private Builder(Key<T> original) {
            this.type = original.type;
            this.rawType = original.rawType;
            this.qualifierType = original.qualifierType;
            this.name = original.name;
            this.namespace = original.namespace;
            this.order = original.order;
        }

        public Builder<T> setQualifierType(@Nullable Class<? extends Annotation> qualifierType) {
            this.qualifierType = qualifierType;
            return this;
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder<T> setOrder(int order) {
            this.order = OptionalInt.of(order);
            return this;
        }

        @Override
        public Key<T> get() {
            OptionalInt order;
            if (Strings.isBlank((String)this.name)) {
                this.name = "";
            }
            if (Strings.isBlank((String)this.namespace)) {
                this.namespace = "";
            }
            if ((order = this.order).isEmpty()) {
                order = AnnotationUtil.getOrder(this.rawType);
            }
            return new Key<T>(this.type, this.rawType, this.qualifierType, this.name, this.namespace, order);
        }
    }
}

