/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.table;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mil.nga.geopackage.db.table.ColumnConstraints;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.Constraints;

public class TableConstraints {
    private Constraints constraints = new Constraints();
    private Map<String, ColumnConstraints> columnConstraints = new LinkedHashMap<String, ColumnConstraints>();

    public void addTableConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void addTableConstraints(Constraints constraints) {
        this.constraints.add(constraints);
    }

    public Constraints getTableConstraints() {
        return this.constraints;
    }

    public Constraint getTableConstraint(int index) {
        return this.constraints.get(index);
    }

    public int numTableConstraints() {
        return this.constraints.size();
    }

    public void addColumnConstraint(String columnName, Constraint constraint) {
        this.getOrCreateColumnConstraints(columnName).addConstraint(constraint);
    }

    public void addColumnConstraints(String columnName, Collection<Constraint> constraints) {
        this.getOrCreateColumnConstraints(columnName).addConstraints(constraints);
    }

    public void addColumnConstraints(ColumnConstraints constraints) {
        this.getOrCreateColumnConstraints(constraints.getName()).addConstraints(constraints);
    }

    private ColumnConstraints getOrCreateColumnConstraints(String columnName) {
        ColumnConstraints constraints = this.columnConstraints.get(columnName);
        if (constraints == null) {
            constraints = new ColumnConstraints(columnName);
            this.columnConstraints.put(columnName, constraints);
        }
        return constraints;
    }

    public void addColumnConstraints(Map<String, ColumnConstraints> constraints) {
        this.addColumnConstraints(constraints.values());
    }

    public void addColumnConstraints(Collection<ColumnConstraints> constraints) {
        for (ColumnConstraints columnConstraints : constraints) {
            this.addColumnConstraints(columnConstraints);
        }
    }

    public Map<String, ColumnConstraints> getColumnConstraints() {
        return this.columnConstraints;
    }

    public Set<String> getColumnsWithConstraints() {
        return this.columnConstraints.keySet();
    }

    public ColumnConstraints getColumnConstraints(String columnName) {
        return this.columnConstraints.get(columnName);
    }

    public Constraint getColumnConstraint(String columnName, int index) {
        Constraint constraint = null;
        ColumnConstraints columnConstraints = this.getColumnConstraints(columnName);
        if (columnConstraints != null) {
            constraint = columnConstraints.getConstraint(index);
        }
        return constraint;
    }

    public int numColumnConstraints(String columnName) {
        int count = 0;
        ColumnConstraints columnConstraints = this.getColumnConstraints(columnName);
        if (columnConstraints != null) {
            count = columnConstraints.numConstraints();
        }
        return count;
    }

    public void addConstraints(TableConstraints constraints) {
        if (constraints != null) {
            this.addTableConstraints(constraints.getTableConstraints());
            this.addColumnConstraints(constraints.getColumnConstraints());
        }
    }

    public boolean hasConstraints() {
        return this.hasTableConstraints() || this.hasColumnConstraints();
    }

    public boolean hasTableConstraints() {
        return this.constraints.has();
    }

    public boolean hasColumnConstraints() {
        return !this.columnConstraints.isEmpty();
    }

    public boolean hasColumnConstraints(String columnName) {
        return this.numColumnConstraints(columnName) > 0;
    }
}

