/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.fastutil.chars.Char2ObjectMap;
import com.linecorp.armeria.internal.shaded.fastutil.chars.Char2ObjectMaps;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;

final class RoutingTrie<V> {
    private static final Node<?> CONTINUE_WALKING = new Node(NodeType.CATCH_ALL, "", Char2ObjectMaps.emptyMap(), null, null, ImmutableList.of());
    private final Node<V> root;

    private Node<V> continueWalking() {
        return CONTINUE_WALKING;
    }

    RoutingTrie(Node<V> root) {
        Objects.requireNonNull(root, "root");
        this.root = root;
    }

    List<V> find(String path) {
        return this.find(path, NodeProcessor.noop());
    }

    List<V> find(String path, NodeProcessor<V> processor) {
        Node<V> node = this.findNode(path, false, processor);
        return node == null ? ImmutableList.of() : node.values;
    }

    List<V> findAll(String path) {
        return this.findAllNodes(path, false).stream().flatMap(n -> n.values.stream()).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    Node<V> findNode(String path) {
        return this.findNode(path, false, NodeProcessor.noop());
    }

    @Nullable
    Node<V> findNode(String path, boolean exact, NodeProcessor<V> processor) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(processor, "processor");
        return this.findFirstNode(this.root, path, 0, exact, new IntHolder(), processor);
    }

    @Nullable
    private Node<V> findFirstNode(Node<V> node, String path, int begin, boolean exact, IntHolder nextHolder, NodeProcessor<V> processor) {
        Node found;
        Node<V> checked = this.checkNode(node, path, begin, exact, nextHolder);
        if (checked != this.continueWalking()) {
            if (checked != null) {
                return processor.process(checked);
            }
            return null;
        }
        int next = nextHolder.value;
        Node child = (Node)node.children.get(path.charAt(next));
        if (child != null && (found = this.findFirstNode(child, path, next, exact, nextHolder, processor)) != null) {
            return found;
        }
        child = node.parameterChild;
        if (child != null && (found = this.findFirstNode(child, path, next, exact, nextHolder, processor)) != null) {
            return found;
        }
        if (node.catchAllChild != null) {
            return processor.process(node.catchAllChild);
        }
        return null;
    }

    private List<Node<V>> findAllNodes(String path, boolean exact) {
        ImmutableList.Builder<Node<V>> accumulator = ImmutableList.builder();
        this.findAllNodes(this.root, path, 0, exact, accumulator, new IntHolder());
        return accumulator.build();
    }

    private void findAllNodes(Node<V> node, String path, int begin, boolean exact, ImmutableList.Builder<Node<V>> accumulator, IntHolder nextHolder) {
        Node<V> checked = this.checkNode(node, path, begin, exact, nextHolder);
        if (checked != this.continueWalking()) {
            if (checked != null) {
                accumulator.add((Object)checked);
            }
            return;
        }
        int next = nextHolder.value;
        Node child = node.catchAllChild;
        if (child != null) {
            accumulator.add((Object)child);
        }
        if ((child = node.parameterChild) != null) {
            this.findAllNodes(child, path, next, exact, accumulator, nextHolder);
        }
        if ((child = (Node)node.children.get(path.charAt(next))) != null) {
            this.findAllNodes(child, path, next, exact, accumulator, nextHolder);
        }
    }

    @Nullable
    private Node<V> checkNode(Node<V> node, String path, int begin, boolean exact, IntHolder next) {
        switch (node.type) {
            case EXACT: {
                int len = node.path.length();
                if (!path.regionMatches(begin, node.path, 0, len)) {
                    return null;
                }
                if (len == path.length() - begin) {
                    if (exact || !node.values.isEmpty() || node.catchAllChild == null) {
                        return node;
                    }
                    return node.catchAllChild;
                }
                next.value = begin + len;
                break;
            }
            case PARAMETER: {
                int delim = path.indexOf(47, begin);
                if (delim < 0) {
                    return node;
                }
                if (path.length() == delim + 1) {
                    Node<V> trailingSlashNode = (Node<V>)node.children.get('/');
                    return trailingSlashNode != null ? trailingSlashNode : node;
                }
                next.value = delim;
                break;
            }
            default: {
                throw new Error("Should not reach here");
            }
        }
        return this.continueWalking();
    }

    void dump(OutputStream output) {
        PrintWriter p = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        p.printf("Dump of %s:%n", this);
        this.dump(p, this.root, 0);
        p.flush();
    }

    private void dump(PrintWriter p, Node<V> node, int depth) {
        p.printf("<%d> %s%n", depth, node);
        node.children.values().forEach(child -> this.dump(p, (Node<V>)child, depth + 1));
    }

    static final class Node<V> {
        final NodeType type;
        @Nullable
        private Node<V> parent;
        final String path;
        final Char2ObjectMap<Node<V>> children;
        @Nullable
        final Node<V> parameterChild;
        @Nullable
        final Node<V> catchAllChild;
        final List<V> values;

        Node(NodeType type, String path, Char2ObjectMap<Node<V>> children, @Nullable Node<V> parameterChild, @Nullable Node<V> catchAllChild, List<V> values) {
            this.type = Objects.requireNonNull(type, "type");
            this.path = Objects.requireNonNull(path, "path");
            this.children = Objects.requireNonNull(children, "children");
            this.parameterChild = parameterChild;
            this.catchAllChild = catchAllChild;
            this.values = Objects.requireNonNull(values, "values");
            children.values().forEach(node -> node.setParent(this));
        }

        @Nullable
        Node<V> parent() {
            return this.parent;
        }

        private void setParent(Node<V> parent) {
            assert (this.parent == null) : this.parent + " vs. " + parent;
            this.parent = Objects.requireNonNull(parent, "parent");
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).add("path", this.path).add("type", (Object)this.type).add("parent", this.parent == null ? "(null)" : this.parent.path + '#' + (Object)((Object)this.parent.type));
            this.children.values().forEach(child -> toStringHelper.add("child", child.path + '#' + (Object)((Object)child.type)));
            toStringHelper.add("values", this.values);
            return toStringHelper.toString();
        }
    }

    @FunctionalInterface
    static interface NodeProcessor<V> {
        public static <V> NodeProcessor<V> noop() {
            return node -> node;
        }

        @Nullable
        public Node<V> process(Node<V> var1);
    }

    private static class IntHolder {
        int value;

        private IntHolder() {
        }
    }

    static enum NodeType {
        EXACT,
        PARAMETER,
        CATCH_ALL;

    }
}

