/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.server.AggregatingDecodedHttpRequest;
import com.linecorp.armeria.server.EmptyContentDecodedHttpRequest;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.StreamingDecodedHttpRequest;
import io.netty.channel.EventLoop;

interface DecodedHttpRequest
extends HttpRequest {
    public static DecodedHttpRequest of(boolean endOfStream, EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, InboundTrafficController inboundTrafficController, RoutingContext routingCtx) {
        long requestStartTimeNanos = System.nanoTime();
        long requestStartTimeMicros = SystemInfo.currentTimeMicros();
        if (!routingCtx.hasResult()) {
            return new EmptyContentDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, routingCtx, ExchangeType.RESPONSE_STREAMING, requestStartTimeNanos, requestStartTimeMicros);
        }
        ServiceConfig config = routingCtx.result().value();
        HttpService service = config.service();
        ExchangeType exchangeType = service.exchangeType(routingCtx);
        if (endOfStream) {
            return new EmptyContentDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros);
        }
        if (exchangeType.isRequestStreaming()) {
            return new StreamingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, inboundTrafficController, config.maxRequestLength(), routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros, false, false);
        }
        return new AggregatingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, config.maxRequestLength(), routingCtx, exchangeType, requestStartTimeNanos, requestStartTimeMicros);
    }

    public int id();

    public int streamId();

    public boolean isKeepAlive();

    public void init(ServiceRequestContext var1);

    public boolean isInitialized();

    public RoutingContext routingContext();

    @Nullable
    public Routed<ServiceConfig> route();

    public void close();

    public void close(Throwable var1);

    public void setResponse(HttpResponse var1);

    public void abortResponse(Throwable var1, boolean var2);

    public boolean isResponseAborted();

    public boolean needsAggregation();

    public ExchangeType exchangeType();

    public long requestStartTimeNanos();

    public long requestStartTimeMicros();

    default public boolean isHttp1WebSocket() {
        return false;
    }

    default public StreamingDecodedHttpRequest toAbortedStreaming(InboundTrafficController inboundTrafficController, Throwable cause, boolean shouldResetOnlyIfRemoteIsOpen) {
        throw new UnsupportedOperationException();
    }

    default public void setShouldResetOnlyIfRemoteIsOpen(boolean shouldResetOnlyIfRemoteIsOpen) {
    }

    default public boolean shouldResetOnlyIfRemoteIsOpen() {
        return false;
    }
}

