/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.DependencyInjector;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceElement;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceExtensions;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceFactory;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.AnnotatedServiceConfigSetters;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.DefaultServiceConfigSetters;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceErrorHandler;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import io.netty.channel.EventLoopGroup;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.function.Supplier;

@UnstableApi
abstract class AbstractAnnotatedServiceConfigSetters
implements AnnotatedServiceConfigSetters {
    private final DefaultServiceConfigSetters defaultServiceConfigSetters = new DefaultServiceConfigSetters();
    private final ImmutableList.Builder<ExceptionHandlerFunction> exceptionHandlerFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<RequestConverterFunction> requestConverterFunctionBuilder = ImmutableList.builder();
    private final ImmutableList.Builder<ResponseConverterFunction> responseConverterFunctionBuilder = ImmutableList.builder();
    @Nullable
    private String queryDelimiter;
    private boolean useBlockingTaskExecutor;
    private String pathPrefix = "/";
    @Nullable
    private Object service;
    private Set<String> contextPaths = Collections.singleton("/");

    AbstractAnnotatedServiceConfigSetters() {
    }

    final void service(Object service) {
        this.service = Objects.requireNonNull(service, "service");
    }

    final void contextPaths(Set<String> contextPaths) {
        this.contextPaths = Objects.requireNonNull(contextPaths, "contextPaths");
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters pathPrefix(String pathPrefix) {
        this.pathPrefix = Objects.requireNonNull(pathPrefix, "pathPrefix");
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters exceptionHandlers(ExceptionHandlerFunction ... exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.add(exceptionHandlerFunctions);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters exceptionHandlers(Iterable<? extends ExceptionHandlerFunction> exceptionHandlerFunctions) {
        Objects.requireNonNull(exceptionHandlerFunctions, "exceptionHandlerFunctions");
        this.exceptionHandlerFunctionBuilder.addAll(exceptionHandlerFunctions);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters responseConverters(ResponseConverterFunction ... responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.add(responseConverterFunctions);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters responseConverters(Iterable<? extends ResponseConverterFunction> responseConverterFunctions) {
        Objects.requireNonNull(responseConverterFunctions, "responseConverterFunctions");
        this.responseConverterFunctionBuilder.addAll(responseConverterFunctions);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters requestConverters(RequestConverterFunction ... requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.add(requestConverterFunctions);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters requestConverters(Iterable<? extends RequestConverterFunction> requestConverterFunctions) {
        Objects.requireNonNull(requestConverterFunctions, "requestConverterFunctions");
        this.requestConverterFunctionBuilder.addAll(requestConverterFunctions);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    @UnstableApi
    public AbstractAnnotatedServiceConfigSetters queryDelimiter(String delimiter) {
        this.queryDelimiter = Objects.requireNonNull(delimiter, "delimiter");
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters decorator(DecoratingHttpServiceFunction decoratingHttpServiceFunction) {
        return (AbstractAnnotatedServiceConfigSetters)AnnotatedServiceConfigSetters.super.decorator(decoratingHttpServiceFunction);
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        this.defaultServiceConfigSetters.decorator(decorator);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        this.defaultServiceConfigSetters.decorators(decorators);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters requestTimeout(Duration requestTimeout) {
        this.defaultServiceConfigSetters.requestTimeout(requestTimeout);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters requestTimeoutMillis(long requestTimeoutMillis) {
        this.defaultServiceConfigSetters.requestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters maxRequestLength(long maxRequestLength) {
        this.defaultServiceConfigSetters.maxRequestLength(maxRequestLength);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters verboseResponses(boolean verboseResponses) {
        this.defaultServiceConfigSetters.verboseResponses(verboseResponses);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters accessLogFormat(String accessLogFormat) {
        this.defaultServiceConfigSetters.accessLogFormat(accessLogFormat);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.accessLogWriter(accessLogWriter, shutdownOnStop);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters defaultServiceName(String defaultServiceName) {
        this.defaultServiceConfigSetters.defaultServiceName(defaultServiceName);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceConfigSetters.defaultServiceNaming(defaultServiceNaming);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters defaultLogName(String defaultLogName) {
        this.defaultServiceConfigSetters.defaultLogName(defaultLogName);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters blockingTaskExecutor(BlockingTaskExecutor blockingTaskExecutor, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.blockingTaskExecutor(blockingTaskExecutor, shutdownOnStop);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters successFunction(SuccessFunction successFunction) {
        this.defaultServiceConfigSetters.successFunction(successFunction);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters requestAutoAbortDelay(Duration delay) {
        this.defaultServiceConfigSetters.requestAutoAbortDelay(delay);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters requestAutoAbortDelayMillis(long delayMillis) {
        this.defaultServiceConfigSetters.requestAutoAbortDelayMillis(delayMillis);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters multipartUploadsLocation(Path multipartUploadsLocation) {
        this.defaultServiceConfigSetters.multipartUploadsLocation(multipartUploadsLocation);
        return this;
    }

    @Override
    public ServiceConfigSetters serviceWorkerGroup(EventLoopGroup serviceWorkerGroup, boolean shutdownOnStop) {
        this.defaultServiceConfigSetters.serviceWorkerGroup(serviceWorkerGroup, shutdownOnStop);
        return this;
    }

    @Override
    public ServiceConfigSetters serviceWorkerGroup(int numThreads) {
        this.defaultServiceConfigSetters.serviceWorkerGroup(numThreads);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters requestIdGenerator(Function<? super RoutingContext, ? extends RequestId> requestIdGenerator) {
        this.defaultServiceConfigSetters.requestIdGenerator(requestIdGenerator);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters addHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.addHeader(name, value);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.addHeaders(defaultHeaders);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters setHeader(CharSequence name, Object value) {
        this.defaultServiceConfigSetters.setHeader(name, value);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> defaultHeaders) {
        this.defaultServiceConfigSetters.setHeaders(defaultHeaders);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters errorHandler(ServiceErrorHandler serviceErrorHandler) {
        this.defaultServiceConfigSetters.errorHandler(serviceErrorHandler);
        return this;
    }

    @Override
    public AbstractAnnotatedServiceConfigSetters contextHook(Supplier<? extends AutoCloseable> contextHook) {
        this.defaultServiceConfigSetters.contextHook(contextHook);
        return this;
    }

    final List<ServiceConfigBuilder> buildServiceConfigBuilder(AnnotatedServiceExtensions extensions, DependencyInjector dependencyInjector) {
        ImmutableCollection requestConverterFunctions = ((ImmutableList.Builder)this.requestConverterFunctionBuilder.addAll(extensions.requestConverters())).build();
        ImmutableCollection responseConverterFunctions = ((ImmutableList.Builder)this.responseConverterFunctionBuilder.addAll(extensions.responseConverters())).build();
        ImmutableCollection exceptionHandlerFunctions = ((ImmutableList.Builder)this.exceptionHandlerFunctionBuilder.addAll(extensions.exceptionHandlers())).build();
        assert (this.service != null);
        List<AnnotatedServiceElement> elements = AnnotatedServiceFactory.find(this.pathPrefix, this.service, this.useBlockingTaskExecutor, (List<RequestConverterFunction>)((Object)requestConverterFunctions), (List<ResponseConverterFunction>)((Object)responseConverterFunctions), (List<ExceptionHandlerFunction>)((Object)exceptionHandlerFunctions), dependencyInjector, this.queryDelimiter);
        return elements.stream().flatMap(element -> {
            HttpService decoratedService = element.buildSafeDecoratedService(this.defaultServiceConfigSetters.decorator());
            assert (!this.contextPaths.isEmpty()) : "contextPaths shouldn't be empty";
            return this.contextPaths.stream().map(contextPath -> this.defaultServiceConfigSetters.toServiceConfigBuilder(element.route(), (String)contextPath, decoratedService));
        }).collect(ImmutableList.toImmutableList());
    }
}

