/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.endpoint;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.endpoint.EndpointSelectionStrategy;
import com.linecorp.armeria.client.endpoint.EndpointSelector;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

public final class StaticEndpointGroup
implements EndpointGroup {
    public static final StaticEndpointGroup EMPTY = new StaticEndpointGroup(new EmptyEndpointSelectionStrategy(), ImmutableList.of());
    private final List<Endpoint> endpoints;
    private final CompletableFuture<List<Endpoint>> initialEndpointsFuture;
    private final EndpointSelectionStrategy selectionStrategy;
    private final EndpointSelector selector;

    public StaticEndpointGroup(EndpointSelectionStrategy selectionStrategy, Iterable<Endpoint> endpoints) {
        this.endpoints = ImmutableList.copyOf(Objects.requireNonNull(endpoints, "endpoints"));
        this.initialEndpointsFuture = UnmodifiableFuture.completedFuture(this.endpoints);
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
        this.selector = selectionStrategy.newSelector(this);
    }

    @Override
    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    @Override
    public void addListener(Consumer<? super List<Endpoint>> listener, boolean notifyLatestEndpoints) {
        if (notifyLatestEndpoints) {
            listener.accept(this.endpoints);
        }
    }

    @Override
    public EndpointSelectionStrategy selectionStrategy() {
        return this.selectionStrategy;
    }

    @Override
    public Endpoint selectNow(ClientRequestContext ctx) {
        return this.selector.selectNow(ctx);
    }

    @Override
    @Deprecated
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
        return this.select(ctx, executor);
    }

    @Override
    public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor) {
        return UnmodifiableFuture.completedFuture(this.selectNow(ctx));
    }

    @Override
    public long selectionTimeoutMillis() {
        return 0L;
    }

    @Override
    public CompletableFuture<List<Endpoint>> whenReady() {
        return this.initialEndpointsFuture;
    }

    @Override
    public CompletableFuture<?> closeAsync() {
        return UnmodifiableFuture.completedFuture(null);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return StaticEndpointGroup.class.getSimpleName() + this.endpoints;
    }

    private static final class EmptyEndpointSelectionStrategy
    implements EndpointSelectionStrategy {
        private EmptyEndpointSelectionStrategy() {
        }

        @Override
        public EndpointSelector newSelector(EndpointGroup endpointGroup) {
            return EmptyEndpointSelector.INSTANCE;
        }
    }

    private static final class EmptyEndpointSelector
    implements EndpointSelector {
        static final EmptyEndpointSelector INSTANCE = new EmptyEndpointSelector();

        private EmptyEndpointSelector() {
        }

        @Override
        @Nullable
        public Endpoint selectNow(ClientRequestContext ctx) {
            return null;
        }

        @Override
        @Deprecated
        public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor, long timeoutMillis) {
            return this.select(ctx, executor);
        }

        @Override
        public CompletableFuture<Endpoint> select(ClientRequestContext ctx, ScheduledExecutorService executor) {
            return UnmodifiableFuture.completedFuture(null);
        }
    }
}

