/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.common.AggregatedHttpMessage;
import com.linecorp.armeria.common.DefaultAggregatedHttpResponse;
import com.linecorp.armeria.common.FixedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public interface AggregatedHttpResponse
extends AggregatedHttpMessage {
    public static AggregatedHttpResponse of(int statusCode) {
        return AggregatedHttpResponse.of(HttpStatus.valueOf(statusCode));
    }

    public static AggregatedHttpResponse of(HttpStatus status) {
        Objects.requireNonNull(status, "status");
        Preconditions.checkArgument(!status.isInformational(), "status: %s (expected: a non-1xx status)", (Object)status);
        if (status.isContentAlwaysEmpty()) {
            return AggregatedHttpResponse.of(ResponseHeaders.of(status));
        }
        return AggregatedHttpResponse.of(status, MediaType.PLAIN_TEXT_UTF_8, status.toHttpData());
    }

    public static AggregatedHttpResponse of(HttpStatus status, MediaType mediaType, CharSequence content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpResponse.of(status, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    public static AggregatedHttpResponse of(HttpStatus status, MediaType mediaType, String content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpResponse.of(status, mediaType, HttpData.of(mediaType.charset(StandardCharsets.UTF_8), content));
    }

    @FormatMethod
    public static AggregatedHttpResponse of(HttpStatus status, MediaType mediaType, @FormatString String format, Object ... args) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        return AggregatedHttpResponse.of(status, mediaType, String.format(Locale.ENGLISH, format, args).getBytes(mediaType.charset(StandardCharsets.UTF_8)));
    }

    public static AggregatedHttpResponse of(HttpStatus status, MediaType mediaType, byte[] content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpResponse.of(status, mediaType, HttpData.wrap(content));
    }

    public static AggregatedHttpResponse of(HttpStatus status, MediaType mediaType, HttpData content) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpResponse.of(status, mediaType, content, HttpHeaders.of());
    }

    public static AggregatedHttpResponse of(HttpStatus status, MediaType mediaType, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(mediaType, "mediaType");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        ResponseHeaders headers = ResponseHeaders.builder(status).contentType(mediaType).build();
        return AggregatedHttpResponse.of(headers, content, trailers);
    }

    public static AggregatedHttpResponse of(ResponseHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        return AggregatedHttpResponse.of(headers, HttpData.empty(), HttpHeaders.of());
    }

    public static AggregatedHttpResponse of(ResponseHeaders headers, HttpData content) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        return AggregatedHttpResponse.of(headers, content, HttpHeaders.of());
    }

    public static AggregatedHttpResponse of(ResponseHeaders headers, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        return AggregatedHttpResponse.of(ImmutableList.of(), headers, content, trailers);
    }

    public static AggregatedHttpResponse of(Iterable<ResponseHeaders> informationals, ResponseHeaders headers, HttpData content, HttpHeaders trailers) {
        Objects.requireNonNull(informationals, "informationals");
        Objects.requireNonNull(headers, "headers");
        HttpStatus status = headers.status();
        Preconditions.checkArgument(!status.isInformational(), "status: %s (expected: a non-1xx status)", (Object)status);
        Objects.requireNonNull(content, "content");
        Objects.requireNonNull(trailers, "trailers");
        ResponseHeaders newHeaders = ArmeriaHttpUtil.maybeUpdateContentLengthAndEndOfStream(headers, content, trailers, true);
        return new DefaultAggregatedHttpResponse(ImmutableList.copyOf(informationals), newHeaders, content, trailers);
    }

    @Override
    public ResponseHeaders headers();

    public List<ResponseHeaders> informationals();

    public HttpStatus status();

    default public HttpResponse toHttpResponse() {
        List<ResponseHeaders> informationals = this.informationals();
        ResponseHeaders headers = this.headers();
        HttpData content = this.content();
        HttpHeaders trailers = this.trailers();
        if (informationals.isEmpty()) {
            return HttpResponse.of(headers, content, trailers);
        }
        int numObjects = informationals.size() + 1 + (!content.isEmpty() ? 1 : 0) + (!trailers.isEmpty() ? 1 : 0);
        HttpObject[] objs = new HttpObject[numObjects];
        int writerIndex = 0;
        for (ResponseHeaders informational : informationals) {
            objs[writerIndex++] = informational;
        }
        objs[writerIndex++] = headers;
        if (!content.isEmpty()) {
            objs[writerIndex++] = content;
        }
        if (!trailers.isEmpty()) {
            objs[writerIndex] = trailers;
        }
        return new FixedHttpResponse.RegularFixedHttpResponse(objs);
    }
}

