/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Http2ClientKeepAliveHandler;
import com.linecorp.armeria.client.Http2ResponseDecoder;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.metric.MoreMeters;
import com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandler;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.KeepAliveHandlerUtil;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;

final class Http2ClientConnectionHandler
extends AbstractHttp2ConnectionHandler {
    private final HttpClientFactory clientFactory;
    private final Http2ResponseDecoder responseDecoder;

    Http2ClientConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, Channel channel, HttpClientFactory clientFactory, SessionProtocol protocol) {
        super(decoder, encoder, initialSettings, Http2ClientConnectionHandler.newKeepAliveHandler(encoder, channel, clientFactory, protocol));
        this.clientFactory = clientFactory;
        this.responseDecoder = new Http2ResponseDecoder(channel, this.encoder(), clientFactory, this.keepAliveHandler());
        this.connection().addListener((Http2Connection.Listener)this.responseDecoder);
        this.decoder().frameListener((Http2FrameListener)this.responseDecoder);
    }

    private static KeepAliveHandler newKeepAliveHandler(Http2ConnectionEncoder encoder, Channel channel, HttpClientFactory clientFactory, SessionProtocol protocol) {
        int maxNumRequestsPerConnection;
        long maxConnectionAgeMillis;
        long idleTimeoutMillis = clientFactory.idleTimeoutMillis();
        boolean keepAliveOnPing = clientFactory.keepAliveOnPing();
        long pingIntervalMillis = clientFactory.pingIntervalMillis();
        boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis = clientFactory.maxConnectionAgeMillis(), maxNumRequestsPerConnection = clientFactory.maxNumRequestsPerConnection());
        if (!needsKeepAliveHandler) {
            return new NoopKeepAliveHandler();
        }
        Timer keepAliveTimer = MoreMeters.newTimer(clientFactory.meterRegistry(), "armeria.client.connections.lifespan", ImmutableList.of(Tag.of((String)"protocol", (String)protocol.uriText())));
        return new Http2ClientKeepAliveHandler(channel, encoder.frameWriter(), keepAliveTimer, idleTimeoutMillis, pingIntervalMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection, keepAliveOnPing);
    }

    Http2ResponseDecoder responseDecoder() {
        return this.responseDecoder;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.handlerAdded(ctx);
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.handlerRemoved0(ctx);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelActive(ctx);
        ctx.flush();
    }

    @Override
    protected boolean needsImmediateDisconnection() {
        return this.clientFactory.isClosing() || this.responseDecoder.goAwayHandler().receivedErrorGoAway() || this.keepAliveHandler().isClosing();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.channelInactive(ctx);
    }

    private void maybeInitializeKeepAliveHandler(ChannelHandlerContext ctx) {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.keepAliveHandler().initialize(ctx);
        }
    }

    private void destroyKeepAliveHandler() {
        this.keepAliveHandler().destroy();
    }
}

