/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.cache.processor.EntryProcessor;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.GridNearAtomicSingleUpdateRequest;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridNearAtomicSingleUpdateInvokeRequest
extends GridNearAtomicSingleUpdateRequest {
    private static final long serialVersionUID = 0L;
    @GridDirectTransient
    private Object[] invokeArgs;
    private byte[][] invokeArgsBytes;
    @GridDirectTransient
    private EntryProcessor<Object, Object, Object> entryProcessor;
    private byte[] entryProcessorBytes;

    public GridNearAtomicSingleUpdateInvokeRequest() {
    }

    GridNearAtomicSingleUpdateInvokeRequest(int cacheId, UUID nodeId, long futId, @NotNull AffinityTopologyVersion topVer, CacheWriteSynchronizationMode syncMode, GridCacheOperation op, @Nullable Object[] invokeArgs, @Nullable UUID subjId, int taskNameHash, byte flags, boolean addDepInfo) {
        super(cacheId, nodeId, futId, topVer, syncMode, op, subjId, taskNameHash, flags, addDepInfo);
        assert (op == GridCacheOperation.TRANSFORM) : op;
        this.invokeArgs = invokeArgs;
    }

    @Override
    public void addUpdateEntry(KeyCacheObject key, @Nullable Object val, long conflictTtl, long conflictExpireTime, @Nullable GridCacheVersion conflictVer) {
        assert (conflictTtl < 0L) : conflictTtl;
        assert (conflictExpireTime < 0L) : conflictExpireTime;
        assert (conflictVer == null) : conflictVer;
        assert (val instanceof EntryProcessor) : val;
        this.entryProcessor = (EntryProcessor)val;
        this.key = key;
    }

    @Override
    public List<?> values() {
        return Collections.singletonList(this.entryProcessor);
    }

    @Override
    public CacheObject value(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    public EntryProcessor<Object, Object, Object> entryProcessor(int idx) {
        assert (idx == 0) : idx;
        return this.entryProcessor;
    }

    @Override
    public CacheObject writeValue(int idx) {
        assert (idx == 0) : idx;
        return null;
    }

    @Override
    @Nullable
    public Object[] invokeArguments() {
        return this.invokeArgs;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        GridCacheContext cctx = ctx.cacheContext(this.cacheId);
        if (!this.addDepInfo && ctx.deploymentEnabled()) {
            this.addDepInfo = true;
        }
        if (this.entryProcessor != null && this.entryProcessorBytes == null) {
            if (this.addDepInfo) {
                this.prepareObject(this.entryProcessor, cctx);
            }
            this.entryProcessorBytes = CU.marshal(cctx, this.entryProcessor);
        }
        if (this.invokeArgsBytes == null) {
            this.invokeArgsBytes = this.marshalInvokeArguments(this.invokeArgs, cctx);
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.entryProcessorBytes != null && this.entryProcessor == null) {
            this.entryProcessor = (EntryProcessor)U.unmarshal(ctx, this.entryProcessorBytes, U.resolveClassLoader(ldr, ctx.gridConfig()));
        }
        if (this.invokeArgs == null) {
            this.invokeArgs = this.unmarshalInvokeArguments(this.invokeArgsBytes, ctx, ldr);
        }
    }

    @Override
    public void cleanup(boolean clearKey) {
        super.cleanup(clearKey);
        this.entryProcessor = null;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 13: {
                if (!writer.writeByteArray("entryProcessorBytes", this.entryProcessorBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeObjectArray("invokeArgsBytes", (T[])this.invokeArgsBytes, MessageCollectionItemType.BYTE_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 13: {
                this.entryProcessorBytes = reader.readByteArray("entryProcessorBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.invokeArgsBytes = reader.readObjectArray("invokeArgsBytes", MessageCollectionItemType.BYTE_ARR, byte[].class);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridNearAtomicSingleUpdateInvokeRequest.class);
    }

    @Override
    public byte fieldsCount() {
        return 15;
    }

    @Override
    public short directType() {
        return 126;
    }

    @Override
    public String toString() {
        return S.toString(GridNearAtomicSingleUpdateRequest.class, this, super.toString());
    }
}

