/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.CacheInterceptorEntry;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheLazyEntry<K, V>
extends CacheInterceptorEntry<K, V> {
    protected final GridCacheContext cctx;
    private final boolean keepBinary;
    protected KeyCacheObject keyObj;
    protected CacheObject valObj;
    @GridToStringInclude(sensitive=true)
    protected K key;
    @GridToStringInclude(sensitive=true)
    protected V val;
    private Long updateCntr;

    public CacheLazyEntry(GridCacheContext cctx, KeyCacheObject keyObj, CacheObject valObj, boolean keepBinary) {
        this(cctx, keyObj, null, valObj, null, keepBinary, null);
    }

    public CacheLazyEntry(GridCacheContext cctx, KeyCacheObject keyObj, V val, boolean keepBinary) {
        this(cctx, keyObj, null, null, val, keepBinary, null);
    }

    public CacheLazyEntry(GridCacheContext ctx, KeyCacheObject keyObj, K key, CacheObject valObj, V val, boolean keepBinary) {
        this(ctx, keyObj, key, valObj, val, keepBinary, null);
    }

    public CacheLazyEntry(GridCacheContext ctx, KeyCacheObject keyObj, K key, CacheObject valObj, V val, boolean keepBinary, Long updateCntr) {
        this.cctx = ctx;
        this.keyObj = keyObj;
        this.key = key;
        this.valObj = valObj;
        this.val = val;
        this.keepBinary = keepBinary;
        this.updateCntr = updateCntr;
    }

    public K getKey() {
        if (this.key == null) {
            this.key = this.cctx.unwrapBinaryIfNeeded(this.keyObj, this.keepBinary, U.deploymentClassLoader(this.cctx.kernalContext(), U.contextDeploymentClassLoaderId(this.cctx.kernalContext())));
        }
        return this.key;
    }

    public V getValue() {
        return this.getValue(this.keepBinary);
    }

    public V getValue(boolean keepBinary) {
        if (this.val == null) {
            this.val = this.cctx.unwrapBinaryIfNeeded(this.valObj, keepBinary, true, U.deploymentClassLoader(this.cctx.kernalContext(), U.contextDeploymentClassLoaderId(this.cctx.kernalContext())));
        }
        return this.val;
    }

    public V value() {
        return this.val;
    }

    public K key() {
        return this.key;
    }

    public boolean keepBinary() {
        return this.keepBinary;
    }

    @Override
    public long getPartitionUpdateCounter() {
        return this.updateCntr == null ? 0L : this.updateCntr;
    }

    public void updateCounter(long updateCntr) {
        this.updateCntr = updateCntr;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(Ignite.class)) {
            return (T)this.cctx.kernalContext().grid();
        }
        if (cls.isAssignableFrom(GridCacheContext.class)) {
            return (T)this.cctx;
        }
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to class is not supported: " + cls);
    }

    public String toString() {
        return S.toString(CacheLazyEntry.class, this);
    }
}

