/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.DeltaApplicationException;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class ReplaceRecord<L>
extends PageDeltaRecord {
    private BPlusIO<L> io;
    private byte[] rowBytes;
    private int idx;

    public ReplaceRecord(int grpId, long pageId, BPlusIO<L> io, byte[] rowBytes, int idx) {
        super(grpId, pageId);
        this.io = io;
        this.rowBytes = rowBytes;
        this.idx = idx;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        if (this.io.getCount(pageAddr) < this.idx) {
            throw new DeltaApplicationException("Index is greater than count: " + this.idx);
        }
        this.io.store(pageAddr, this.idx, null, this.rowBytes, false);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_PAGE_REPLACE;
    }

    public BPlusIO<L> io() {
        return this.io;
    }

    public int index() {
        return this.idx;
    }

    public byte[] rowBytes() {
        return this.rowBytes;
    }

    @Override
    public String toString() {
        return S.toString(ReplaceRecord.class, this, "super", (Object)super.toString());
    }
}

