/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import javax.cache.Cache;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryEventFilter;
import org.apache.ignite.cache.query.Query;

public abstract class AbstractContinuousQuery<K, V>
extends Query<Cache.Entry<K, V>> {
    public static final int DFLT_PAGE_SIZE = 1;
    public static final long DFLT_TIME_INTERVAL = 0L;
    public static final boolean DFLT_AUTO_UNSUBSCRIBE = true;
    private Query<Cache.Entry<K, V>> initQry;
    private Factory<? extends CacheEntryEventFilter<K, V>> rmtFilterFactory;
    private long timeInterval = 0L;
    private boolean autoUnsubscribe = true;
    private boolean includeExpired;

    public AbstractContinuousQuery<K, V> setInitialQuery(Query<Cache.Entry<K, V>> initQry) {
        this.initQry = initQry;
        return this;
    }

    public Query<Cache.Entry<K, V>> getInitialQuery() {
        return this.initQry;
    }

    public AbstractContinuousQuery<K, V> setRemoteFilterFactory(Factory<? extends CacheEntryEventFilter<K, V>> rmtFilterFactory) {
        this.rmtFilterFactory = rmtFilterFactory;
        return this;
    }

    public Factory<? extends CacheEntryEventFilter<K, V>> getRemoteFilterFactory() {
        return this.rmtFilterFactory;
    }

    public AbstractContinuousQuery<K, V> setTimeInterval(long timeInterval) {
        if (timeInterval < 0L) {
            throw new IllegalArgumentException("Time interval can't be negative.");
        }
        this.timeInterval = timeInterval;
        return this;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public AbstractContinuousQuery<K, V> setAutoUnsubscribe(boolean autoUnsubscribe) {
        this.autoUnsubscribe = autoUnsubscribe;
        return this;
    }

    public boolean isAutoUnsubscribe() {
        return this.autoUnsubscribe;
    }

    public void setIncludeExpired(boolean includeExpired) {
        this.includeExpired = includeExpired;
    }

    public boolean isIncludeExpired() {
        return this.includeExpired;
    }
}

