/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.io;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketOption;
import javax.net.ServerSocketFactory;
import org.apache.hc.core5.io.SocketSupport;
import org.apache.hc.core5.util.ReflectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSocketSupport {
    @Test
    public void testGetExtendedSocketOptionOrNull() {
        this.testGetExtendedSocketOption("TCP_KEEPIDLE");
        this.testGetExtendedSocketOption("TCP_KEEPINTERVAL");
        this.testGetExtendedSocketOption("TCP_KEEPCOUNT");
    }

    private <T> void testGetExtendedSocketOption(String option) {
        SocketOption socketOption = SocketSupport.getExtendedSocketOptionOrNull((String)option);
        if (ReflectionUtils.determineJRELevel() > 8 && !TestSocketSupport.isWindows()) {
            Assertions.assertNotNull((Object)socketOption);
        }
    }

    @Test
    public void testSetOption() throws IOException {
        if (ReflectionUtils.determineJRELevel() > 8 && !TestSocketSupport.isWindows()) {
            Socket sock = new Socket();
            SocketSupport.setOption((Object)sock, (String)"TCP_KEEPIDLE", (Object)20);
            SocketSupport.setOption((Object)sock, (String)"TCP_KEEPINTERVAL", (Object)21);
            SocketSupport.setOption((Object)sock, (String)"TCP_KEEPCOUNT", (Object)22);
            SocketOption tcpKeepIdle = SocketSupport.getExtendedSocketOptionOrNull((String)"TCP_KEEPIDLE");
            assert (tcpKeepIdle != null);
            Assertions.assertEquals((int)20, (Integer)((Integer)ReflectionUtils.callGetter((Object)sock, (String)"Option", (Object)tcpKeepIdle, SocketOption.class, Integer.class)));
            SocketOption tcpKeepInterval = SocketSupport.getExtendedSocketOptionOrNull((String)"TCP_KEEPINTERVAL");
            assert (tcpKeepInterval != null);
            Assertions.assertEquals((int)21, (Integer)((Integer)ReflectionUtils.callGetter((Object)sock, (String)"Option", (Object)tcpKeepInterval, SocketOption.class, Integer.class)));
            SocketOption tcpKeepCount = SocketSupport.getExtendedSocketOptionOrNull((String)"TCP_KEEPCOUNT");
            assert (tcpKeepCount != null);
            Assertions.assertEquals((int)22, (Integer)((Integer)ReflectionUtils.callGetter((Object)sock, (String)"Option", (Object)tcpKeepCount, SocketOption.class, Integer.class)));
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket();
            SocketSupport.setOption((Object)serverSocket, (String)"TCP_KEEPIDLE", (Object)20);
            SocketSupport.setOption((Object)serverSocket, (String)"TCP_KEEPINTERVAL", (Object)21);
            SocketSupport.setOption((Object)serverSocket, (String)"TCP_KEEPCOUNT", (Object)22);
            tcpKeepIdle = SocketSupport.getExtendedSocketOptionOrNull((String)"TCP_KEEPIDLE");
            assert (tcpKeepIdle != null);
            Assertions.assertEquals((int)20, (Integer)((Integer)ReflectionUtils.callGetter((Object)serverSocket, (String)"Option", (Object)tcpKeepIdle, SocketOption.class, Integer.class)));
            tcpKeepInterval = SocketSupport.getExtendedSocketOptionOrNull((String)"TCP_KEEPINTERVAL");
            assert (tcpKeepInterval != null);
            Assertions.assertEquals((int)21, (Integer)((Integer)ReflectionUtils.callGetter((Object)serverSocket, (String)"Option", (Object)tcpKeepInterval, SocketOption.class, Integer.class)));
            tcpKeepCount = SocketSupport.getExtendedSocketOptionOrNull((String)"TCP_KEEPCOUNT");
            assert (tcpKeepCount != null);
            Assertions.assertEquals((int)22, (Integer)((Integer)ReflectionUtils.callGetter((Object)serverSocket, (String)"Option", (Object)tcpKeepCount, SocketOption.class, Integer.class)));
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }
}

