/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.protocol.ChainBuilder;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestChainBuilder {
    TestChainBuilder() {
    }

    @Test
    void testBuildChain() {
        ChainBuilder cb = new ChainBuilder();
        HttpRequestInterceptor i1 = RequestContent.INSTANCE;
        HttpRequestInterceptor i2 = RequestTargetHost.INSTANCE;
        HttpRequestInterceptor i3 = RequestConnControl.INSTANCE;
        HttpRequestInterceptor i4 = RequestUserAgent.INSTANCE;
        RequestExpectContinue i5 = RequestExpectContinue.INSTANCE;
        cb.addFirst((Object)i1);
        cb.addAllFirst((Object[])new HttpRequestInterceptor[]{i2, i3});
        cb.addFirst(null);
        cb.addAllFirst((Collection)null);
        cb.addLast((Object)i4);
        cb.addLast(null);
        cb.addAllLast((Object[])new HttpRequestInterceptor[]{i5});
        cb.addAllLast((Collection)null);
        cb.addFirst((Object)i1);
        cb.addAllLast((Object[])new HttpRequestInterceptor[]{i3, i4, i5});
        LinkedList list = cb.build();
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)5, (int)list.size());
        Assertions.assertSame((Object)i1, list.get(0));
        Assertions.assertSame((Object)i2, list.get(1));
        Assertions.assertSame((Object)i3, list.get(2));
        Assertions.assertSame((Object)i4, list.get(3));
        Assertions.assertSame((Object)i5, list.get(4));
    }
}

