/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.examples;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ExceptionListener;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.impl.Http1StreamListener;
import org.apache.hc.core5.http.impl.bootstrap.HttpRequester;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.RequesterBootstrap;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.ConnPoolListener;
import org.apache.hc.core5.pool.ConnPoolStats;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class ClassicReverseProxyExample {
    private static final Set<String> HOP_BY_HOP = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(TextUtils.toLowerCase((String)"Host"), TextUtils.toLowerCase((String)"Content-Length"), TextUtils.toLowerCase((String)"Transfer-Encoding"), TextUtils.toLowerCase((String)"Connection"), TextUtils.toLowerCase((String)"Keep-Alive"), TextUtils.toLowerCase((String)"Proxy-Authenticate"), TextUtils.toLowerCase((String)"TE"), TextUtils.toLowerCase((String)"Trailer"), TextUtils.toLowerCase((String)"Upgrade"))));

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: <hostname[:port]> [listener port]");
            System.exit(1);
        }
        HttpHost targetHost = HttpHost.create((String)args[0]);
        int port = 8080;
        if (args.length > 1) {
            port = Integer.parseInt(args[1]);
        }
        System.out.println("Reverse proxy to " + targetHost);
        HttpRequester requester = RequesterBootstrap.bootstrap().setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                System.out.println("[proxy->origin] " + Thread.currentThread() + " " + request.getMethod() + " " + request.getRequestUri());
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                System.out.println("[proxy<-origin] " + Thread.currentThread() + " status " + response.getCode());
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                System.out.println("[proxy<-origin] " + Thread.currentThread() + " exchange completed; connection " + (keepAlive ? "kept alive" : "cannot be kept alive"));
            }
        }).setConnPoolListener((ConnPoolListener)new ConnPoolListener<HttpHost>(){

            public void onLease(HttpHost route, ConnPoolStats<HttpHost> connPoolStats) {
                StringBuilder buf = new StringBuilder();
                buf.append("[proxy->origin] ").append(Thread.currentThread()).append(" connection leased ").append(route);
                System.out.println(buf);
            }

            public void onRelease(HttpHost route, ConnPoolStats<HttpHost> connPoolStats) {
                StringBuilder buf = new StringBuilder();
                buf.append("[proxy->origin] ").append(Thread.currentThread()).append(" connection released ").append(route);
                PoolStats totals = connPoolStats.getTotalStats();
                buf.append("; total kept alive: ").append(totals.getAvailable()).append("; ");
                buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
                buf.append(" of ").append(totals.getMax());
                System.out.println(buf);
            }
        }).create();
        HttpServer server = ServerBootstrap.bootstrap().setListenerPort(port).setStreamListener(new Http1StreamListener(){

            public void onRequestHead(HttpConnection connection, HttpRequest request) {
                System.out.println("[client->proxy] " + Thread.currentThread() + " " + request.getMethod() + " " + request.getRequestUri());
            }

            public void onResponseHead(HttpConnection connection, HttpResponse response) {
                System.out.println("[client<-proxy] " + Thread.currentThread() + " status " + response.getCode());
            }

            public void onExchangeComplete(HttpConnection connection, boolean keepAlive) {
                System.out.println("[client<-proxy] " + Thread.currentThread() + " exchange completed; connection " + (keepAlive ? "kept alive" : "cannot be kept alive"));
            }
        }).setExceptionListener(new ExceptionListener(){

            public void onError(Exception ex) {
                if (ex instanceof SocketException) {
                    System.out.println("[client->proxy] " + Thread.currentThread() + " " + ex.getMessage());
                } else {
                    System.out.println("[client->proxy] " + Thread.currentThread() + " " + ex.getMessage());
                    ex.printStackTrace(System.out);
                }
            }

            public void onError(HttpConnection connection, Exception ex) {
                if (ex instanceof SocketTimeoutException) {
                    System.out.println("[client->proxy] " + Thread.currentThread() + " time out");
                } else if (ex instanceof SocketException || ex instanceof ConnectionClosedException) {
                    System.out.println("[client->proxy] " + Thread.currentThread() + " " + ex.getMessage());
                } else {
                    System.out.println("[client->proxy] " + Thread.currentThread() + " " + ex.getMessage());
                    ex.printStackTrace(System.out);
                }
            }
        }).register("*", (HttpRequestHandler)new ProxyHandler(targetHost, requester)).create();
        server.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            server.close(CloseMode.GRACEFUL);
            requester.close(CloseMode.GRACEFUL);
        }));
        System.out.println("Listening on port " + port);
        server.awaitTermination(TimeValue.MAX_VALUE);
    }

    static class ProxyHandler
    implements HttpRequestHandler {
        private final HttpHost targetHost;
        private final HttpRequester requester;

        public ProxyHandler(HttpHost targetHost, HttpRequester requester) {
            this.targetHost = targetHost;
            this.requester = requester;
        }

        public void handle(ClassicHttpRequest incomingRequest, ClassicHttpResponse outgoingResponse, HttpContext serverContext) throws HttpException, IOException {
            HttpCoreContext clientContext = HttpCoreContext.create();
            BasicClassicHttpRequest outgoingRequest = new BasicClassicHttpRequest(incomingRequest.getMethod(), this.targetHost, incomingRequest.getPath());
            Iterator it = incomingRequest.headerIterator();
            while (it.hasNext()) {
                Header header = (Header)it.next();
                if (HOP_BY_HOP.contains(TextUtils.toLowerCase((String)header.getName()))) continue;
                outgoingRequest.addHeader(header);
            }
            outgoingRequest.setEntity(incomingRequest.getEntity());
            ClassicHttpResponse incomingResponse = this.requester.execute(this.targetHost, (ClassicHttpRequest)outgoingRequest, Timeout.ofMinutes((long)1L), (HttpContext)clientContext);
            outgoingResponse.setCode(incomingResponse.getCode());
            Iterator it2 = incomingResponse.headerIterator();
            while (it2.hasNext()) {
                Header header = (Header)it2.next();
                if (HOP_BY_HOP.contains(TextUtils.toLowerCase((String)header.getName()))) continue;
                outgoingResponse.addHeader(header);
            }
            outgoingResponse.setEntity(incomingResponse.getEntity());
        }
    }
}

