/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.hooks.JDOConnectionURLHook;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreInit {
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreInit.class);

    static boolean updateConnectionURL(Configuration originalConf, Configuration activeConf, String badUrl, MetaStoreInitData updateData) throws MetaException {
        String connectUrl = null;
        String currentUrl = MetaStoreInit.getConnectionURL(activeConf);
        try {
            MetaStoreInit.initConnectionUrlHook(originalConf, updateData);
            if (updateData.urlHook != null) {
                if (badUrl != null) {
                    updateData.urlHook.notifyBadConnectionUrl(badUrl);
                }
                connectUrl = updateData.urlHook.getJdoConnectionUrl(originalConf);
            }
        }
        catch (Exception e) {
            LOG.error("Exception while getting connection URL from the hook: " + e);
        }
        if (connectUrl != null && !connectUrl.equals(currentUrl)) {
            LOG.error(String.format("Overriding %s with %s", MetastoreConf.ConfVars.CONNECT_URL_KEY.toString(), connectUrl));
            MetastoreConf.setVar((Configuration)activeConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)connectUrl);
            return true;
        }
        return false;
    }

    static String getConnectionURL(Configuration conf) {
        return MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)"");
    }

    private static synchronized void initConnectionUrlHook(Configuration conf, MetaStoreInitData updateData) throws ClassNotFoundException {
        boolean urlHookChanged;
        String className = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_HOOK, (String)"").trim();
        if (className.equals("")) {
            updateData.urlHookClassName = "";
            updateData.urlHook = null;
            return;
        }
        boolean bl = urlHookChanged = !updateData.urlHookClassName.equals(className);
        if (updateData.urlHook == null || urlHookChanged) {
            updateData.urlHookClassName = className.trim();
            Class<?> urlHookClass = Class.forName(updateData.urlHookClassName, true, JavaUtils.getClassLoader());
            updateData.urlHook = (JDOConnectionURLHook)ReflectionUtils.newInstance(urlHookClass, null);
        }
    }

    static class MetaStoreInitData {
        JDOConnectionURLHook urlHook = null;
        String urlHookClassName = "";

        MetaStoreInitData() {
        }
    }
}

