/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

public class FilesForCommit
implements Serializable {
    private final Collection<DataFile> dataFiles;
    private final Collection<DeleteFile> deleteFiles;
    private final Collection<DataFile> replacedDataFiles;
    private final Collection<CharSequence> referencedDataFiles;
    private final Collection<Path> mergedAndDeletedFiles;

    public FilesForCommit(Collection<DataFile> dataFiles, Collection<DeleteFile> deleteFiles) {
        this(dataFiles, deleteFiles, Collections.emptyList());
    }

    public FilesForCommit(Collection<DataFile> dataFiles, Collection<DeleteFile> deleteFiles, Collection<DataFile> replacedDataFiles, Collection<CharSequence> referencedDataFiles, Collection<Path> mergedAndDeletedFiles) {
        this.dataFiles = dataFiles;
        this.deleteFiles = deleteFiles;
        this.replacedDataFiles = replacedDataFiles;
        this.referencedDataFiles = referencedDataFiles;
        this.mergedAndDeletedFiles = mergedAndDeletedFiles;
    }

    public FilesForCommit(Collection<DataFile> dataFiles, Collection<DeleteFile> deleteFiles, Collection<DataFile> replacedDataFiles) {
        this(dataFiles, deleteFiles, replacedDataFiles, Collections.emptySet(), Collections.emptySet());
    }

    public static FilesForCommit onlyDelete(Collection<DeleteFile> deleteFiles, Collection<CharSequence> referencedDataFiles) {
        return new FilesForCommit(Collections.emptyList(), deleteFiles, Collections.emptyList(), referencedDataFiles, Collections.emptySet());
    }

    public static FilesForCommit onlyData(Collection<DataFile> dataFiles) {
        return new FilesForCommit(dataFiles, Collections.emptyList());
    }

    public static FilesForCommit onlyData(Collection<DataFile> dataFiles, Collection<DataFile> replacedDataFiles) {
        return new FilesForCommit(dataFiles, Collections.emptyList(), replacedDataFiles);
    }

    public static FilesForCommit empty() {
        return new FilesForCommit(Collections.emptyList(), Collections.emptyList());
    }

    public Collection<DataFile> dataFiles() {
        return this.dataFiles;
    }

    public Collection<DeleteFile> deleteFiles() {
        return this.deleteFiles;
    }

    public Collection<DataFile> replacedDataFiles() {
        return this.replacedDataFiles;
    }

    public Collection<CharSequence> referencedDataFiles() {
        return this.referencedDataFiles;
    }

    public Collection<Path> mergedAndDeletedFiles() {
        return this.mergedAndDeletedFiles;
    }

    public Collection<? extends ContentFile> allFiles() {
        return Stream.concat(this.dataFiles.stream(), this.deleteFiles.stream()).collect(Collectors.toList());
    }

    public boolean isEmpty() {
        return this.dataFiles.isEmpty() && this.deleteFiles.isEmpty() && this.replacedDataFiles.isEmpty();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("dataFiles", this.dataFiles.toString()).add("deleteFiles", this.deleteFiles.toString()).add("replacedDataFiles", this.replacedDataFiles.toString()).add("referencedDataFiles", this.referencedDataFiles.toString()).add("mergedAndDeletedFiles", this.mergedAndDeletedFiles.toString()).toString();
    }
}

