/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="array_union", value="_FUNC_(array1, array2) - Returns an array of the elements in the union of array1 and array2 without duplicates.", extended="Example:\n  > SELECT _FUNC_(array(1, 2, 2,4), array(2,3)) FROM src LIMIT 1;\n  [1,2,3,4]")
public class GenericUDFArrayUnion
extends AbstractGenericUDFArrayBase {
    static final int ARRAY2_IDX = 1;
    static final String ERROR_NOT_COMPARABLE = "Input arrays are not comparable to use ARRAY_UNION udf";
    private static final String FUNC_NAME = "ARRAY_UNION";

    public GenericUDFArrayUnion() {
        super(FUNC_NAME, 2, 2, ObjectInspector.Category.LIST);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector defaultOI = super.initialize(arguments);
        this.checkArgCategory(arguments, 1, ObjectInspector.Category.LIST, FUNC_NAME, "array");
        if (!ObjectInspectorUtils.compareTypes((ObjectInspector)this.arrayOI.getListElementObjectInspector(), (ObjectInspector)((ListObjectInspector)arguments[1]).getListElementObjectInspector())) {
            throw new UDFArgumentTypeException(1, ERROR_NOT_COMPARABLE);
        }
        return defaultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        Object array2 = arguments[1].get();
        if (array == null || array2 == null) {
            return null;
        }
        return Stream.concat(((ListObjectInspector)this.argumentOIs[0]).getList(array).stream(), ((ListObjectInspector)this.argumentOIs[1]).getList(array2).stream()).distinct().map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

