/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;

@Description(name="array_slice", value="_FUNC_(array, start, length) - Returns the subset or range of elements from an array (subarray).", extended="Example:\n  > SELECT _FUNC_(array(1, 2, 3,4), 2,2) FROM src LIMIT 1;\n  3,4")
public class GenericUDFArraySlice
extends AbstractGenericUDFArrayBase {
    private static final String FUNC_NAME = "ARRAY_SLICE";
    private static final int START_IDX = 1;
    private static final int LENGTH_IDX = 2;

    public GenericUDFArraySlice() {
        super(FUNC_NAME, 3, 3, ObjectInspector.Category.LIST);
    }

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        ObjectInspector defaultOI = super.initialize(arguments);
        this.checkArgIntPrimitiveCategory((PrimitiveObjectInspector)arguments[1], FUNC_NAME, 1);
        this.checkArgIntPrimitiveCategory((PrimitiveObjectInspector)arguments[2], FUNC_NAME, 2);
        return defaultOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int length;
        Object array = arguments[0].get();
        if (this.arrayOI.getListLength(array) == 0) {
            return Collections.emptyList();
        }
        if (this.arrayOI.getListLength(array) < 0) {
            return null;
        }
        List retArray = ((ListObjectInspector)this.argumentOIs[0]).getList(array);
        int start = ((IntObjectInspector)this.argumentOIs[1]).get(arguments[1].get());
        if (start + (length = ((IntObjectInspector)this.argumentOIs[2]).get(arguments[2].get())) > retArray.size()) {
            return Collections.emptyList();
        }
        return retArray.subList(start, start + length).stream().map(o -> this.converter.convert(o)).collect(Collectors.toList());
    }
}

