/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.ByteTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.DateTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.HiveCharTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.HiveVarcharTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.IntegerTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.LongTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.ShortTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.StringTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.UnsupportedDatatypeTransformAdapter;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;

abstract class AbstractTransformerAdapter {
    final AbstractTransformer transformer;

    AbstractTransformerAdapter(AbstractTransformer transformer) {
        this.transformer = transformer;
    }

    abstract Object getTransformedWritable(GenericUDF.DeferredObject var1) throws HiveException;

    static AbstractTransformerAdapter getTransformerAdapter(PrimitiveObjectInspector columnType, AbstractTransformer transformer) {
        return switch (columnType.getPrimitiveCategory()) {
            case PrimitiveObjectInspector.PrimitiveCategory.STRING -> new StringTransformerAdapter((StringObjectInspector)columnType, transformer);
            case PrimitiveObjectInspector.PrimitiveCategory.CHAR -> new HiveCharTransformerAdapter((HiveCharObjectInspector)columnType, transformer);
            case PrimitiveObjectInspector.PrimitiveCategory.VARCHAR -> new HiveVarcharTransformerAdapter((HiveVarcharObjectInspector)columnType, transformer);
            case PrimitiveObjectInspector.PrimitiveCategory.BYTE -> new ByteTransformerAdapter((ByteObjectInspector)columnType, transformer);
            case PrimitiveObjectInspector.PrimitiveCategory.SHORT -> new ShortTransformerAdapter((ShortObjectInspector)columnType, transformer);
            case PrimitiveObjectInspector.PrimitiveCategory.INT -> new IntegerTransformerAdapter((IntObjectInspector)columnType, transformer);
            case PrimitiveObjectInspector.PrimitiveCategory.LONG -> new LongTransformerAdapter((LongObjectInspector)columnType, transformer);
            case PrimitiveObjectInspector.PrimitiveCategory.DATE -> new DateTransformerAdapter((DateObjectInspector)columnType, transformer);
            default -> new UnsupportedDatatypeTransformAdapter(columnType, transformer);
        };
    }
}

