/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public enum HiveOperation {
    EXPLAIN("EXPLAIN", 1021, null, null),
    LOAD("LOAD", 1086, null, new Privilege[]{Privilege.ALTER_DATA}),
    EXPORT("EXPORT", 1024, new Privilege[]{Privilege.SELECT}, null),
    IMPORT("IMPORT", 1053, null, new Privilege[]{Privilege.ALTER_METADATA, Privilege.ALTER_DATA}),
    REPLDUMP("REPLDUMP", 1168, new Privilege[]{Privilege.ALL}, null),
    REPLLOAD("REPLLOAD", 1169, null, new Privilege[]{Privilege.ALL}),
    REPLSTATUS("REPLSTATUS", 1170, new Privilege[]{Privilege.SELECT}, null),
    CREATECATALOG("CREATECATALOG", 948, null, new Privilege[]{Privilege.CREATE}),
    DROPCATALOG("DROPCATALOG", 1000, null, new Privilege[]{Privilege.DROP}),
    CREATEDATABASE("CREATEDATABASE", 949, null, new Privilege[]{Privilege.CREATE}),
    CREATEDATACONNECTOR("CREATEDATACONNECTOR", 950, null, new Privilege[]{Privilege.CREATE}),
    DROPDATABASE("DROPDATABASE", 1001, null, new Privilege[]{Privilege.DROP}),
    DROPDATACONNECTOR("DROPDATACONNECTOR", 1002, null, new Privilege[]{Privilege.DROP}),
    SWITCHDATABASE("SWITCHDATABASE", 1242, null, null, true, false),
    LOCKDB("LOCKDATABASE", 1087, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKDB("UNLOCKDATABASE", 1301, new Privilege[]{Privilege.LOCK}, null),
    DROPTABLE("DROPTABLE", 1006, null, new Privilege[]{Privilege.DROP}),
    DESCTABLE("DESCTABLE", 993, null, null),
    DESCFUNCTION("DESCFUNCTION", 992, null, null),
    MSCK("MSCK", 1094, null, null),
    ALTERTABLE_ADDCOLS("ALTERTABLE_ADDCOLS", 857, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPCOL("ALTERTABLE_DROPCOL", 868, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_REPLACECOLS("ALTERTABLE_REPLACECOLS", 886, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMECOL("ALTERTABLE_RENAMECOL", 883, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAMEPART("ALTERTABLE_RENAMEPART", 884, new Privilege[]{Privilege.DROP}, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_UPDATEPARTSTATS("ALTERTABLE_UPDATEPARTSTATS", new int[]{855, 854}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATETABLESTATS("ALTERTABLE_UPDATETABLESTATS", new int[]{898, 896}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_RENAME("ALTERTABLE_RENAME", 882, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_DROPPARTS("ALTERTABLE_DROPPARTS", new int[]{870, 902}, new Privilege[]{Privilege.DROP}, null),
    ALTERTABLE_ADDPARTS("ALTERTABLE_ADDPARTS", new int[]{859, 900}, null, new Privilege[]{Privilege.CREATE}),
    ALTERTABLE_TOUCH("ALTERTABLE_TOUCH", 893, null, null),
    ALTERTABLE_ARCHIVE("ALTERTABLE_ARCHIVE", 860, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_UNARCHIVE("ALTERTABLE_UNARCHIVE", 894, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PROPERTIES("ALTERTABLE_PROPERTIES", new int[]{881, 871}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_OWNER("ALTERTABLE_OWNER", 879, null, null),
    ALTERTABLE_SETPARTSPEC("ALTERTABLE_SETPARTSPEC", 889, null, null),
    ALTERTABLE_EXECUTE("ALTERTABLE_EXECUTE", 875, null, null),
    ALTERTABLE_CREATEBRANCH("ALTERTABLE_CREATEBRANCH", 866, null, null),
    ALTERTABLE_CREATETAG("ALTERTABLE_CREATETAG", 867, null, null),
    ALTERTABLE_DROPBRANCH("ALTERTABLE_DROPBRANCH", 872, null, null),
    ALTERTABLE_RENAMEBRANCH("ALTERTABLE_RENAMEBRANCH", 885, null, null),
    ALTERTABLE_REPLACESNAPSHOTREF("ALTERTABLE_REPLACESNAPSHOTREF", 887, null, null),
    ALTERTABLE_DROPTAG("ALTERTABLE_DROPTAG", 873, null, null),
    ALTERTABLE_CONVERT("ALTERTABLE_CONVERT", 865, null, null),
    ALTERTABLE_SERIALIZER("ALTERTABLE_SERIALIZER", 888, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERIALIZER("ALTERPARTITION_SERIALIZER", 851, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_SERDEPROPERTIES("ALTERTABLE_SERDEPROPERTIES", new int[]{890, 895}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_SERDEPROPERTIES("ALTERPARTITION_SERDEPROPERTIES", new int[]{852, 853}, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_CLUSTER_SORT("ALTERTABLE_CLUSTER_SORT", 863, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ANALYZE_TABLE("ANALYZE_TABLE", 922, null, null),
    CACHE_METADATA("CACHE_METADATA", 932, new Privilege[]{Privilege.SELECT}, null),
    ALTERTABLE_BUCKETNUM("ALTERTABLE_BUCKETNUM", 861, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_BUCKETNUM("ALTERPARTITION_BUCKETNUM", 847, new Privilege[]{Privilege.ALTER_METADATA}, null),
    SHOWCATALOGS("SHOWCATALOGS", 1201, new Privilege[]{Privilege.SHOW_CATALOG}, null, true, false),
    SHOWDATABASES("SHOWDATABASES", 1204, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWDATACONNECTORS("SHOWDATACONNECTORS", 1205, new Privilege[]{Privilege.SHOW_DATABASE}, null, true, false),
    SHOWTABLES("SHOWTABLES", 1211, null, null, true, false),
    SHOWCOLUMNS("SHOWCOLUMNS", 1202, null, null, true, false),
    SHOW_TABLESTATUS("SHOW_TABLESTATUS", 1222, null, null, true, false),
    SHOW_TBLPROPERTIES("SHOW_TBLPROPERTIES", 1223, null, null, true, false),
    SHOW_CREATEDATABASE("SHOW_CREATEDATABASE", 1214, new Privilege[]{Privilege.SELECT}, null),
    SHOW_CREATETABLE("SHOW_CREATETABLE", 1215, new Privilege[]{Privilege.SELECT}, null),
    SHOWFUNCTIONS("SHOWFUNCTIONS", 1207, null, null, true, false),
    SHOWPARTITIONS("SHOWPARTITIONS", 1210, null, null),
    SHOWLOCKS("SHOWLOCKS", new int[]{1208, 1206}, null, null, true, false),
    SHOWCONF("SHOWCONF", 1203, null, null),
    SHOWVIEWS("SHOWVIEWS", 1212, null, null, true, false),
    SHOWMATERIALIZEDVIEWS("SHOWMATERIALIZEDVIEWS", 1209, null, null, true, false),
    CREATEFUNCTION("CREATEFUNCTION", 951, null, null),
    DROPFUNCTION("DROPFUNCTION", 1003, null, null),
    RELOADFUNCTION("RELOADFUNCTION", 1160, null, null),
    CREATEMACRO("CREATEMACRO", 952, null, null),
    DROPMACRO("DROPMACRO", 1004, null, null),
    CREATEVIEW("CREATEVIEW", new int[]{955, 901}, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    CREATE_MATERIALIZED_VIEW("CREATE_MATERIALIZED_VIEW", 957, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    DROPVIEW("DROPVIEW", 1007, null, new Privilege[]{Privilege.DROP}),
    DROP_MATERIALIZED_VIEW("DROP_MATERIALIZED_VIEW", 1009, null, new Privilege[]{Privilege.DROP}),
    ALTER_MATERIALIZED_VIEW_REWRITE("ALTER_MATERIALIZED_VIEW_REWRITE", 909, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTER_MATERIALIZED_VIEW_REBUILD("ALTER_MATERIALIZED_VIEW_REBUILD", 908, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE, Privilege.DROP}),
    ALTERVIEW_PROPERTIES("ALTERVIEW_PROPERTIES", new int[]{904, 903}, null, null),
    LOCKTABLE("LOCKTABLE", 1088, new Privilege[]{Privilege.LOCK}, null),
    UNLOCKTABLE("UNLOCKTABLE", 1302, new Privilege[]{Privilege.LOCK}, null),
    CREATEROLE("CREATEROLE", 953, null, null),
    DROPROLE("DROPROLE", 1005, null, null),
    GRANT_PRIVILEGE("GRANT_PRIVILEGE", 1038, null, null),
    REVOKE_PRIVILEGE("REVOKE_PRIVILEGE", 1179, null, null),
    SHOW_GRANT("SHOW_GRANT", 1217, null, null, true, false),
    GRANT_ROLE("GRANT_ROLE", 1040, null, null),
    REVOKE_ROLE("REVOKE_ROLE", 1180, null, null),
    SHOW_ROLES("SHOW_ROLES", new int[]{1218, 1216, 1200}, null, null, true, false),
    SHOW_ROLE_PRINCIPALS("SHOW_ROLE_PRINCIPALS", 1220, null, null, true, false),
    SHOW_ROLE_GRANT("SHOW_ROLE_GRANT", 1219, null, null, true, false),
    ALTERTABLE_FILEFORMAT("ALTERTABLE_FILEFORMAT", 876, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERPARTITION_FILEFORMAT("ALTERPARTITION_FILEFORMAT", 848, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_LOCATION("ALTERTABLE_LOCATION", 877, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERPARTITION_LOCATION("ALTERPARTITION_LOCATION", 849, new Privilege[]{Privilege.ALTER_DATA}, null),
    CREATETABLE("CREATETABLE", 954, null, new Privilege[]{Privilege.CREATE}),
    TRUNCATETABLE("TRUNCATETABLE", 1291, null, new Privilege[]{Privilege.DROP}),
    CREATETABLE_AS_SELECT("CREATETABLE_AS_SELECT", null, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.CREATE}),
    QUERY("QUERY", 1155, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA, Privilege.CREATE}, true, false),
    ALTERCATALOG_LOCATION("ALTERCATALOG_LOCATION", 839, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERDATABASE("ALTERDATABASE", 843, null, null),
    ALTERDATABASE_OWNER("ALTERDATABASE_OWNER", 842, null, null),
    ALTERDATABASE_LOCATION("ALTERDATABASE_LOCATION", new int[]{840, 841}, new Privilege[]{Privilege.ALTER_DATA}, null),
    DESCCATALOG("DESCCATALOG", 989, null, null),
    DESCDATABASE("DESCDATABASE", 990, null, null),
    ALTERDATACONNECTOR("ALTERDATACONNECTOR", 845, null, null),
    ALTERDATACONNECTOR_OWNER("ALTERDATABASE_OWNER", 844, null, null),
    ALTERDATACONNECTOR_URL("ALTERDATACONNECTOR_", 846, null, null),
    DESCDATACONNECTOR("DESCDATACONNECTOR", 991, null, null),
    ALTERTABLE_MERGEFILES("ALTER_TABLE_MERGE", 878, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERPARTITION_MERGEFILES("ALTER_PARTITION_MERGE", 850, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_SKEWED("ALTERTABLE_SKEWED", 891, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTBLPART_SKEWED_LOCATION("ALTERTBLPART_SKEWED_LOCATION", 892, new Privilege[]{Privilege.ALTER_DATA}, null),
    ALTERTABLE_PARTCOLTYPE("ALTERTABLE_PARTCOLTYPE", 880, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    ALTERTABLE_EXCHANGEPARTITION("ALTERTABLE_EXCHANGEPARTITION", 874, new Privilege[]{Privilege.SELECT, Privilege.DELETE}, new Privilege[]{Privilege.INSERT}),
    ALTERTABLE_DROPCONSTRAINT("ALTERTABLE_DROPCONSTRAINT", 869, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_ADDCONSTRAINT("ALTERTABLE_ADDCONSTRAINT", 858, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_UPDATECOLUMNS("ALTERTABLE_UPDATECOLUMNS", 897, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_RENAME("ALTERVIEW_RENAME", 905, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERVIEW_AS("ALTERVIEW_AS", 899, new Privilege[]{Privilege.ALTER_METADATA}, null),
    ALTERTABLE_COMPACT("ALTERTABLE_COMPACT", 864, new Privilege[]{Privilege.SELECT}, new Privilege[]{Privilege.ALTER_DATA}),
    SHOW_COMPACTIONS("SHOW COMPACTIONS", 1213, null, null, true, false),
    SHOW_TRANSACTIONS("SHOW TRANSACTIONS", 1224, null, null, true, false),
    START_TRANSACTION("START TRANSACTION", 1230, null, null, false, false),
    COMMIT("COMMIT", 942, null, null, true, true),
    ROLLBACK("ROLLBACK", 1185, null, null, true, true),
    SET_AUTOCOMMIT("SET AUTOCOMMIT", 1198, null, null, true, false),
    ABORT_TRANSACTIONS("ABORT TRANSACTIONS", 831, null, null, false, false),
    ABORT_COMPACTION("ABORT COMPACTIONS", 830, null, null, false, false),
    KILL_QUERY("KILL QUERY", 1074, null, null),
    CREATE_RESOURCEPLAN("CREATE RESOURCEPLAN", 959, null, null, false, false),
    SHOW_RESOURCEPLAN("SHOW RESOURCEPLAN", 1221, null, null, false, false),
    ALTER_RESOURCEPLAN("ALTER RESOURCEPLAN", new int[]{919, 915, 917, 918, 914, 913, 916}, null, null, false, false),
    DROP_RESOURCEPLAN("DROP RESOURCEPLAN", 1011, null, null, false, false),
    CREATE_TRIGGER("CREATE TRIGGER", 961, null, null, false, false),
    ALTER_TRIGGER("ALTER TRIGGER", 921, null, null, false, false),
    DROP_TRIGGER("DROP TRIGGER", 1013, null, null, false, false),
    CREATE_POOL("CREATE POOL", 958, null, null, false, false),
    ALTER_POOL("ALTER POOL", new int[]{910, 911, 912}, null, null, false, false),
    DROP_POOL("DROP POOL", 1010, null, null, false, false),
    CREATE_MAPPING("CREATE MAPPING", 956, null, null, false, false),
    ALTER_MAPPING("ALTER MAPPING", 906, null, null, false, false),
    DROP_MAPPING("DROP MAPPING", 1008, null, null, false, false),
    CREATE_SCHEDULED_QUERY("CREATE SCHEDULED QUERY", 960, null, null),
    ALTER_SCHEDULED_QUERY("ALTER SCHEDULED QUERY", 920, null, null),
    DROP_SCHEDULED_QUERY("DROP SCHEDULED QUERY", 1012, null, null),
    PREPARE("PREPARE QUERY", 1136, null, null),
    EXECUTE("EXECUTE QUERY", 1018, null, null);

    private final String operationName;
    private final int[] tokens;
    private final Privilege[] inputRequiredPrivileges;
    private final Privilege[] outputRequiredPrivileges;
    private final boolean allowedInTransaction;
    private final boolean requiresOpenTransaction;
    private static final Map<Integer, HiveOperation> TOKEN_TO_OPERATION;

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges) {
        this(operationName, tokens, inputRequiredPrivileges, outputRequiredPrivileges, false, false);
    }

    private HiveOperation(String operationName, int token, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this(operationName, new int[]{token}, inputRequiredPrivileges, outputRequiredPrivileges, allowedInTransaction, requiresOpenTransaction);
    }

    private HiveOperation(String operationName, int[] tokens, Privilege[] inputRequiredPrivileges, Privilege[] outputRequiredPrivileges, boolean allowedInTransaction, boolean requiresOpenTransaction) {
        this.operationName = operationName;
        this.tokens = tokens;
        this.inputRequiredPrivileges = inputRequiredPrivileges;
        this.outputRequiredPrivileges = outputRequiredPrivileges;
        this.requiresOpenTransaction = requiresOpenTransaction;
        this.allowedInTransaction = allowedInTransaction || requiresOpenTransaction;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Privilege[] getInputRequiredPrivileges() {
        return this.inputRequiredPrivileges;
    }

    public Privilege[] getOutputRequiredPrivileges() {
        return this.outputRequiredPrivileges;
    }

    public boolean isAllowedInTransaction() {
        return this.allowedInTransaction;
    }

    public boolean isRequiresOpenTransaction() {
        return this.requiresOpenTransaction;
    }

    public static HiveOperation operationForToken(int token) {
        return TOKEN_TO_OPERATION.get(token);
    }

    static {
        TOKEN_TO_OPERATION = new HashMap<Integer, HiveOperation>();
        for (HiveOperation hiveOperation : HiveOperation.values()) {
            if (hiveOperation.tokens == null) continue;
            for (int token : hiveOperation.tokens) {
                TOKEN_TO_OPERATION.put(token, hiveOperation);
            }
        }
    }
}

