/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Stage;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;

public class Progress {
    @JsonProperty
    private Status status;
    @JsonProperty(value="stages")
    private Map<String, Stage> stages = new ConcurrentHashMap<String, Stage>();

    public Progress() {
    }

    public Progress(Progress progress) {
        this.status = progress.status;
        for (Stage value : progress.stages.values()) {
            Stage stage = new Stage(value);
            this.stages.put(stage.getName(), stage);
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void addStage(Stage stage) {
        this.stages.putIfAbsent(stage.getName(), stage);
    }

    public Stage getStageByName(String stageName) {
        return this.stages.get(stageName);
    }

    public List<Stage> getStages() {
        return new ArrayList<Stage>(this.stages.values());
    }
}

