/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlKind;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.RewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.rewrite.RewriterFactory;
import org.apache.hadoop.hive.ql.parse.rewrite.UpdateStatement;

public class UpdateSemanticAnalyzer
extends RewriteSemanticAnalyzer<UpdateStatement> {
    public UpdateSemanticAnalyzer(QueryState queryState, RewriterFactory<UpdateStatement> rewriterFactory) throws SemanticException {
        super(queryState, rewriterFactory);
        queryState.setSqlKind(SqlKind.UPDATE);
    }

    @Override
    protected ASTNode getTargetTableNode(ASTNode tree) {
        ASTNode tabName = (ASTNode)tree.getChild(0);
        assert (tabName.getToken().getType() == 1273) : "Expected tablename as first child of " + Context.Operation.UPDATE + " but found " + tabName.getName();
        return tabName;
    }

    @Override
    protected void analyze(ASTNode tree, Table table, ASTNode tableName) throws SemanticException {
        List children = tree.getChildren();
        ASTNode where = null;
        int whereIndex = 2;
        if (children.size() > whereIndex) {
            where = (ASTNode)children.get(whereIndex);
            assert (where.getToken().getType() == 1316) : "Expected where clause, but found " + where.getName();
        }
        assert (children.size() >= 2) : "Expected update token to have at least two children";
        ASTNode setClause = (ASTNode)children.get(1);
        LinkedHashSet<String> setRCols = new LinkedHashSet<String>();
        Map<String, ASTNode> setCols = this.collectSetColumnsAndExpressions(setClause, setRCols, table);
        Map<String, String> colNameToDefaultConstraint = this.getColNameToDefaultValueMap(table);
        this.rewriteAndAnalyze(new UpdateStatement(table, where, setClause, setCols, colNameToDefaultConstraint), null);
        this.updateOutputs(table);
        this.setUpAccessControlInfoForUpdate(table, setCols);
        if (this.columnAccessInfo == null) {
            return;
        }
        for (String colName : setRCols) {
            this.columnAccessInfo.add(Table.getCompleteName(table.getDbName(), table.getTableName()), colName);
        }
    }

    @Override
    protected boolean enableColumnStatsCollecting() {
        return false;
    }
}

