/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;

public class TransformSpec {
    private static final Pattern HAS_WIDTH = Pattern.compile("(\\w+)\\[(\\d+)]");
    private String columnName;
    private TransformType transformType;
    private Optional<Integer> transformParam;
    private String fieldName;

    public TransformSpec() {
    }

    public TransformSpec(String columnName, TransformType transformType, Optional<Integer> transformParam) {
        this.columnName = columnName;
        this.transformType = transformType;
        this.transformParam = transformParam;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public TransformType getTransformType() {
        return this.transformType;
    }

    public void setTransformType(TransformType transformType) {
        this.transformType = transformType;
    }

    public Optional<Integer> getTransformParam() {
        return this.transformParam;
    }

    public void setTransformParam(Optional<Integer> transformParam) {
        this.transformParam = transformParam;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String transformTypeString() {
        if (this.transformType == null) {
            return null;
        }
        return this.transformType.name() + this.transformParam.map(width -> "[" + width + "]").orElse("");
    }

    public static String toNamedStruct(List<TransformSpec> partTransformSpec, Configuration conf) {
        return "named_struct(" + partTransformSpec.stream().map(spec -> "'" + spec.getFieldName() + "', " + spec.toHiveExpr(conf)).collect(Collectors.joining(", ")) + ")";
    }

    public String toHiveExpr(Configuration conf) {
        String identifier = HiveUtils.unparseIdentifier(this.columnName, conf);
        if (this.transformType == TransformType.IDENTITY) {
            return identifier;
        }
        String fn = "iceberg_" + this.transformType.name().toLowerCase() + "(" + identifier;
        switch (this.transformType) {
            case BUCKET: 
            case TRUNCATE: {
                fn = fn + ", " + this.transformParam.get();
            }
        }
        return fn + ")";
    }

    public static TransformType fromString(String transformString) {
        Matcher widthMatcher = HAS_WIDTH.matcher(transformString);
        if (widthMatcher.matches()) {
            transformString = widthMatcher.group(1);
        }
        return TransformType.valueOf(transformString.toUpperCase(Locale.ROOT));
    }

    public static TransformSpec fromString(String transfromString, String columnName) {
        Matcher widthMatcher = HAS_WIDTH.matcher(transfromString);
        Optional<Integer> width = Optional.empty();
        if (widthMatcher.matches()) {
            transfromString = widthMatcher.group(1);
            width = Optional.of(Integer.parseInt(widthMatcher.group(2)));
            return new TransformSpec(columnName, TransformType.valueOf(transfromString.toUpperCase(Locale.ROOT)), width);
        }
        return new TransformSpec(columnName, TransformType.valueOf(transfromString.toUpperCase(Locale.ROOT)), width);
    }

    public static TransformSpec fromStringWithColumnName(String transformString) {
        if (transformString == null || !transformString.contains("(")) {
            return new TransformSpec(transformString, TransformType.IDENTITY, Optional.empty());
        }
        transformString = transformString.trim();
        String transformName = transformString.split("\\(")[0].toLowerCase(Locale.ROOT);
        String innerContent = transformString.split("\\(")[1].split("\\)")[0].trim();
        String string = transformName = transformName.endsWith("s") ? transformName.substring(0, transformName.length() - 1) : transformName;
        if (transformName.equals("truncate") || transformName.equals("bucket")) {
            String[] parts = innerContent.split(",");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid format for " + transformName + ": " + transformString);
            }
            int width = Integer.parseInt(parts[0].trim());
            String columnName = parts[1].trim();
            return new TransformSpec(columnName, TransformType.valueOf(transformName.toUpperCase(Locale.ROOT)), Optional.of(width));
        }
        return new TransformSpec(innerContent, TransformType.valueOf(transformName.toUpperCase(Locale.ROOT)), Optional.empty());
    }

    public static enum TransformType {
        IDENTITY,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        TRUNCATE,
        BUCKET,
        VOID;

    }
}

