/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.google.common.base.Objects;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelWriterImplCopy;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@id")
public final class RelTreeSignature {
    @JsonProperty
    private int hashCode;
    @JsonProperty
    private String sig;
    @JsonProperty
    private ArrayList<RelTreeSignature> childSig;

    private RelTreeSignature() {
    }

    public RelTreeSignature(RelNode node) {
        this.sig = this.relSignature(node);
        this.childSig = new ArrayList();
        for (RelNode relNode : node.getInputs()) {
            this.childSig.add(RelTreeSignature.of(relNode));
        }
        this.hashCode = Objects.hashCode((Object[])new Object[]{this.sig, this.childSig});
    }

    public static RelTreeSignature of(RelNode node) {
        return new RelTreeSignature(node);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelTreeSignature)) {
            return false;
        }
        RelTreeSignature other = (RelTreeSignature)obj;
        return this.sig.equals(other.sig) && this.childSig.equals(other.childSig);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private String relSignature(RelNode rel) {
        if (rel == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        NonRecursiveRelWriterImpl planWriter = new NonRecursiveRelWriterImpl(new PrintWriter(sw), SqlExplainLevel.EXPPLAN_ATTRIBUTES, false);
        rel.explain((RelWriter)planWriter);
        return sw.toString();
    }

    static class NonRecursiveRelWriterImpl
    extends RelWriterImplCopy {
        public NonRecursiveRelWriterImpl(PrintWriter pw, SqlExplainLevel detailLevel, boolean withIdPrefix) {
            super(pw, detailLevel, withIdPrefix);
        }

        @Override
        protected void explainInputs(List<RelNode> inputs) {
        }
    }
}

