/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.SearchTransformer;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.RexNodeConverter;

public class HiveInBetweenExpandRule {
    public static final FilterRule FILTER_INSTANCE = new FilterRule();
    public static final JoinRule JOIN_INSTANCE = new JoinRule();
    public static final ProjectRule PROJECT_INSTANCE = new ProjectRule();

    private HiveInBetweenExpandRule() {
    }

    private static class FilterRule
    extends RelOptRule {
        FilterRule() {
            super(FilterRule.operand(Filter.class, (RelOptRuleOperandChildren)FilterRule.any()), HiveRelFactories.HIVE_BUILDER, "HiveInBetweenExpandRule(FilterRule)");
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            RexInBetweenExpander expander = new RexInBetweenExpander(filter.getCluster().getRexBuilder());
            RexNode condition = expander.apply(filter.getCondition());
            if (!expander.modified) {
                return;
            }
            Filter newFilter = filter.copy(filter.getTraitSet(), filter.getInput(), condition);
            call.transformTo((RelNode)newFilter);
        }
    }

    private static class JoinRule
    extends RelOptRule {
        JoinRule() {
            super(JoinRule.operand(Join.class, (RelOptRuleOperandChildren)JoinRule.any()), HiveRelFactories.HIVE_BUILDER, "HiveInBetweenExpandRule(JoinRule)");
        }

        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            RexInBetweenExpander expander = new RexInBetweenExpander(join.getCluster().getRexBuilder());
            RexNode condition = expander.apply(join.getCondition());
            if (!expander.modified) {
                return;
            }
            Join newJoin = join.copy(join.getTraitSet(), condition, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone());
            call.transformTo((RelNode)newJoin);
        }
    }

    private static class ProjectRule
    extends RelOptRule {
        ProjectRule() {
            super(ProjectRule.operand(Project.class, (RelOptRuleOperandChildren)ProjectRule.any()), HiveRelFactories.HIVE_BUILDER, "HiveInBetweenExpandRule(ProjectRule)");
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            RexInBetweenExpander expander = new RexInBetweenExpander(project.getCluster().getRexBuilder());
            ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
            for (RexNode expr : project.getProjects()) {
                newProjects.add(expander.apply(expr));
            }
            if (!expander.modified) {
                return;
            }
            Project newProject = project.copy(project.getTraitSet(), project.getInput(), newProjects, project.getRowType());
            call.transformTo((RelNode)newProject);
        }
    }

    private static final class RexInBetweenExpander
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private boolean modified;

        private RexInBetweenExpander(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
            this.modified = false;
        }

        public RexNode visitCall(RexCall call) {
            switch (call.getKind()) {
                case SEARCH: {
                    return (RexNode)new SearchTransformer(this.rexBuilder, call).transform().accept((RexVisitor)this);
                }
                case AND: {
                    boolean[] update = new boolean[]{false};
                    List newOperands = this.visitList((List)call.operands, update);
                    if (update[0]) {
                        return RexUtil.composeConjunction((RexBuilder)this.rexBuilder, (Iterable)newOperands);
                    }
                    return call;
                }
                case OR: {
                    boolean[] update = new boolean[]{false};
                    List newOperands = this.visitList((List)call.operands, update);
                    if (update[0]) {
                        return RexUtil.composeDisjunction((RexBuilder)this.rexBuilder, (Iterable)newOperands);
                    }
                    return call;
                }
                case BETWEEN: {
                    List<RexNode> newOperands = RexNodeConverter.rewriteBetweenChildren(call.getOperands(), this.rexBuilder);
                    this.modified = true;
                    if (((RexNode)call.getOperands().get(0)).isAlwaysTrue()) {
                        return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, newOperands);
                    }
                    return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, newOperands);
                }
            }
            if (HiveIn.INSTANCE.equals((Object)call.op)) {
                List<RexNode> newOperands = RexNodeConverter.transformInToOrOperands(call.getOperands(), this.rexBuilder);
                if (newOperands == null) {
                    return call;
                }
                this.modified = true;
                if (newOperands.size() > 1) {
                    return this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.OR, newOperands);
                }
                return newOperands.get(0);
            }
            return super.visitCall(call);
        }
    }
}

