/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.correlation;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttleImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.correlation.HiveCorrelationInfo;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public class CorrelationInfoVisitor
extends RexShuttle {
    private List<HiveCorrelationInfo> correlationInfos = new ArrayList<HiveCorrelationInfo>();
    private boolean notFlag;

    private CorrelationInfoVisitor() {
    }

    private List<HiveCorrelationInfo> getCorrelationInfos() {
        return this.correlationInfos;
    }

    public RexNode visitCall(RexCall call) {
        if (call.getOperator().getKind() == SqlKind.NOT) {
            this.notFlag = !this.notFlag;
        }
        RexNode returnNode = super.visitCall(call);
        if (call.getOperator().getKind() == SqlKind.NOT) {
            this.notFlag = !this.notFlag;
        }
        return returnNode;
    }

    public RexNode visitSubQuery(RexSubQuery subQuery) {
        SubQueryRelNodeShuttle relShuttle = new SubQueryRelNodeShuttle(subQuery, this.notFlag);
        subQuery.rel.accept((RelShuttle)relShuttle);
        this.correlationInfos.add(relShuttle.getCorrelationInfo());
        return subQuery;
    }

    public static List<HiveCorrelationInfo> getCorrelationInfos(RexNode rexNode) {
        CorrelationInfoVisitor visitor = new CorrelationInfoVisitor();
        rexNode.accept((RexVisitor)visitor);
        return ImmutableList.copyOf(visitor.getCorrelationInfos());
    }

    private static class SubQueryRelNodeShuttle
    extends HiveRelShuttleImpl {
        public final RexSubQuery rexSubQuery;
        public final boolean notFlag;
        private HiveAggregate aggregateRel;
        private InsideRexSubQueryVisitor visitor = new InsideRexSubQueryVisitor();

        public SubQueryRelNodeShuttle(RexSubQuery rexSubQuery, boolean notFlag) {
            this.rexSubQuery = rexSubQuery;
            this.notFlag = notFlag;
        }

        @Override
        public RelNode visit(HiveFilter filter) {
            filter.getCondition().accept((RexVisitor)this.visitor);
            return super.visit(filter);
        }

        @Override
        public RelNode visit(HiveProject project) {
            for (RexNode r : project.getProjects()) {
                r.accept((RexVisitor)this.visitor);
            }
            return super.visit(project);
        }

        @Override
        public RelNode visit(HiveJoin join) {
            join.getCondition().accept((RexVisitor)this.visitor);
            return super.visit(join);
        }

        @Override
        public RelNode visit(HiveAggregate aggregate) {
            if (this.aggregateRel == null) {
                this.aggregateRel = aggregate;
            }
            return super.visit(aggregate);
        }

        public HiveCorrelationInfo getCorrelationInfo() {
            return new HiveCorrelationInfo(this.visitor.getCorrelationIds(), this.rexSubQuery, this.aggregateRel, this.notFlag);
        }
    }

    private static class InsideRexSubQueryVisitor
    extends RexShuttle {
        private Set<CorrelationId> correlationIds = new LinkedHashSet<CorrelationId>();

        private InsideRexSubQueryVisitor() {
        }

        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            this.correlationIds.add(variable.id);
            return super.visitCorrelVariable(variable);
        }

        public Set<CorrelationId> getCorrelationIds() {
            return this.correlationIds;
        }
    }
}

