/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.privilege;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="privilege subject", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class PrivilegeObjectDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final boolean table;
    private final String object;
    private final Map<String, String> partSpec;
    private final List<String> columns;

    public PrivilegeObjectDesc(boolean isTable, String object, Map<String, String> partSpec, List<String> columns) {
        this.table = isTable;
        this.object = object;
        this.partSpec = partSpec;
        this.columns = columns;
    }

    @Explain(displayName="is table")
    public boolean getTable() {
        return this.table;
    }

    @Explain(displayName="object", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getObject() {
        return this.object;
    }

    @Explain(displayName="partition spec", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, String> getPartSpec() {
        return this.partSpec;
    }

    public List<String> getColumns() {
        return this.columns;
    }
}

