/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.dataconnector.create;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.dataconnector.create.CreateDataConnectorDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class CreateDataConnectorOperation
extends DDLOperation<CreateDataConnectorDesc> {
    public CreateDataConnectorOperation(DDLOperationContext context, CreateDataConnectorDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        try {
            URI connectorUri = new URI(((CreateDataConnectorDesc)this.desc).getURL());
            if (!connectorUri.isAbsolute() || StringUtils.isBlank((CharSequence)connectorUri.getScheme())) {
                throw new HiveException(ErrorMsg.INVALID_PATH, new String[]{((CreateDataConnectorDesc)this.desc).getURL()});
            }
            DataConnector connector = new DataConnector(((CreateDataConnectorDesc)this.desc).getName(), ((CreateDataConnectorDesc)this.desc).getType(), ((CreateDataConnectorDesc)this.desc).getURL());
            if (((CreateDataConnectorDesc)this.desc).getComment() != null) {
                connector.setDescription(((CreateDataConnectorDesc)this.desc).getComment());
            }
            connector.setOwnerName(SessionState.getUserFromAuthenticator());
            connector.setOwnerType(PrincipalType.USER);
            if (((CreateDataConnectorDesc)this.desc).getConnectorProperties() != null) {
                connector.setParameters(((CreateDataConnectorDesc)this.desc).getConnectorProperties());
            }
            try {
                this.context.getDb().createDataConnector(connector, ((CreateDataConnectorDesc)this.desc).getIfNotExists());
            }
            catch (AlreadyExistsException ex) {
                throw new HiveException((Throwable)ex, ErrorMsg.DATACONNECTOR_ALREADY_EXISTS, new String[]{((CreateDataConnectorDesc)this.desc).getName()});
            }
            return 0;
        }
        catch (URISyntaxException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

