/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.database.alter.location;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.database.alter.AbstractAlterDatabaseOperation;
import org.apache.hadoop.hive.ql.ddl.database.alter.location.AlterDatabaseSetManagedLocationDesc;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class AlterDatabaseSetManagedLocationOperation
extends AbstractAlterDatabaseOperation<AlterDatabaseSetManagedLocationDesc> {
    public AlterDatabaseSetManagedLocationOperation(DDLOperationContext context, AlterDatabaseSetManagedLocationDesc desc) {
        super(context, desc);
    }

    @Override
    protected void doAlteration(Database database, Map<String, String> params) throws HiveException {
        try {
            String newManagedLocation = Utilities.getQualifiedPath(this.context.getConf(), new Path(((AlterDatabaseSetManagedLocationDesc)this.desc).getManagedLocation()));
            if (database.getLocationUri().equalsIgnoreCase(newManagedLocation)) {
                throw new HiveException("Managed and external locations for database cannot be the same");
            }
            URI locationURI = new URI(newManagedLocation);
            if (!locationURI.isAbsolute() || StringUtils.isBlank((CharSequence)locationURI.getScheme())) {
                throw new HiveException(ErrorMsg.BAD_LOCATION_VALUE, new String[]{newManagedLocation});
            }
            if (newManagedLocation.equals(database.getManagedLocationUri())) {
                LOG.info("AlterDatabase skipped. No change in location.");
            } else {
                database.setManagedLocationUri(newManagedLocation);
            }
        }
        catch (URISyntaxException e) {
            throw new HiveException((Throwable)e);
        }
    }
}

