/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.calcite.sql.SqlKind;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryState {
    private static final Logger LOG = LoggerFactory.getLogger(QueryState.class);
    private final HiveConf queryConf;
    private HiveOperation commandType;
    private SqlKind sqlKind;
    private LineageState lineageState = new LineageState();
    private HiveTxnManager txnManager;
    private Supplier<String> validTxnList;
    private long numModifiedRows = 0L;
    public static final String USERID_TAG = "userid";
    private final Map<String, Object> resourceMap = new HashMap<String, Object>();
    private Map<Object, Object> hmsCache;
    private boolean hmsCacheEnabled;
    private final ReentrantLock resolveConditionalTaskLock = new ReentrantLock(true);

    private QueryState(HiveConf conf) {
        this.queryConf = conf;
        this.validTxnList = () -> conf.get("hive.txn.valid.txns");
    }

    public String getQueryId() {
        return this.queryConf.getVar(HiveConf.ConfVars.HIVE_QUERY_ID);
    }

    public String getQueryString() {
        return this.queryConf.getQueryString();
    }

    public Map<Object, Object> getHMSCache() {
        return this.hmsCacheEnabled ? this.hmsCache : null;
    }

    public void disableHMSCache() {
        this.hmsCacheEnabled = false;
    }

    public void enableHMSCache() {
        this.hmsCacheEnabled = true;
    }

    public void createHMSCache() {
        LOG.info("Query-level HMS cache created for {}", (Object)this.getQueryId());
        this.hmsCache = new HashMap<Object, Object>();
        this.hmsCacheEnabled = true;
    }

    public String getCommandType() {
        if (this.commandType == null) {
            return null;
        }
        return this.commandType.getOperationName();
    }

    public HiveOperation getHiveOperation() {
        return this.commandType;
    }

    public void setCommandType(HiveOperation commandType) {
        this.commandType = commandType;
    }

    public SqlKind getSqlKind() {
        return this.sqlKind;
    }

    public void setSqlKind(SqlKind sqlKind) {
        this.sqlKind = sqlKind;
    }

    public HiveConf getConf() {
        return this.queryConf;
    }

    public LineageState getLineageState() {
        return this.lineageState;
    }

    public void setLineageState(LineageState lineageState) {
        this.lineageState = lineageState;
    }

    public HiveTxnManager getTxnManager() {
        return this.txnManager;
    }

    public void setTxnManager(HiveTxnManager txnManager) {
        this.txnManager = txnManager;
    }

    public String getValidTxnList() {
        return this.validTxnList.get();
    }

    public void setValidTxnList(Supplier<String> validTxnList) {
        this.validTxnList = validTxnList;
    }

    public long getNumModifiedRows() {
        return this.numModifiedRows;
    }

    public void setNumModifiedRows(long numModifiedRows) {
        this.numModifiedRows = numModifiedRows;
    }

    public String getQueryTag() {
        return HiveConf.getVar((Configuration)this.queryConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_TAG);
    }

    public void setQueryTag(String queryTag) {
        HiveConf.setVar((Configuration)this.queryConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_TAG, (String)queryTag);
    }

    public static void setApplicationTag(HiveConf queryConf, String queryTag) {
        String jobTag = HiveConf.getVar((Configuration)queryConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_TAG);
        jobTag = jobTag == null || jobTag.isEmpty() ? queryTag : jobTag.concat("," + queryTag);
        if (SessionState.get() != null) {
            jobTag = jobTag.concat(",userid=" + SessionState.get().getUserName());
        }
        queryConf.set("mapreduce.job.tags", jobTag);
        queryConf.set("tez.application.tags", jobTag);
    }

    public void addResource(String resourceIdentifier, Object resource) {
        this.resourceMap.put(resourceIdentifier, resource);
    }

    public Object getResource(String resourceIdentifier) {
        return this.resourceMap.get(resourceIdentifier);
    }

    public void clearResourceMap() {
        this.resourceMap.clear();
    }

    public ReentrantLock getResolveConditionalTaskLock() {
        return this.resolveConditionalTaskLock;
    }

    public static QueryState getNewQueryState(HiveConf conf, LineageState lineageState) {
        return new Builder().withGenerateNewQueryId(true).withHiveConf(conf).withLineageState(lineageState).build();
    }

    public static class Builder {
        private Map<String, String> confOverlay = null;
        private boolean isolated = true;
        private boolean generateNewQueryId = false;
        private HiveConf hiveConf = null;
        private Supplier<String> validTxnList;
        private LineageState lineageState = null;

        public Builder withConfOverlay(Map<String, String> confOverlay) {
            this.confOverlay = confOverlay;
            return this;
        }

        public Builder nonIsolated() {
            this.isolated = false;
            return this;
        }

        public Builder withGenerateNewQueryId(boolean generateNewQueryId) {
            this.generateNewQueryId = generateNewQueryId;
            return this;
        }

        public Builder withHiveConf(HiveConf hiveConf) {
            this.hiveConf = hiveConf;
            return this;
        }

        public Builder withValidTxnList(Supplier<String> validTxnList) {
            this.validTxnList = validTxnList;
            return this;
        }

        public Builder withLineageState(LineageState lineageState) {
            this.lineageState = lineageState;
            return this;
        }

        public QueryState build() {
            HiveConf queryConf = this.isolated ? (this.hiveConf == null ? new HiveConf() : new HiveConf(this.hiveConf)) : this.hiveConf;
            if (this.confOverlay != null && !this.confOverlay.isEmpty()) {
                for (Map.Entry<String, String> confEntry : this.confOverlay.entrySet()) {
                    try {
                        queryConf.verifyAndSet(confEntry.getKey(), confEntry.getValue());
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException("Error applying statement specific settings", e);
                    }
                }
            }
            if (this.generateNewQueryId) {
                String queryId = QueryPlan.makeQueryId();
                queryConf.setVar(HiveConf.ConfVars.HIVE_QUERY_ID, queryId);
                QueryState.setApplicationTag(queryConf, queryId);
                if (this.hiveConf != null) {
                    this.hiveConf.setVar(HiveConf.ConfVars.HIVE_QUERY_ID, queryId);
                }
            }
            QueryState queryState = new QueryState(queryConf);
            if (this.lineageState != null) {
                queryState.setLineageState(this.lineageState);
            }
            if (this.validTxnList != null) {
                queryState.setValidTxnList(this.validTxnList);
            }
            return queryState;
        }
    }
}

