/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.callback;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.helix.zookeeper.zkclient.callback.CancellableZkAsyncCallback;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallMonitorContext;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncRetryCallContext;
import org.apache.helix.zookeeper.zkclient.metric.ZkClientMonitor;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkAsyncCallbacks {
    private static Logger LOG = LoggerFactory.getLogger(ZkAsyncCallbacks.class);

    @Deprecated
    public static class ZkAsyncCallContext
    extends ZkAsyncCallMonitorContext {
        ZkAsyncCallContext(ZkClientMonitor monitor, long startTimeMilliSec, int bytes, boolean isRead) {
            super(monitor, startTimeMilliSec, bytes, isRead);
        }
    }

    public static abstract class DefaultCallback
    implements CancellableZkAsyncCallback {
        AtomicBoolean _isOperationDone = new AtomicBoolean(false);
        int _rc = KeeperException.Code.APIERROR.intValue();
        String _path;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(int rc, String path, Object ctx) {
            if (rc != 0) {
                LOG.debug(" {}, rc:{}, path {}", new Object[]{this, KeeperException.Code.get((int)rc), path});
            }
            if (ctx != null && ctx instanceof ZkAsyncCallMonitorContext) {
                ZkAsyncCallMonitorContext monitor = (ZkAsyncCallMonitorContext)ctx;
                if (rc == 0) {
                    monitor.recordAccess(path);
                } else {
                    this.recordFailure(rc, path, monitor);
                }
            }
            this._rc = rc;
            this._path = path;
            if (this.needRetry(rc)) {
                if (ctx != null && ctx instanceof ZkAsyncRetryCallContext) {
                    try {
                        if (((ZkAsyncRetryCallContext)ctx).requestRetry()) {
                            LOG.info("Received {} for async request on path {}, requested retry.", (Object)rc, (Object)path);
                            return;
                        }
                        LOG.warn("Cannot request to retry the operation. The retry request thread may have been stopped.");
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to request to retry the operation.", t);
                    }
                } else {
                    LOG.warn("The provided callback context {} is not ZkAsyncRetryCallContext. Skip retrying.", ctx == null ? null : ctx.getClass().getName());
                }
            }
            try {
                this.handle();
            }
            catch (Exception ex) {
                LOG.error("Exception while handling user callback for path {}.", (Object)this._path, (Object)ex);
            }
            finally {
                this.markOperationDone();
            }
        }

        protected void recordFailure(int rc, String path, ZkAsyncCallMonitorContext monitor) {
            monitor.recordFailure(path);
        }

        public boolean isOperationDone() {
            return this._isOperationDone.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForSuccess() {
            try {
                AtomicBoolean atomicBoolean = this._isOperationDone;
                synchronized (atomicBoolean) {
                    while (!this._isOperationDone.get()) {
                        this._isOperationDone.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.error("Interrupted waiting for success", (Throwable)e);
                return false;
            }
            return true;
        }

        public int getRc() {
            return this._rc;
        }

        public String getPath() {
            return this._path;
        }

        @Override
        public void notifyCallers() {
            LOG.warn("The callback {} has been cancelled.", (Object)this);
            this.handle();
            this.markOperationDone();
        }

        public abstract void handle();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markOperationDone() {
            AtomicBoolean atomicBoolean = this._isOperationDone;
            synchronized (atomicBoolean) {
                this._isOperationDone.set(true);
                this._isOperationDone.notifyAll();
            }
        }

        protected boolean needRetry(int rc) {
            try {
                switch (KeeperException.Code.get((int)rc)) {
                    case CONNECTIONLOSS: 
                    case SESSIONEXPIRED: 
                    case SESSIONMOVED: {
                        return true;
                    }
                }
                return false;
            }
            catch (ClassCastException | NullPointerException ex) {
                LOG.error("Failed to handle unknown return code {}. Skip retrying.", (Object)rc, (Object)ex);
                return false;
            }
        }
    }

    public static class SyncCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.VoidCallback {
        private String _sessionId;

        public SyncCallbackHandler(String sessionId) {
            this._sessionId = sessionId;
        }

        public void processResult(int rc, String path, Object ctx) {
            LOG.debug("sync() call with sessionID {} async return code: {}", (Object)this._sessionId, (Object)rc);
            this.callback(rc, path, ctx);
        }

        @Override
        public void handle() {
        }

        @Override
        protected boolean needRetry(int rc) {
            try {
                switch (KeeperException.Code.get((int)rc)) {
                    case CONNECTIONLOSS: {
                        return true;
                    }
                }
                return false;
            }
            catch (ClassCastException | NullPointerException ex) {
                LOG.error("Session {} failed to handle unknown return code {}. Skip retrying. ex {}", new Object[]{this._sessionId, rc, ex});
                return false;
            }
        }
    }

    public static class DeleteCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.VoidCallback {
        public void processResult(int rc, String path, Object ctx) {
            this.callback(rc, path, ctx);
        }

        @Override
        public void handle() {
        }
    }

    public static class CreateCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StringCallback,
    AsyncCallback.Create2Callback {
        public void processResult(int rc, String path, Object ctx, String name) {
            this.callback(rc, path, ctx);
        }

        public void processResult(int rc, String path, Object ctx, String name, Stat stat) {
            this.callback(rc, path, ctx);
        }

        @Override
        public void handle() {
        }
    }

    public static class ExistsCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StatCallback {
        public Stat _stat;

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc == 0) {
                this._stat = stat;
            }
            this.callback(rc, path, ctx);
        }

        public Stat getStat() {
            return this._stat;
        }

        @Override
        public void handle() {
        }

        @Override
        protected void recordFailure(int rc, String path, ZkAsyncCallMonitorContext monitor) {
            if (rc != KeeperException.Code.NONODE.intValue()) {
                monitor.recordFailure(path);
            }
        }
    }

    public static class SetDataCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StatCallback {
        Stat _stat;

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc == 0) {
                this._stat = stat;
            }
            this.callback(rc, path, ctx);
        }

        public Stat getStat() {
            return this._stat;
        }

        @Override
        public void handle() {
        }
    }

    public static class GetDataCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.DataCallback {
        public byte[] _data;
        public Stat _stat;

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            if (rc == 0) {
                this._data = data;
                this._stat = stat;
                if (this._data != null && ctx != null && ctx instanceof ZkAsyncCallMonitorContext) {
                    ((ZkAsyncCallMonitorContext)ctx).setBytes(this._data.length);
                }
            }
            this.callback(rc, path, ctx);
        }

        public Stat getStat() {
            return this._stat;
        }

        public byte[] getData() {
            return this._data;
        }

        @Override
        public void handle() {
        }

        @Override
        protected void recordFailure(int rc, String path, ZkAsyncCallMonitorContext monitor) {
            if (rc != KeeperException.Code.NONODE.intValue()) {
                monitor.recordFailure(path);
            }
        }
    }
}

