/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.impl.client;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.helix.msdcommon.datamodel.MetadataStoreRoutingData;
import org.apache.helix.msdcommon.exception.InvalidRoutingDataException;
import org.apache.helix.zookeeper.api.client.ChildrenSubscribeResult;
import org.apache.helix.zookeeper.api.client.HelixZkClient;
import org.apache.helix.zookeeper.api.client.RealmAwareZkClient;
import org.apache.helix.zookeeper.impl.factory.SharedZkClientFactory;
import org.apache.helix.zookeeper.zkclient.DataUpdater;
import org.apache.helix.zookeeper.zkclient.IZkChildListener;
import org.apache.helix.zookeeper.zkclient.IZkDataListener;
import org.apache.helix.zookeeper.zkclient.callback.ZkAsyncCallbacks;
import org.apache.helix.zookeeper.zkclient.deprecated.IZkStateListener;
import org.apache.helix.zookeeper.zkclient.serialize.PathBasedZkSerializer;
import org.apache.helix.zookeeper.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedZkClient
implements RealmAwareZkClient {
    private static Logger LOG = LoggerFactory.getLogger(SharedZkClient.class);
    private final HelixZkClient _innerSharedZkClient;
    private final MetadataStoreRoutingData _metadataStoreRoutingData;
    private final String _zkRealmShardingKey;
    private final String _zkRealmAddress;
    private final RealmAwareZkClient.RealmAwareZkConnectionConfig _connectionConfig;
    private final RealmAwareZkClient.RealmAwareZkClientConfig _clientConfig;

    public SharedZkClient(RealmAwareZkClient.RealmAwareZkConnectionConfig connectionConfig, RealmAwareZkClient.RealmAwareZkClientConfig clientConfig) throws InvalidRoutingDataException {
        if (connectionConfig == null) {
            throw new IllegalArgumentException("RealmAwareZkConnectionConfig cannot be null!");
        }
        if (clientConfig == null) {
            throw new IllegalArgumentException("RealmAwareZkClientConfig cannot be null!");
        }
        this._connectionConfig = connectionConfig;
        this._clientConfig = clientConfig;
        this._zkRealmShardingKey = connectionConfig.getZkRealmShardingKey();
        if (this._zkRealmShardingKey == null || this._zkRealmShardingKey.isEmpty()) {
            throw new IllegalArgumentException("RealmAwareZkConnectionConfig's ZK realm sharding key cannot be null or empty for SharedZkClient!");
        }
        this._metadataStoreRoutingData = RealmAwareZkClient.getMetadataStoreRoutingData(connectionConfig);
        String zkRealmAddress = this._metadataStoreRoutingData.getMetadataStoreRealm(this._zkRealmShardingKey);
        if (zkRealmAddress == null || zkRealmAddress.isEmpty()) {
            throw new IllegalArgumentException("ZK realm address for the given ZK realm sharding key is invalid! ZK realm address: " + zkRealmAddress + " ZK realm sharding key: " + this._zkRealmShardingKey);
        }
        this._zkRealmAddress = zkRealmAddress;
        HelixZkClient.ZkConnectionConfig zkConnectionConfig = new HelixZkClient.ZkConnectionConfig(zkRealmAddress).setSessionTimeout(connectionConfig.getSessionTimeout());
        HelixZkClient.ZkClientConfig zkClientConfig = new HelixZkClient.ZkClientConfig();
        zkClientConfig.setZkSerializer(clientConfig.getZkSerializer()).setConnectInitTimeout(clientConfig.getConnectInitTimeout()).setOperationRetryTimeout(clientConfig.getOperationRetryTimeout()).setMonitorInstanceName(clientConfig.getMonitorInstanceName()).setMonitorKey(clientConfig.getMonitorKey()).setMonitorType(clientConfig.getMonitorType()).setMonitorRootPathOnly(clientConfig.isMonitorRootPathOnly());
        this._innerSharedZkClient = SharedZkClientFactory.getInstance().buildZkClient(zkConnectionConfig, zkClientConfig);
    }

    @Override
    public List<String> subscribeChildChanges(String path, IZkChildListener listener) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.subscribeChildChanges(path, listener);
    }

    @Override
    public ChildrenSubscribeResult subscribeChildChanges(String path, IZkChildListener listener, boolean skipWatchingNodeNotExist) {
        return this._innerSharedZkClient.subscribeChildChanges(path, listener, skipWatchingNodeNotExist);
    }

    @Override
    public void unsubscribeChildChanges(String path, IZkChildListener listener) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.unsubscribeChildChanges(path, listener);
    }

    @Override
    public void subscribeDataChanges(String path, IZkDataListener listener) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.subscribeDataChanges(path, listener);
    }

    @Override
    public boolean subscribeDataChanges(String path, IZkDataListener listener, boolean skipWatchingNodeNotExist) {
        return this._innerSharedZkClient.subscribeDataChanges(path, listener, skipWatchingNodeNotExist);
    }

    @Override
    public void unsubscribeDataChanges(String path, IZkDataListener listener) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.unsubscribeDataChanges(path, listener);
    }

    @Override
    public void subscribeStateChanges(IZkStateListener listener) {
        this._innerSharedZkClient.subscribeStateChanges(listener);
    }

    @Override
    public void unsubscribeStateChanges(IZkStateListener listener) {
        this._innerSharedZkClient.unsubscribeStateChanges(listener);
    }

    @Override
    public void unsubscribeAll() {
        this._innerSharedZkClient.unsubscribeAll();
    }

    @Override
    public void createPersistent(String path) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createPersistent(path);
    }

    @Override
    public void createPersistent(String path, boolean createParents) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createPersistent(path, createParents);
    }

    @Override
    public void createPersistent(String path, boolean createParents, List<ACL> acl) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createPersistent(path, createParents, acl);
    }

    @Override
    public void createPersistent(String path, Object data) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createPersistent(path, data);
    }

    @Override
    public void createPersistent(String path, Object data, List<ACL> acl) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createPersistent(path, data, acl);
    }

    @Override
    public void createPersistentWithTTL(String path, long ttl) {
        this.createPersistentWithTTL(path, false, ttl);
    }

    @Override
    public void createPersistentWithTTL(String path, boolean createParents, long ttl) {
        this.createPersistentWithTTL(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE, ttl);
    }

    @Override
    public void createPersistentWithTTL(String path, boolean createParents, List<ACL> acl, long ttl) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createPersistentWithTTL(path, createParents, acl, ttl);
    }

    @Override
    public void createPersistentWithTTL(String path, Object data, long ttl) {
        this.createPersistentWithTTL(path, data, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE, ttl);
    }

    @Override
    public void createPersistentWithTTL(String path, Object data, List<ACL> acl, long ttl) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createPersistentWithTTL(path, data, acl, ttl);
    }

    @Override
    public String createPersistentSequential(String path, Object data) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.createPersistentSequential(path, data);
    }

    @Override
    public String createPersistentSequential(String path, Object data, List<ACL> acl) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.createPersistentSequential(path, data, acl);
    }

    @Override
    public String createPersistentSequentialWithTTL(String path, Object data, long ttl) {
        return this.createPersistentSequentialWithTTL(path, data, ZooDefs.Ids.OPEN_ACL_UNSAFE, ttl);
    }

    @Override
    public String createPersistentSequentialWithTTL(String path, Object data, List<ACL> acl, long ttl) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.createPersistentSequentialWithTTL(path, data, acl, ttl);
    }

    @Override
    public void createContainer(String path) {
        this.createContainer(path, false);
    }

    @Override
    public void createContainer(String path, boolean createParents) {
        this.createContainer(path, createParents, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    @Override
    public void createContainer(String path, boolean createParents, List<ACL> acl) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createContainer(path, createParents, acl);
    }

    @Override
    public void createContainer(String path, Object data) {
        this.createContainer(path, data, (List<ACL>)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    @Override
    public void createContainer(String path, Object data, List<ACL> acl) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.createContainer(path, data, acl);
    }

    @Override
    public void createEphemeral(String path) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public void createEphemeral(String path, String sessionId) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public void createEphemeral(String path, List<ACL> acl) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public void createEphemeral(String path, List<ACL> acl, String sessionId) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public String create(String path, Object data, CreateMode mode) {
        return this.create(path, data, mode, -1L);
    }

    @Override
    public String create(String path, Object data, CreateMode mode, long ttl) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.create(path, data, mode, ttl);
    }

    @Override
    public String create(String path, Object datat, List<ACL> acl, CreateMode mode) {
        return this.create(path, datat, acl, mode, -1L);
    }

    @Override
    public String create(String path, Object datat, List<ACL> acl, CreateMode mode, long ttl) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.create(path, datat, acl, mode, ttl);
    }

    @Override
    public void createEphemeral(String path, Object data) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public void createEphemeral(String path, Object data, String sessionId) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public void createEphemeral(String path, Object data, List<ACL> acl) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public void createEphemeral(String path, Object data, List<ACL> acl, String sessionId) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public String createEphemeralSequential(String path, Object data) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public String createEphemeralSequential(String path, Object data, List<ACL> acl) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public String createEphemeralSequential(String path, Object data, String sessionId) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public String createEphemeralSequential(String path, Object data, List<ACL> acl, String sessionId) {
        throw new UnsupportedOperationException("Creating ephemeral nodes using " + SharedZkClient.class.getSimpleName() + " is not supported.");
    }

    @Override
    public List<String> getChildren(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.getChildren(path);
    }

    @Override
    public int countChildren(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.countChildren(path);
    }

    @Override
    public boolean exists(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.exists(path);
    }

    @Override
    public Stat getStat(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.getStat(path);
    }

    @Override
    public boolean waitUntilExists(String path, TimeUnit timeUnit, long time) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.waitUntilExists(path, timeUnit, time);
    }

    @Override
    public void deleteRecursively(String path) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.deleteRecursively(path);
    }

    @Override
    public void deleteRecursivelyAtomic(String path) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.deleteRecursivelyAtomic(path);
    }

    @Override
    public void deleteRecursivelyAtomic(List<String> paths) {
        for (String path : paths) {
            this.checkIfPathContainsShardingKey(path);
        }
        this._innerSharedZkClient.deleteRecursivelyAtomic(paths);
    }

    @Override
    public boolean delete(String path) {
        return this.delete(path, -1);
    }

    @Override
    public boolean delete(String path, int expectedVersion) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.delete(path, expectedVersion);
    }

    @Override
    public <T> T readData(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.readData(path);
    }

    @Override
    public <T> T readData(String path, boolean returnNullIfPathNotExists) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.readData(path, returnNullIfPathNotExists);
    }

    @Override
    public <T> T readData(String path, Stat stat) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.readData(path, stat);
    }

    @Override
    public <T> T readData(String path, Stat stat, boolean watch) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.readData(path, stat, watch);
    }

    @Override
    public <T> T readDataAndStat(String path, Stat stat, boolean returnNullIfPathNotExists) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.readDataAndStat(path, stat, returnNullIfPathNotExists);
    }

    @Override
    public void writeData(String path, Object object) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.writeData(path, object);
    }

    @Override
    public <T> void updateDataSerialized(String path, DataUpdater<T> updater) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.updateDataSerialized(path, updater);
    }

    @Override
    public void writeData(String path, Object datat, int expectedVersion) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.writeDataReturnStat(path, datat, expectedVersion);
    }

    @Override
    public Stat writeDataReturnStat(String path, Object datat, int expectedVersion) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.writeDataReturnStat(path, datat, expectedVersion);
    }

    @Override
    public Stat writeDataGetStat(String path, Object datat, int expectedVersion) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.writeDataReturnStat(path, datat, expectedVersion);
    }

    @Override
    public void asyncCreate(String path, Object datat, CreateMode mode, long ttl, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.asyncCreate(path, datat, mode, ttl, cb);
    }

    @Override
    public void asyncCreate(String path, Object datat, CreateMode mode, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        this.asyncCreate(path, datat, mode, -1L, cb);
    }

    @Override
    public void asyncSetData(String path, Object datat, int version, ZkAsyncCallbacks.SetDataCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.asyncSetData(path, datat, version, cb);
    }

    @Override
    public void asyncGetData(String path, ZkAsyncCallbacks.GetDataCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.asyncGetData(path, cb);
    }

    @Override
    public void asyncExists(String path, ZkAsyncCallbacks.ExistsCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.asyncExists(path, cb);
    }

    @Override
    public void asyncDelete(String path, ZkAsyncCallbacks.DeleteCallbackHandler cb) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.asyncDelete(path, cb);
    }

    @Override
    public void watchForData(String path) {
        this.checkIfPathContainsShardingKey(path);
        this._innerSharedZkClient.watchForData(path);
    }

    @Override
    public List<String> watchForChilds(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.watchForChilds(path);
    }

    @Override
    public long getCreationTime(String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.getCreationTime(path);
    }

    @Override
    public List<OpResult> multi(Iterable<Op> ops) {
        return this._innerSharedZkClient.multi(ops);
    }

    @Override
    public boolean waitUntilConnected(long time, TimeUnit timeUnit) {
        return this._innerSharedZkClient.waitUntilConnected(time, timeUnit);
    }

    @Override
    public String getServers() {
        return this._innerSharedZkClient.getServers();
    }

    @Override
    public long getSessionId() {
        return this._innerSharedZkClient.getSessionId();
    }

    @Override
    public void close() {
        this._innerSharedZkClient.close();
    }

    @Override
    public boolean isClosed() {
        return this._innerSharedZkClient.isClosed();
    }

    @Override
    public byte[] serialize(Object data, String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.serialize(data, path);
    }

    @Override
    public <T> T deserialize(byte[] data, String path) {
        this.checkIfPathContainsShardingKey(path);
        return this._innerSharedZkClient.deserialize(data, path);
    }

    @Override
    public void setZkSerializer(ZkSerializer zkSerializer) {
        this._innerSharedZkClient.setZkSerializer(zkSerializer);
    }

    @Override
    public void setZkSerializer(PathBasedZkSerializer zkSerializer) {
        this._innerSharedZkClient.setZkSerializer(zkSerializer);
    }

    @Override
    public RealmAwareZkClient.RealmAwareZkConnectionConfig getRealmAwareZkConnectionConfig() {
        return this._connectionConfig;
    }

    @Override
    public RealmAwareZkClient.RealmAwareZkClientConfig getRealmAwareZkClientConfig() {
        return this._clientConfig;
    }

    @Override
    public PathBasedZkSerializer getZkSerializer() {
        return this._innerSharedZkClient.getZkSerializer();
    }

    private void checkIfPathContainsShardingKey(String path) {
        try {
            String zkRealmForPath = this._metadataStoreRoutingData.getMetadataStoreRealm(path);
            if (!this._zkRealmAddress.equals(zkRealmForPath)) {
                throw new IllegalArgumentException("Given path: " + path + "'s ZK realm: " + zkRealmForPath + " does not match the ZK realm: " + this._zkRealmAddress + " and sharding key: " + this._zkRealmShardingKey + " for this SharedZkClient!");
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Given path: " + path + " does not have a valid sharding key!");
        }
    }
}

