/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.model.Transition;

public class StateTransitionTableBuilder {
    static int getPathVal(Map<String, Map<String, Integer>> path, String fromState, String toState) {
        if (!path.containsKey(fromState)) {
            return Integer.MAX_VALUE;
        }
        if (!path.get(fromState).containsKey(toState)) {
            return Integer.MAX_VALUE;
        }
        return path.get(fromState).get(toState);
    }

    static void setPathVal(Map<String, Map<String, Integer>> path, String fromState, String toState, int val) {
        if (!path.containsKey(fromState)) {
            path.put(fromState, new HashMap());
        }
        path.get(fromState).put(toState, val);
    }

    static void setNext(Map<String, Map<String, String>> next, String fromState, String toState, String nextState) {
        if (!next.containsKey(fromState)) {
            next.put(fromState, new HashMap());
        }
        next.get(fromState).put(toState, nextState);
    }

    public static String getNext(Map<String, Map<String, String>> next, String fromState, String toState) {
        if (!next.containsKey(fromState)) {
            return null;
        }
        return next.get(fromState).get(toState);
    }

    static void printPath(List<String> states, Map<String, Map<String, String>> next) {
        for (String fromState : states) {
            for (String toState : states) {
                if (toState.equals(fromState)) continue;
                System.out.print(fromState);
                String nextState = StateTransitionTableBuilder.getNext(next, fromState, toState);
                while (nextState != null && !nextState.equals(toState)) {
                    System.out.print("->" + nextState);
                    nextState = StateTransitionTableBuilder.getNext(next, nextState, toState);
                }
                if (nextState == null) {
                    System.out.println("->null" + toState + " (no path avaliable)");
                    continue;
                }
                System.out.println("->" + toState);
            }
        }
    }

    public Map<String, Map<String, String>> buildTransitionTable(List<String> states, List<Transition> transitions) {
        HashMap<String, Map<String, Integer>> path = new HashMap<String, Map<String, Integer>>();
        HashMap<String, Map<String, String>> next = new HashMap<String, Map<String, String>>();
        for (String state : states) {
            StateTransitionTableBuilder.setPathVal(path, state, state, 0);
            StateTransitionTableBuilder.setNext(next, state, state, state);
        }
        for (Transition transition : transitions) {
            String fromState = transition.getFromState();
            String toState = transition.getToState();
            StateTransitionTableBuilder.setPathVal(path, fromState, toState, 1);
            StateTransitionTableBuilder.setNext(next, fromState, toState, toState);
        }
        for (String intermediateState : states) {
            for (String fromState : states) {
                for (String toState : states) {
                    int pathVal1 = StateTransitionTableBuilder.getPathVal(path, fromState, intermediateState);
                    int pathVal2 = StateTransitionTableBuilder.getPathVal(path, intermediateState, toState);
                    int pathValCur = StateTransitionTableBuilder.getPathVal(path, fromState, toState);
                    if (pathVal1 >= Integer.MAX_VALUE || pathVal2 >= Integer.MAX_VALUE || pathVal1 + pathVal2 >= pathValCur) continue;
                    StateTransitionTableBuilder.setPathVal(path, fromState, toState, pathVal1 + pathVal2);
                    StateTransitionTableBuilder.setNext(next, fromState, toState, StateTransitionTableBuilder.getNext(next, fromState, intermediateState));
                }
            }
        }
        return next;
    }

    public static void main(String[] args) {
        ArrayList<String> states = new ArrayList<String>();
        states.add("MASTER");
        states.add("SLAVE");
        states.add("DROPPED");
        states.add("OFFLINE");
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        transitions.add(new Transition("SLAVE", "OFFLINE"));
        transitions.add(new Transition("OFFLINE", "SLAVE"));
        transitions.add(new Transition("SLAVE", "MASTER"));
        transitions.add(new Transition("OFFLINE", "DROPPED"));
        transitions.add(new Transition("MASTER", "SLAVE"));
        StateTransitionTableBuilder builder = new StateTransitionTableBuilder();
        Map<String, Map<String, String>> next = builder.buildTransitionTable(states, transitions);
        System.out.println(next);
        StateTransitionTableBuilder.printPath(states, next);
    }
}

