/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.controller.rebalancer.waged.model.AssignableReplica;
import org.apache.helix.controller.rebalancer.waged.model.ClusterModelProvider;
import org.apache.helix.model.ClusterConfig;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.Partition;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedRebalanceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DelayedRebalanceUtil.class);
    private static final RebalanceScheduler REBALANCE_SCHEDULER = new RebalanceScheduler();

    public static boolean isDelayRebalanceEnabled(ClusterConfig clusterConfig) {
        long delay = clusterConfig.getRebalanceDelayTime();
        return delay > 0L && clusterConfig.isDelayRebalaceEnabled();
    }

    public static boolean isDelayRebalanceEnabled(IdealState idealState, ClusterConfig clusterConfig) {
        long delay = DelayedRebalanceUtil.getRebalanceDelay(idealState, clusterConfig);
        return delay > 0L && idealState.isDelayRebalanceEnabled() && clusterConfig.isDelayRebalaceEnabled();
    }

    public static long getRebalanceDelay(IdealState idealState, ClusterConfig clusterConfig) {
        long delayTime = idealState.getRebalanceDelay();
        if (delayTime < 0L) {
            delayTime = clusterConfig.getRebalanceDelayTime();
        }
        return delayTime;
    }

    public static Set<String> getActiveNodes(Set<String> allNodes, Set<String> liveEnabledNodes, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, ClusterConfig clusterConfig) {
        if (!DelayedRebalanceUtil.isDelayRebalanceEnabled(clusterConfig)) {
            return liveEnabledNodes;
        }
        return DelayedRebalanceUtil.getActiveNodes(allNodes, liveEnabledNodes, instanceOfflineTimeMap, liveNodes, instanceConfigMap, clusterConfig.getRebalanceDelayTime(), clusterConfig);
    }

    public static Set<String> getActiveNodes(Set<String> allNodes, IdealState idealState, Set<String> liveEnabledNodes, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig) {
        if (!DelayedRebalanceUtil.isDelayRebalanceEnabled(idealState, clusterConfig)) {
            return liveEnabledNodes;
        }
        return DelayedRebalanceUtil.getActiveNodes(allNodes, liveEnabledNodes, instanceOfflineTimeMap, liveNodes, instanceConfigMap, delay, clusterConfig);
    }

    private static Set<String> getActiveNodes(Set<String> allNodes, Set<String> liveEnabledNodes, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig) {
        HashSet<String> activeNodes = new HashSet<String>(liveEnabledNodes);
        HashSet<String> offlineOrDisabledInstances = new HashSet<String>(allNodes);
        offlineOrDisabledInstances.removeAll(liveEnabledNodes);
        long currentTime = System.currentTimeMillis();
        for (String ins : offlineOrDisabledInstances) {
            long inactiveTime = DelayedRebalanceUtil.getInactiveTime(ins, liveNodes, instanceOfflineTimeMap.get(ins), delay, instanceConfigMap.get(ins), clusterConfig);
            InstanceConfig instanceConfig = instanceConfigMap.get(ins);
            if (inactiveTime <= currentTime || instanceConfig == null || !instanceConfig.isDelayRebalanceEnabled()) continue;
            activeNodes.add(ins);
        }
        return activeNodes;
    }

    private static long getInactiveTime(String instance, Set<String> liveInstances, Long offlineTime, long delay, InstanceConfig instanceConfig, ClusterConfig clusterConfig) {
        long inactiveTime = Long.MAX_VALUE;
        long lastOnDemandRebalanceTime = clusterConfig.getLastOnDemandRebalanceTimestamp();
        if (!liveInstances.contains(instance)) {
            if (DelayedRebalanceUtil.isInstanceForcedToBeRebalanced(offlineTime, delay, lastOnDemandRebalanceTime)) {
                return -1L;
            }
            if (offlineTime != null && offlineTime > 0L && offlineTime + delay < inactiveTime) {
                inactiveTime = offlineTime + delay;
            }
        }
        if (!instanceConfig.getInstanceEnabled()) {
            long disabledTime = instanceConfig.getInstanceEnabledTime();
            String batchedDisabledTime = clusterConfig.getInstanceHelixDisabledTimeStamp(instance);
            if (batchedDisabledTime != null && !batchedDisabledTime.isEmpty()) {
                long batchDisableTime = Long.parseLong(batchedDisabledTime);
                if (disabledTime == -1L || disabledTime > batchDisableTime) {
                    disabledTime = batchDisableTime;
                }
            }
            if (DelayedRebalanceUtil.isInstanceForcedToBeRebalanced(disabledTime, delay, lastOnDemandRebalanceTime)) {
                return -1L;
            }
            if (disabledTime > 0L && disabledTime + delay < inactiveTime) {
                inactiveTime = disabledTime + delay;
            }
        }
        if (inactiveTime == Long.MAX_VALUE) {
            return -1L;
        }
        return inactiveTime;
    }

    public static Map<String, List<String>> getFinalDelayedMapping(Map<String, List<String>> newIdealPreferenceList, Map<String, List<String>> newDelayedPreferenceList, Set<String> liveEnabledInstances, int minActiveReplica) {
        HashMap<String, List<String>> finalPreferenceList = new HashMap<String, List<String>>();
        for (String partition : newIdealPreferenceList.keySet()) {
            List<String> idealList = newIdealPreferenceList.get(partition);
            List<String> delayedIdealList = newDelayedPreferenceList.get(partition);
            ArrayList<String> liveList = new ArrayList<String>();
            for (String ins : delayedIdealList) {
                if (!liveEnabledInstances.contains(ins)) continue;
                liveList.add(ins);
            }
            if (liveList.size() >= minActiveReplica) {
                finalPreferenceList.put(partition, delayedIdealList);
                continue;
            }
            ArrayList<String> candidates = new ArrayList<String>(idealList);
            candidates.removeAll(delayedIdealList);
            for (String liveIns : candidates) {
                liveList.add(liveIns);
                if (liveList.size() < minActiveReplica) continue;
                break;
            }
            finalPreferenceList.put(partition, liveList);
        }
        return finalPreferenceList;
    }

    public static int getMinActiveReplica(ResourceConfig resourceConfig, IdealState idealState, int replicaCount) {
        int minActiveReplicas;
        int n = minActiveReplicas = resourceConfig == null ? -1 : resourceConfig.getMinActiveReplica();
        if (minActiveReplicas < 0) {
            minActiveReplicas = idealState.getMinActiveReplicas();
        }
        if (minActiveReplicas < 0) {
            minActiveReplicas = replicaCount;
        }
        return minActiveReplicas;
    }

    public static void setRebalanceScheduler(String resourceName, boolean isDelayedRebalanceEnabled, Set<String> offlineOrDisabledInstances, Map<String, Long> instanceOfflineTimeMap, Set<String> liveNodes, Map<String, InstanceConfig> instanceConfigMap, long delay, ClusterConfig clusterConfig, HelixManager manager) {
        if (!isDelayedRebalanceEnabled) {
            REBALANCE_SCHEDULER.removeScheduledRebalance(resourceName);
            return;
        }
        long currentTime = System.currentTimeMillis();
        long nextRebalanceTime = Long.MAX_VALUE;
        for (String ins : offlineOrDisabledInstances) {
            long inactiveTime = DelayedRebalanceUtil.getInactiveTime(ins, liveNodes, instanceOfflineTimeMap.get(ins), delay, instanceConfigMap.get(ins), clusterConfig);
            if (inactiveTime == -1L || inactiveTime <= currentTime || inactiveTime >= nextRebalanceTime) continue;
            nextRebalanceTime = inactiveTime;
        }
        if (nextRebalanceTime == Long.MAX_VALUE) {
            long startTime = REBALANCE_SCHEDULER.removeScheduledRebalance(resourceName);
            LOG.debug("Remove exist rebalance timer for resource {} at {}", (Object)resourceName, (Object)startTime);
        } else {
            long currentScheduledTime = REBALANCE_SCHEDULER.getRebalanceTime(resourceName);
            if (currentScheduledTime < 0L || currentScheduledTime > nextRebalanceTime) {
                REBALANCE_SCHEDULER.scheduleRebalance(manager, resourceName, nextRebalanceTime);
                LOG.debug("Set next rebalance time for resource {} at time {}", (Object)resourceName, (Object)nextRebalanceTime);
            }
        }
    }

    public static Set<AssignableReplica> findToBeAssignedReplicasForMinActiveReplica(ResourceControllerDataProvider clusterData, Set<String> resources, Set<String> liveEnabledInstances, Map<String, ResourceAssignment> currentAssignment, Map<String, Set<AssignableReplica>> allocatedReplicas) {
        Map<String, List<String>> partitionsMissingMinActiveReplicas = DelayedRebalanceUtil.findPartitionsMissingMinActiveReplica(clusterData, currentAssignment);
        HashSet<AssignableReplica> toBeAssignedReplicas = new HashSet<AssignableReplica>();
        for (String resourceName : resources) {
            ResourceAssignment resourceAssignment = currentAssignment.getOrDefault(resourceName, new ResourceAssignment(resourceName));
            IdealState idealState = clusterData.getIdealState(resourceName);
            String modelDef = idealState.getStateModelDefRef();
            Map<String, Integer> statePriorityMap = clusterData.getStateModelDef(modelDef).getStatePriorityMap();
            ResourceConfig mergedResourceConfig = ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), idealState);
            resourceAssignment.getMappedPartitions().forEach(partition -> resourceAssignment.getReplicaMap((Partition)partition).forEach((logicalId, state) -> allocatedReplicas.computeIfAbsent((String)logicalId, key -> new HashSet()).add(new AssignableReplica(clusterData.getClusterConfig(), mergedResourceConfig, partition.getPartitionName(), (String)state, (Integer)statePriorityMap.get(state)))));
            List<String> partitions = partitionsMissingMinActiveReplicas.getOrDefault(resourceName, Collections.emptyList());
            if (partitions.isEmpty()) continue;
            Map<String, Map<String, Set<String>>> stateInstanceMap = ClusterModelProvider.getStateInstanceMap(resourceAssignment);
            toBeAssignedReplicas.addAll(DelayedRebalanceUtil.findAssignableReplicaForResource(clusterData, resourceName, partitions, stateInstanceMap, liveEnabledInstances));
        }
        return toBeAssignedReplicas;
    }

    public static void mergeAssignments(Map<String, ResourceAssignment> newAssignment, Map<String, ResourceAssignment> currentResourceAssignment) {
        newAssignment.entrySet().parallelStream().forEach(entry -> {
            String resourceName = (String)entry.getKey();
            ResourceAssignment assignment = (ResourceAssignment)entry.getValue();
            if (!currentResourceAssignment.containsKey(resourceName)) {
                currentResourceAssignment.put(resourceName, assignment);
            } else {
                for (Partition partition : assignment.getMappedPartitions()) {
                    HashMap<String, String> toMerge = new HashMap<String, String>(((ResourceAssignment)currentResourceAssignment.get(resourceName)).getReplicaMap(partition));
                    assignment.getReplicaMap(partition).forEach((key, value) -> {
                        toMerge.put((String)key, (String)value);
                        ((ResourceAssignment)currentResourceAssignment.get(resourceName)).addReplicaMap(partition, toMerge);
                    });
                }
            }
        });
    }

    private static Map<String, List<String>> findPartitionsMissingMinActiveReplica(ResourceControllerDataProvider clusterData, Map<String, ResourceAssignment> currentAssignment) {
        return currentAssignment.entrySet().parallelStream().map(e -> new AbstractMap.SimpleEntry<String, List<String>>((String)e.getKey(), DelayedRebalanceUtil.findPartitionsMissingMinActiveReplica(clusterData, (ResourceAssignment)e.getValue()))).filter(e -> !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static List<String> findPartitionsMissingMinActiveReplica(ResourceControllerDataProvider clusterData, ResourceAssignment resourceAssignment) {
        String resourceName = resourceAssignment.getResourceName();
        IdealState currentIdealState = clusterData.getIdealState(resourceName);
        Set<String> enabledLiveInstances = clusterData.getEnabledLiveInstances();
        int numReplica = currentIdealState.getReplicaCount(enabledLiveInstances.size());
        int minActiveReplica = DelayedRebalanceUtil.getMinActiveReplica(ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), currentIdealState), currentIdealState, numReplica);
        return resourceAssignment.getMappedPartitions().parallelStream().filter(partition -> {
            long enabledLivePlacementCounter = resourceAssignment.getReplicaMap((Partition)partition).keySet().stream().filter(enabledLiveInstances::contains).count();
            return enabledLivePlacementCounter < (long)Math.min(minActiveReplica, numReplica);
        }).map(Partition::getPartitionName).distinct().collect(Collectors.toList());
    }

    private static int getMinActiveReplica(ResourceControllerDataProvider clusterData, String resourceName) {
        IdealState currentIdealState = clusterData.getIdealState(resourceName);
        Set<String> enabledLiveInstances = clusterData.getEnabledLiveInstances();
        int numReplica = currentIdealState.getReplicaCount(enabledLiveInstances.size());
        return DelayedRebalanceUtil.getMinActiveReplica(ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), currentIdealState), currentIdealState, numReplica);
    }

    private static boolean isInstanceForcedToBeRebalanced(Long offlineOrDisabledTime, long delay, long lastOnDemandRebalanceTime) {
        if (lastOnDemandRebalanceTime == -1L || offlineOrDisabledTime == null || offlineOrDisabledTime <= 0L || System.currentTimeMillis() > offlineOrDisabledTime + delay) {
            return false;
        }
        return offlineOrDisabledTime < lastOnDemandRebalanceTime;
    }

    private static Set<AssignableReplica> findAssignableReplicaForResource(ResourceControllerDataProvider clusterData, String resourceName, List<String> partitions, Map<String, Map<String, Set<String>>> stateInstanceMap, Set<String> liveEnabledInstances) {
        LOG.info("Computing replicas requiring rebalance overwrite for resource: {}", (Object)resourceName);
        List<String> priorityOrderedStates = clusterData.getStateModelDef(clusterData.getIdealState(resourceName).getStateModelDefRef()).getStatesPriorityList();
        IdealState currentIdealState = clusterData.getIdealState(resourceName);
        ResourceConfig resourceConfig = ResourceConfig.mergeIdealStateWithResourceConfig(clusterData.getResourceConfig(resourceName), currentIdealState);
        Map<String, Integer> statePriorityMap = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef()).getStatePriorityMap();
        HashSet<AssignableReplica> toBeAssignedReplicas = new HashSet<AssignableReplica>();
        block0: for (String partitionName : partitions) {
            Map<String, Integer> activeStateReplicaCount = stateInstanceMap.getOrDefault(partitionName, Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (int)((Set)e.getValue()).stream().filter(liveEnabledInstances::contains).count()));
            int activeReplicas = activeStateReplicaCount.values().stream().reduce(Integer::sum).orElse(0);
            int minActiveReplica = DelayedRebalanceUtil.getMinActiveReplica(clusterData, resourceName);
            int replicaGapCount = minActiveReplica - activeReplicas;
            if (replicaGapCount <= 0) continue;
            LinkedHashMap<String, Integer> stateCountMap = clusterData.getStateModelDef(currentIdealState.getStateModelDefRef()).getStateCountMap(minActiveReplica, minActiveReplica);
            for (String state : priorityOrderedStates) {
                if (replicaGapCount <= 0) continue block0;
                int priority = statePriorityMap.get(state);
                int curActiveStateCount = activeStateReplicaCount.getOrDefault(state, 0);
                for (int i = 0; i < (Integer)stateCountMap.get(state) - curActiveStateCount && replicaGapCount > 0; --replicaGapCount, ++i) {
                    toBeAssignedReplicas.add(new AssignableReplica(clusterData.getClusterConfig(), resourceConfig, partitionName, state, priority));
                }
            }
        }
        LOG.info("Replicas: {} need to be brought up for rebalance overwrite.", toBeAssignedReplicas);
        return toBeAssignedReplicas;
    }
}

