/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hadoop.yarn.server.timelineservice.reader.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilterInitializer;

/**
 * Filter initializer to initialize {@link AuthenticationFilter}
 * for ATSv2 timeline reader server with timeline service specific
 * configurations.
 */
public class TimelineReaderAuthenticationFilterInitializer extends
    TimelineAuthenticationFilterInitializer{

  /**
   * Initializes {@link AuthenticationFilter}
   * <p>
   * Propagates to {@link AuthenticationFilter} configuration all
   * YARN configuration properties prefixed with
   * {@value
   *   org.apache.hadoop.yarn.conf.YarnConfiguration#TIMELINE_HTTP_AUTH_PREFIX}.
   *
   * @param container
   *          The filter container
   * @param conf
   *          Configuration for run-time parameters
   */
  @Override
  public void initFilter(FilterContainer container, Configuration conf) {
    setAuthFilterConfig(conf);
    container.addGlobalFilter("Timeline Reader Authentication Filter",
        AuthenticationFilter.class.getName(),
        getFilterConfig());
  }
}
