/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.util.HashMap;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfNamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OdfName
implements Comparable<OdfName> {
    private OdfNamespace mNS;
    private String mLocalName;
    private String mExpandedName;
    private static HashMap<String, OdfName> mOdfNames = new HashMap();

    private OdfName(OdfNamespace ns, String localname, String expandedName) {
        this.mNS = ns;
        this.mLocalName = localname;
        this.mExpandedName = expandedName;
    }

    public static OdfName newName(String name) {
        return OdfName.createName(null, name);
    }

    public static OdfName newName(OdfNamespace odfNamespace, String name) {
        return OdfName.createName(odfNamespace, name);
    }

    public static OdfName newName(NamespaceName namespaceNamed, String name) {
        return OdfName.createName(OdfNamespace.newNamespace(namespaceNamed), name);
    }

    public static OdfName newName(String uri, String qname) {
        String prefix = OdfNamespace.getPrefixPart(qname);
        String localName = OdfNamespace.getLocalPart(qname);
        OdfNamespace ns = OdfNamespace.newNamespace(prefix, uri);
        return OdfName.createName(ns, localName);
    }

    private static OdfName createName(OdfNamespace odfNamespace, String name) {
        int i = 0;
        i = name.indexOf(58);
        if (i >= 0) {
            name = name.substring(i + 1);
        }
        String expandedName = null;
        if (odfNamespace != null) {
            StringBuilder b = new StringBuilder();
            b.append('{');
            b.append(odfNamespace.toString());
            b.append('}');
            b.append(name);
            expandedName = b.toString();
        } else {
            expandedName = name;
        }
        OdfName odfName = mOdfNames.get(expandedName);
        if (odfName != null) {
            return odfName;
        }
        odfName = new OdfName(odfNamespace, name, expandedName);
        mOdfNames.put(expandedName, odfName);
        return odfName;
    }

    public String getUri() {
        if (this.mNS == null) {
            return null;
        }
        return this.mNS.getUri();
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    public String getPrefix() {
        String prefix = null;
        if (this.mNS != null) {
            prefix = this.mNS.getPrefix();
        }
        return prefix;
    }

    public String getQName() {
        if (this.mNS != null) {
            return (this.mNS.getPrefix() + ":" + this.mLocalName).intern();
        }
        return this.mLocalName;
    }

    public String toString() {
        return this.mExpandedName;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public boolean equals(String namespaceUri, String name) {
        if (!this.mNS.getUri().equals(namespaceUri)) {
            return false;
        }
        int beginIndex = name.indexOf(58);
        if (beginIndex >= 0) {
            return this.mLocalName.equals(name.substring(beginIndex + 1));
        }
        return this.mLocalName.equals(name);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(OdfName o) {
        return this.toString().compareTo(o.toString());
    }
}

