/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapCompactSketch;
import org.apache.datasketches.theta.Intersection;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CompactSketchTest {
    private static final boolean COMPACT = true;
    private static final boolean EMPTY = true;
    private static final boolean DIRECT = true;
    private static final boolean MEMORY = true;
    private static final boolean ORDERED = true;
    private static final boolean ESTIMATION = true;

    @Test
    public void checkHeapifyWrap() {
        int k = 4096;
        boolean ordered = true;
        this.checkHeapifyWrap(k, 0, true);
        this.checkHeapifyWrap(k, 1, true);
        this.checkHeapifyWrap(k, 1, false);
        this.checkHeapifyWrap(k, k, true);
        this.checkHeapifyWrap(k, k, false);
        this.checkHeapifyWrap(k, 4 * k, true);
        this.checkHeapifyWrap(k, 4 * k, false);
    }

    public void checkHeapifyWrap(int k, int u, boolean ordered) {
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        CompactSketch refSk = usk.compact(ordered, null);
        byte[] barr = refSk.toByteArray();
        Memory srcMem = Memory.wrap((byte[])barr);
        CompactSketch testSk = (CompactSketch)Sketch.heapify((Memory)srcMem);
        CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
        byte[] byteArray = refSk.toByteArray();
        Memory heapROMem = Memory.wrap((byte[])byteArray);
        testSk = (CompactSketch)Sketch.heapify((Memory)heapROMem);
        CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
        int bytes = usk.getCompactBytes();
        try (WritableMemory directMem = WritableMemory.allocateDirect((long)bytes);){
            refSk = usk.compact(ordered, directMem);
            testSk = (CompactSketch)Sketch.wrap((Memory)directMem);
            CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
            testSk = (CompactSketch)Sketch.wrap((Memory)directMem);
            CompactSketchTest.checkByRange((Sketch)refSk, (Sketch)testSk, u, ordered);
        }
    }

    private static void checkByRange(Sketch refSk, Sketch testSk, int u, boolean ordered) {
        if (u == 0) {
            CompactSketchTest.checkEmptySketch(testSk);
        } else if (u == 1) {
            CompactSketchTest.checkSingleItemSketch(testSk, refSk);
        } else {
            CompactSketchTest.checkOtherCompactSketch(testSk, refSk, ordered);
        }
    }

    private static void checkEmptySketch(Sketch testSk) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertTrue((boolean)(testSk instanceof EmptyCompactSketch));
        Assert.assertTrue((boolean)testSk.isEmpty());
        Assert.assertTrue((boolean)testSk.isOrdered());
        Assert.assertNull((Object)testSk.getMemory());
        Assert.assertFalse((boolean)testSk.isDirect());
        Assert.assertFalse((boolean)testSk.hasMemory());
        Assert.assertEquals((int)testSk.getSeedHash(), (int)0);
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)0);
        Assert.assertEquals((double)testSk.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(), (int)8);
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)8);
        Assert.assertEquals((int)testSk.getCache().length, (int)0);
        Assert.assertEquals((int)testSk.getCompactPreambleLongs(), (int)1);
    }

    private static void checkSingleItemSketch(Sketch testSk, Sketch refSk) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertTrue((boolean)(testSk instanceof SingleItemSketch));
        Assert.assertFalse((boolean)testSk.isEmpty());
        Assert.assertTrue((boolean)testSk.isOrdered());
        Assert.assertNull((Object)testSk.getMemory());
        Assert.assertFalse((boolean)testSk.isDirect());
        Assert.assertFalse((boolean)testSk.hasMemory());
        Assert.assertEquals((short)testSk.getSeedHash(), (short)refSk.getSeedHash());
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)1);
        Assert.assertEquals((double)testSk.getEstimate(), (double)1.0, (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(), (int)16);
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)16);
        Assert.assertEquals((int)testSk.getCache().length, (int)1);
        Assert.assertEquals((int)testSk.getCompactPreambleLongs(), (int)1);
    }

    private static void checkOtherCompactSketch(Sketch testSk, Sketch refSk, boolean ordered) {
        Assert.assertEquals((Object)testSk.getFamily(), (Object)Family.COMPACT);
        Assert.assertFalse((boolean)testSk.isEmpty());
        Assert.assertNotNull((Object)testSk.iterator());
        Assert.assertEquals((boolean)testSk.isOrdered(), (boolean)ordered);
        if (refSk.hasMemory()) {
            Assert.assertTrue((boolean)testSk.hasMemory());
            Assert.assertNotNull((Object)testSk.getMemory());
            if (ordered) {
                Assert.assertTrue((boolean)testSk.isOrdered());
            } else {
                Assert.assertFalse((boolean)testSk.isOrdered());
            }
            if (refSk.isDirect()) {
                Assert.assertTrue((boolean)testSk.isDirect());
            } else {
                Assert.assertFalse((boolean)testSk.isDirect());
            }
        } else {
            Assert.assertFalse((boolean)testSk.hasMemory());
            Assert.assertTrue((boolean)(testSk instanceof HeapCompactSketch));
        }
        Assert.assertEquals((short)testSk.getSeedHash(), (short)refSk.getSeedHash());
        Assert.assertEquals((int)testSk.getRetainedEntries(true), (int)refSk.getRetainedEntries(true));
        Assert.assertEquals((double)testSk.getEstimate(), (double)refSk.getEstimate(), (double)0.0);
        Assert.assertEquals((int)testSk.getCurrentBytes(), (int)refSk.getCurrentBytes());
        Assert.assertEquals((int)testSk.toByteArray().length, (int)refSk.toByteArray().length);
        Assert.assertEquals((int)testSk.getCache().length, (int)refSk.getCache().length);
        Assert.assertEquals((int)testSk.getCompactPreambleLongs(), (int)refSk.getCompactPreambleLongs());
    }

    @Test
    public void checkDirectSingleItemSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        int bytes = sk.getCompactBytes();
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        sk.compact(true, wmem);
        Sketch csk2 = Sketch.heapify((Memory)wmem);
        Assert.assertTrue((boolean)(csk2 instanceof SingleItemSketch));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemTooSmall() {
        int k;
        int u = k = 512;
        boolean ordered = false;
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCompactBytes();
        byte[] byteArray = new byte[bytes - 8];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        usk.compact(ordered, mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemTooSmallOrdered() {
        int k;
        int u = k = 512;
        boolean ordered = true;
        UpdateSketch usk = UpdateSketch.builder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            usk.update((long)i);
        }
        int bytes = usk.getCompactBytes();
        byte[] byteArray = new byte[bytes - 8];
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        usk.compact(ordered, mem);
    }

    @Test
    public void checkCompactCachePart() {
        long[] result = Intersection.compactCachePart(null, (int)4, (int)0, (long)0L, (boolean)false);
        Assert.assertEquals((int)result.length, (int)0);
    }

    @Test
    public void checkEmptyMemoryCompactSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        WritableMemory wmem1 = WritableMemory.allocate((int)16);
        CompactSketch csk1 = sk.compact(false, wmem1);
        State state1 = new State("DirectCompactSketch", 0, 8, true, true, false, true, true, false);
        state1.check(csk1);
        WritableMemory wmem2 = WritableMemory.allocate((int)16);
        CompactSketch csk2 = sk.compact(false, wmem2);
        state1.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        WritableMemory wmem3 = WritableMemory.allocate((int)16);
        CompactSketch csk3 = csk1.compact(false, wmem3);
        state1.check(csk3);
        Assert.assertNotEquals((Object)csk1, (Object)csk3);
        Assert.assertFalse((csk1 == csk3 ? 1 : 0) != 0);
        CompactSketch csk4 = csk1.compact(false, null);
        State state4 = new State("EmptyCompactSketch", 0, 8, true, true, false, false, true, false);
        state4.check(csk4);
        Assert.assertNotEquals((Object)csk1, (Object)csk4);
        Assert.assertFalse((csk1 == csk4 ? 1 : 0) != 0);
        CompactSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkSingleItemMemoryCompactSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        WritableMemory wmem1 = WritableMemory.allocate((int)16);
        CompactSketch csk1 = sk.compact(false, wmem1);
        State state1 = new State("DirectCompactSketch", 1, 16, true, false, false, true, true, false);
        state1.check(csk1);
        WritableMemory wmem2 = WritableMemory.allocate((int)16);
        CompactSketch csk2 = sk.compact(false, wmem2);
        state1.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        WritableMemory wmem3 = WritableMemory.allocate((int)16);
        CompactSketch csk3 = csk1.compact(false, wmem3);
        state1.check(csk3);
        Assert.assertNotEquals((Object)csk1, (Object)csk3);
        Assert.assertFalse((csk1 == csk3 ? 1 : 0) != 0);
        CompactSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkMultipleItemMemoryCompactSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        sk.update(2L);
        sk.update(3L);
        WritableMemory wmem1 = WritableMemory.allocate((int)50);
        CompactSketch csk1 = sk.compact(true, wmem1);
        State state1 = new State("DirectCompactSketch", 3, 40, true, false, false, true, true, false);
        state1.check(csk1);
        WritableMemory wmem2 = WritableMemory.allocate((int)50);
        CompactSketch csk2 = sk.compact(false, wmem2);
        State state2 = new State("DirectCompactSketch", 3, 40, true, false, false, true, false, false);
        state2.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        WritableMemory wmem3 = WritableMemory.allocate((int)50);
        CompactSketch csk3 = csk1.compact(false, wmem3);
        state2.check(csk3);
        Assert.assertNotEquals((Object)csk1, (Object)csk3);
        Assert.assertFalse((csk1 == csk3 ? 1 : 0) != 0);
        CompactSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkEmptyHeapCompactSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        CompactSketch csk1 = sk.compact(false, null);
        State state1 = new State("EmptyCompactSketch", 0, 8, true, true, false, false, true, false);
        state1.check(csk1);
        CompactSketch csk2 = sk.compact(false, null);
        state1.check(csk1);
        Assert.assertEquals((Object)csk1, (Object)csk2);
        Assert.assertTrue((csk1 == csk2 ? 1 : 0) != 0);
        CompactSketch csk3 = csk1.compact(false, null);
        state1.check(csk3);
        Assert.assertEquals((Object)csk1, (Object)csk3);
        Assert.assertTrue((csk1 == csk3 ? 1 : 0) != 0);
        CompactSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkSingleItemHeapCompactSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        CompactSketch csk1 = sk.compact(false, null);
        State state1 = new State("SingleItemSketch", 1, 16, true, false, false, false, true, false);
        state1.check(csk1);
        CompactSketch csk2 = sk.compact(false, null);
        state1.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        CompactSketch csk3 = csk1.compact(false, null);
        state1.check(csk3);
        Assert.assertEquals((Object)csk1, (Object)csk3);
        Assert.assertTrue((csk1 == csk3 ? 1 : 0) != 0);
        CompactSketch cskc = csk1.compact();
        state1.check(csk1);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkMultipleItemHeapCompactSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        sk.update(2L);
        sk.update(3L);
        CompactSketch csk1 = sk.compact(true, null);
        State state1 = new State("HeapCompactSketch", 3, 40, true, false, false, false, true, false);
        state1.check(csk1);
        CompactSketch csk2 = sk.compact(false, null);
        State state2 = new State("HeapCompactSketch", 3, 40, true, false, false, false, false, false);
        state2.check(csk2);
        Assert.assertNotEquals((Object)csk1, (Object)csk2);
        Assert.assertFalse((csk1 == csk2 ? 1 : 0) != 0);
        CompactSketch csk3 = csk1.compact(true, null);
        state1.check(csk3);
        Assert.assertEquals((Object)csk1, (Object)csk3);
        Assert.assertTrue((csk1 == csk3 ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)csk2, (Object)csk3);
        Assert.assertFalse((csk2 == csk3 ? 1 : 0) != 0);
        CompactSketch cskc = csk1.compact();
        state1.check(cskc);
        Assert.assertEquals((Object)csk1, (Object)cskc);
        Assert.assertTrue((csk1 == cskc ? 1 : 0) != 0);
    }

    @Test
    public void checkHeapifySingleItemSketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        int bytes = Sketches.getMaxCompactSketchBytes((int)2);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        sk.compact(false, wmem);
        Sketch csk = Sketch.heapify((Memory)wmem);
        Assert.assertTrue((boolean)(csk instanceof SingleItemSketch));
    }

    @Test
    public void checkHeapifyEmptySketch() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        WritableMemory wmem = WritableMemory.allocate((int)16);
        CompactSketch csk = sk.compact(false, wmem);
        Assert.assertTrue((boolean)(csk instanceof DirectCompactSketch));
        Sketch csk2 = Sketch.heapify((Memory)wmem);
        Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
    }

    @Test
    public void checkGetCache() {
        UpdateSketch sk = Sketches.updateSketchBuilder().setP(0.5f).build();
        sk.update(7L);
        int bytes = sk.getCompactBytes();
        CompactSketch csk = sk.compact(true, WritableMemory.allocate((int)bytes));
        long[] cache = csk.getCache();
        Assert.assertTrue((cache.length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void checkHeapCompactSketchCompact() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        sk.update(1L);
        sk.update(2L);
        CompactSketch csk = sk.compact();
        Assert.assertTrue((boolean)csk.isOrdered());
        Assert.assertEquals((int)csk.getCurrentPreambleLongs(), (int)2);
    }

    @Test
    public void checkDirectCompactSketchCompact() {
        int lgK = 6;
        UpdateSketch sk = Sketches.updateSketchBuilder().setLogNominalEntries(lgK).build();
        int bytes = sk.getCompactBytes();
        WritableMemory wmem1 = WritableMemory.allocate((int)bytes);
        WritableMemory wmem2 = WritableMemory.allocate((int)bytes);
        CompactSketch csk1 = sk.compact(false, wmem1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk1.isOrdered());
        CompactSketch csk2 = csk1.compact(false, wmem2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)8);
        sk.update(1L);
        bytes = sk.getCompactBytes();
        wmem1 = WritableMemory.allocate((int)bytes);
        wmem2 = WritableMemory.allocate((int)bytes);
        csk1 = sk.compact(false, wmem1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk1.isOrdered());
        csk2 = csk1.compact(false, wmem2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)16);
        sk.update(2L);
        bytes = sk.getCompactBytes();
        wmem1 = WritableMemory.allocate((int)bytes);
        wmem2 = WritableMemory.allocate((int)bytes);
        csk1 = sk.compact(false, wmem1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertFalse((boolean)csk1.isOrdered());
        csk2 = csk1.compact(true, wmem2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)32);
        int n = 1 << lgK + 1;
        for (int i = 2; i < n; ++i) {
            sk.update((long)i);
        }
        bytes = sk.getCompactBytes();
        wmem1 = WritableMemory.allocate((int)bytes);
        wmem2 = WritableMemory.allocate((int)bytes);
        csk1 = sk.compact(false, wmem1);
        Assert.assertTrue((boolean)(csk1 instanceof DirectCompactSketch));
        Assert.assertFalse((boolean)csk1.isOrdered());
        csk2 = csk1.compact(true, wmem2);
        Assert.assertTrue((boolean)(csk2 instanceof DirectCompactSketch));
        Assert.assertTrue((boolean)csk2.isOrdered());
        Assert.assertTrue((csk2.getSeedHash() != 0 ? 1 : 0) != 0);
        int curCount = csk2.getRetainedEntries();
        Assert.assertEquals((int)csk2.getCompactBytes(), (int)(24 + curCount * 8));
    }

    @Test
    public void serializeDeserializeHeapV4() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
        CompactSketch cs1 = sk.compact();
        byte[] bytes = cs1.toByteArrayCompressed();
        CompactSketch cs2 = CompactSketch.heapify((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)cs1.getRetainedEntries(), (int)cs2.getRetainedEntries());
        HashIterator it1 = cs1.iterator();
        HashIterator it2 = cs2.iterator();
        while (it1.next() && it2.next()) {
            Assert.assertEquals((long)it2.get(), (long)it2.get());
        }
    }

    @Test
    public void serializeDeserializeDirectV4() {
        UpdateSketch sk = Sketches.updateSketchBuilder().build();
        for (int i = 0; i < 10000; ++i) {
            sk.update((long)i);
        }
        CompactSketch cs1 = sk.compact(true, WritableMemory.allocate((int)sk.getCompactBytes()));
        byte[] bytes = cs1.toByteArrayCompressed();
        CompactSketch cs2 = CompactSketch.wrap((Memory)Memory.wrap((byte[])bytes));
        Assert.assertEquals((int)cs1.getRetainedEntries(), (int)cs2.getRetainedEntries());
        HashIterator it1 = cs1.iterator();
        HashIterator it2 = cs2.iterator();
        while (it1.next() && it2.next()) {
            Assert.assertEquals((long)it2.get(), (long)it2.get());
        }
    }

    @Test
    public void printlnTest() {
        CompactSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    private static class State {
        String classType = null;
        int count = 0;
        int bytes = 0;
        boolean compact = false;
        boolean empty = false;
        boolean direct = false;
        boolean memory = false;
        boolean ordered = false;
        boolean estimation = false;

        State(String classType, int count, int bytes, boolean compact, boolean empty, boolean direct, boolean memory, boolean ordered, boolean estimation) {
            this.classType = classType;
            this.count = count;
            this.bytes = bytes;
            this.compact = compact;
            this.empty = empty;
            this.direct = direct;
            this.memory = memory;
            this.ordered = ordered;
            this.estimation = estimation;
        }

        void check(CompactSketch csk) {
            Assert.assertEquals((String)csk.getClass().getSimpleName(), (String)this.classType, (String)"ClassType");
            Assert.assertEquals((int)csk.getRetainedEntries(true), (int)this.count, (String)"curCount");
            Assert.assertEquals((int)csk.getCurrentBytes(), (int)this.bytes, (String)"Bytes");
            Assert.assertEquals((boolean)csk.isCompact(), (boolean)this.compact, (String)"Compact");
            Assert.assertEquals((boolean)csk.isEmpty(), (boolean)this.empty, (String)"Empty");
            Assert.assertEquals((boolean)csk.isDirect(), (boolean)this.direct, (String)"Direct");
            Assert.assertEquals((boolean)csk.hasMemory(), (boolean)this.memory, (String)"Memory");
            Assert.assertEquals((boolean)csk.isOrdered(), (boolean)this.ordered, (String)"Ordered");
            Assert.assertEquals((boolean)csk.isEstimationMode(), (boolean)this.estimation, (String)"Estimation");
        }
    }
}

