/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.AbstractCoupons;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.PreambleUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DirectCouponListTest {
    @Test
    public void promotionTests() {
        DirectCouponListTest.promotions(8, 7, TgtHllType.HLL_8, true, CurMode.LIST);
        DirectCouponListTest.promotions(8, 7, TgtHllType.HLL_8, false, CurMode.LIST);
        DirectCouponListTest.promotions(8, 24, TgtHllType.HLL_8, true, CurMode.SET);
        DirectCouponListTest.promotions(8, 24, TgtHllType.HLL_8, false, CurMode.SET);
        DirectCouponListTest.promotions(8, 25, TgtHllType.HLL_8, true, CurMode.HLL);
        DirectCouponListTest.promotions(8, 25, TgtHllType.HLL_8, false, CurMode.HLL);
        DirectCouponListTest.promotions(8, 25, TgtHllType.HLL_6, true, CurMode.HLL);
        DirectCouponListTest.promotions(8, 25, TgtHllType.HLL_6, false, CurMode.HLL);
        DirectCouponListTest.promotions(8, 25, TgtHllType.HLL_4, true, CurMode.HLL);
        DirectCouponListTest.promotions(8, 25, TgtHllType.HLL_4, false, CurMode.HLL);
        DirectCouponListTest.promotions(4, 7, TgtHllType.HLL_8, true, CurMode.LIST);
        DirectCouponListTest.promotions(4, 7, TgtHllType.HLL_8, false, CurMode.LIST);
        DirectCouponListTest.promotions(4, 8, TgtHllType.HLL_8, true, CurMode.HLL);
        DirectCouponListTest.promotions(4, 8, TgtHllType.HLL_8, false, CurMode.HLL);
        DirectCouponListTest.promotions(4, 8, TgtHllType.HLL_6, true, CurMode.HLL);
        DirectCouponListTest.promotions(4, 8, TgtHllType.HLL_6, false, CurMode.HLL);
        DirectCouponListTest.promotions(4, 8, TgtHllType.HLL_4, true, CurMode.HLL);
        DirectCouponListTest.promotions(4, 8, TgtHllType.HLL_4, false, CurMode.HLL);
        DirectCouponListTest.promotions(4, 25, TgtHllType.HLL_4, true, CurMode.HLL);
        DirectCouponListTest.promotions(4, 25, TgtHllType.HLL_4, false, CurMode.HLL);
    }

    private static void promotions(int lgConfigK, int n, TgtHllType tgtHllType, boolean compact, CurMode tgtMode) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgConfigK, (TgtHllType)tgtHllType);
        WritableMemory wmem = WritableMemory.allocateDirect((long)bytes);
        HllSketch hllSketch = new HllSketch(lgConfigK, tgtHllType, wmem);
        Assert.assertTrue((boolean)hllSketch.isEmpty());
        for (int i = 0; i < n; ++i) {
            hllSketch.update((long)i);
        }
        Assert.assertFalse((boolean)hllSketch.isEmpty());
        Assert.assertEquals((Object)hllSketch.getCurMode(), (Object)tgtMode);
        Assert.assertTrue((boolean)hllSketch.isMemory());
        Assert.assertTrue((boolean)hllSketch.isOffHeap());
        Assert.assertTrue((boolean)hllSketch.isSameResource((Memory)wmem));
        byte[] barr1 = compact ? hllSketch.toCompactByteArray() : hllSketch.toUpdatableByteArray();
        hllSketch.reset();
        Assert.assertTrue((boolean)hllSketch.isEmpty());
        HllSketch hllSketch2 = new HllSketch(lgConfigK, tgtHllType);
        for (int i = 0; i < n; ++i) {
            hllSketch2.update((long)i);
        }
        Assert.assertEquals((Object)hllSketch2.getCurMode(), (Object)tgtMode);
        Assert.assertFalse((boolean)hllSketch2.isMemory());
        Assert.assertFalse((boolean)hllSketch2.isOffHeap());
        Assert.assertFalse((boolean)hllSketch2.isSameResource((Memory)wmem));
        byte[] barr2 = compact ? hllSketch2.toCompactByteArray() : hllSketch2.toUpdatableByteArray();
        Assert.assertEquals((int)barr1.length, (int)barr2.length, (String)(barr1.length + ", " + barr2.length));
        Assert.assertEquals((byte[])barr1, (byte[])barr2);
        wmem.close();
    }

    private static void printDiffs(byte[] arr1, byte[] arr2) {
        int len1 = arr1.length;
        int len2 = arr2.length;
        int minLen = Math.min(len1, len2);
        for (int i = 0; i < minLen; ++i) {
            int v1 = arr1[i] & 0xFF;
            int v2 = arr2[i] & 0xFF;
            if (v1 == v2) continue;
            DirectCouponListTest.println(i + ", " + v1 + ", " + v2);
        }
    }

    @Test
    public void checkCouponToByteArray() {
        int i;
        int lgK = 8;
        TgtHllType type = TgtHllType.HLL_8;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)type);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgK, type, wmem);
        for (i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        byte[] compactByteArr = sk.toCompactByteArray();
        Memory compactMem = Memory.wrap((byte[])compactByteArr);
        HllSketch skCompact = HllSketch.wrap((Memory)compactMem);
        byte[] compactByteArr2 = skCompact.toCompactByteArray();
        Assert.assertEquals((byte[])compactByteArr2, (byte[])compactByteArr);
        byte[] updatableByteArr = sk.toUpdatableByteArray();
        byte[] updatableByteArr2 = skCompact.toUpdatableByteArray();
        Assert.assertEquals((int)updatableByteArr2.length, (int)updatableByteArr.length);
        Assert.assertEquals((double)skCompact.getEstimate(), (double)sk.getEstimate());
        sk.update((long)i);
        compactByteArr = sk.toCompactByteArray();
        compactMem = Memory.wrap((byte[])compactByteArr);
        skCompact = HllSketch.wrap((Memory)compactMem);
        compactByteArr2 = skCompact.toCompactByteArray();
        Assert.assertEquals((byte[])compactByteArr2, (byte[])compactByteArr);
        updatableByteArr = sk.toUpdatableByteArray();
        updatableByteArr2 = skCompact.toUpdatableByteArray();
        Assert.assertEquals((int)updatableByteArr2.length, (int)updatableByteArr.length);
        Assert.assertEquals((double)skCompact.getEstimate(), (double)sk.getEstimate());
    }

    @Test
    public void checkDirectGetCouponIntArr() {
        int lgK = 8;
        TgtHllType type = TgtHllType.HLL_8;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)type);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgK, type, wmem);
        AbstractCoupons absCoup = (AbstractCoupons)sk.hllSketchImpl;
        Assert.assertNull((Object)absCoup.getCouponIntArr());
    }

    @Test
    public void checkBasicGetLgCouponArrInts() {
        int i;
        int lgK = 8;
        TgtHllType type = TgtHllType.HLL_8;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)type);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgK, type, wmem);
        for (i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.LIST);
        Assert.assertEquals((int)((AbstractCoupons)sk.hllSketchImpl).getLgCouponArrInts(), (int)3);
        sk.update(7L);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.SET);
        Assert.assertEquals((int)((AbstractCoupons)sk.hllSketchImpl).getLgCouponArrInts(), (int)5);
        sk.reset();
        for (i = 0; i < 7; ++i) {
            sk.update((long)i);
        }
        byte lgArr = wmem.getByte((long)PreambleUtil.LG_ARR_BYTE);
        wmem.putByte((long)PreambleUtil.LG_ARR_BYTE, (byte)0);
        Assert.assertEquals((int)((AbstractCoupons)sk.hllSketchImpl).getLgCouponArrInts(), (int)3);
        wmem.putByte((long)PreambleUtil.LG_ARR_BYTE, lgArr);
        sk.update(7L);
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.SET);
        Assert.assertEquals((Object)sk.hllSketchImpl.curMode, (Object)CurMode.SET);
        wmem.putByte((long)PreambleUtil.LG_ARR_BYTE, (byte)0);
        Assert.assertEquals((int)((AbstractCoupons)sk.hllSketchImpl).getLgCouponArrInts(), (int)5);
    }

    @Test
    public void checkHeapifyGetLgCouponArrInts() {
        int lgK = 8;
        TgtHllType type = TgtHllType.HLL_8;
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)type);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        HllSketch sk = new HllSketch(lgK, type, wmem);
        for (int i = 0; i < 8; ++i) {
            sk.update((long)i);
        }
        Assert.assertEquals((Object)sk.getCurMode(), (Object)CurMode.SET);
        double est1 = sk.getEstimate();
        wmem.putByte((long)PreambleUtil.LG_ARR_BYTE, (byte)0);
        HllSketch sk2 = HllSketch.heapify((Memory)wmem);
        double est2 = sk2.getEstimate();
        Assert.assertEquals((double)est2, (double)est1, (double)0.0);
    }

    @Test
    public void printlnTest() {
        DirectCouponListTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

