/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import org.apache.datasketches.common.BoundsOnBinomialProportions;
import org.apache.datasketches.common.SketchesArgumentException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BoundsOnBinomialProportionsTest {
    @Test
    public static void tinyLBTest() {
        double[] answers = new double[]{0.0, 0.004592032688529923, 0.04725537386564205, 0.1396230607626959, 0.2735831034867167, 0.4692424353373485};
        double kappa = 2.0;
        Assert.assertTrue((0.0 == BoundsOnBinomialProportions.approximateLowerBoundOnP((long)0L, (long)0L, (double)2.0) ? 1 : 0) != 0);
        long n = 5L;
        for (long k = 0L; k <= 5L; ++k) {
            double est;
            double lb = BoundsOnBinomialProportions.approximateLowerBoundOnP((long)5L, (long)k, (double)2.0);
            Assert.assertTrue((lb <= (est = BoundsOnBinomialProportions.estimateUnknownP((long)5L, (long)k)) ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(lb - answers[(int)k]) < 1.0E-14 ? 1 : 0) != 0);
        }
    }

    @Test
    public static void tinyUBTest() {
        double[] answers = new double[]{0.5307575646626514, 0.7264168965132833, 0.860376939237304, 0.952744626134358, 0.9954079673114701, 1.0};
        double kappa = 2.0;
        Assert.assertTrue((1.0 == BoundsOnBinomialProportions.approximateUpperBoundOnP((long)0L, (long)0L, (double)2.0) ? 1 : 0) != 0);
        long n = 5L;
        for (long k = 0L; k <= 5L; ++k) {
            double est;
            double ub = BoundsOnBinomialProportions.approximateUpperBoundOnP((long)5L, (long)k, (double)2.0);
            Assert.assertTrue((ub >= (est = BoundsOnBinomialProportions.estimateUnknownP((long)5L, (long)k)) ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(ub - answers[(int)k]) < 1.0E-14 ? 1 : 0) != 0);
        }
    }

    public static void lotsOfSpewage(long maxN) {
        for (long n = 0L; n <= maxN; ++n) {
            for (long k = 0L; k <= n; ++k) {
                for (double kappa = 0.5; kappa < 5.0; kappa += 0.5) {
                    double lb = BoundsOnBinomialProportions.approximateLowerBoundOnP((long)n, (long)k, (double)kappa);
                    double ub = BoundsOnBinomialProportions.approximateUpperBoundOnP((long)n, (long)k, (double)kappa);
                    double est = BoundsOnBinomialProportions.estimateUnknownP((long)n, (long)k);
                    Assert.assertTrue((lb <= est ? 1 : 0) != 0);
                    Assert.assertTrue((ub >= est ? 1 : 0) != 0);
                    String slb = String.format("LB\t%d\t%d\t%.1f\t%.16g%n", n, k, kappa, lb);
                    String sub = String.format("UB\t%d\t%d\t%.1f\t%.16g%n", n, k, kappa, ub);
                    BoundsOnBinomialProportionsTest.println(slb);
                    BoundsOnBinomialProportionsTest.println(sub);
                }
            }
        }
    }

    public static void printSomeNormalCDF() {
        double[] someX = new double[]{-10.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 10.0};
        for (int i = 0; i < 11; ++i) {
            String s = String.format("normalCDF(%.1f) = %.12f%n", someX[i], BoundsOnBinomialProportions.normalCDF((double)someX[i]));
            BoundsOnBinomialProportionsTest.println(s);
        }
    }

    @Test
    public static void checkNumStdDevZero() {
        double lb = BoundsOnBinomialProportions.approximateLowerBoundOnP((long)1000L, (long)100L, (double)0.0);
        double ub = BoundsOnBinomialProportions.approximateUpperBoundOnP((long)1000L, (long)100L, (double)0.0);
        BoundsOnBinomialProportionsTest.println("LB: " + lb);
        BoundsOnBinomialProportionsTest.println("UB: " + ub);
    }

    @Test
    public static void checkInputs() {
        try {
            BoundsOnBinomialProportions.estimateUnknownP((long)-1L, (long)50L);
            Assert.fail((String)"Should have thrown SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            BoundsOnBinomialProportions.estimateUnknownP((long)500L, (long)-50L);
            Assert.fail((String)"Should have thrown SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            BoundsOnBinomialProportions.estimateUnknownP((long)500L, (long)5000L);
            Assert.fail((String)"Should have thrown SketchesArgumentException.");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((double)BoundsOnBinomialProportions.estimateUnknownP((long)0L, (long)0L), (double)0.5, (double)0.0);
    }

    @Test
    public static void checkErf() {
        Assert.assertTrue((BoundsOnBinomialProportions.erf((double)-2.0) < 0.99 ? 1 : 0) != 0);
        Assert.assertTrue((BoundsOnBinomialProportions.erf((double)2.0) > 0.99 ? 1 : 0) != 0);
    }

    @Test
    public void printlnTest() {
        BoundsOnBinomialProportionsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

