/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.dpath;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.core.dpath.AdditiveExpression$;
import org.apache.daffodil.core.dpath.AndExpression$;
import org.apache.daffodil.core.dpath.ComparisonExpression$;
import org.apache.daffodil.core.dpath.DownStepExpression;
import org.apache.daffodil.core.dpath.Expression;
import org.apache.daffodil.core.dpath.FunctionCallExpression;
import org.apache.daffodil.core.dpath.FunctionCallExpression$;
import org.apache.daffodil.core.dpath.IfExpression$;
import org.apache.daffodil.core.dpath.LiteralExpression;
import org.apache.daffodil.core.dpath.LiteralExpression$;
import org.apache.daffodil.core.dpath.MultiplicativeExpression$;
import org.apache.daffodil.core.dpath.NamedStep$;
import org.apache.daffodil.core.dpath.OrExpression$;
import org.apache.daffodil.core.dpath.ParenthesizedExpression;
import org.apache.daffodil.core.dpath.ParenthesizedExpression$;
import org.apache.daffodil.core.dpath.PathExpression;
import org.apache.daffodil.core.dpath.PathExpressionNoContextError;
import org.apache.daffodil.core.dpath.PredicateExpression;
import org.apache.daffodil.core.dpath.PredicateExpression$;
import org.apache.daffodil.core.dpath.PrimaryExpression;
import org.apache.daffodil.core.dpath.RelativePathExpression;
import org.apache.daffodil.core.dpath.RelativePathExpression$;
import org.apache.daffodil.core.dpath.RootPathExpression$;
import org.apache.daffodil.core.dpath.Self$;
import org.apache.daffodil.core.dpath.Self2$;
import org.apache.daffodil.core.dpath.StepExpression;
import org.apache.daffodil.core.dpath.UnaryExpression$;
import org.apache.daffodil.core.dpath.Up$;
import org.apache.daffodil.core.dpath.Up2$;
import org.apache.daffodil.core.dpath.UpStepExpression;
import org.apache.daffodil.core.dpath.VariableRef;
import org.apache.daffodil.core.dpath.VariableRef$;
import org.apache.daffodil.core.dpath.WholeExpression;
import org.apache.daffodil.core.dpath.WholeExpression$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.WarnID$ExpressionCompilationSkipped$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NamedQName;
import org.apache.daffodil.lib.xml.QNameRegex$;
import org.apache.daffodil.runtime1.BasicComponent;
import org.apache.daffodil.runtime1.dpath.CompiledDPath;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.RecipeOp;
import org.apache.daffodil.runtime1.dpath.RuntimeAbortOp$;
import org.apache.daffodil.runtime1.dpath.RuntimeExpressionDPath;
import org.apache.daffodil.runtime1.dsom.CompiledExpression;
import org.apache.daffodil.runtime1.dsom.ConstantExpression;
import org.apache.daffodil.runtime1.dsom.DPathCompileInfo;
import org.apache.daffodil.runtime1.dsom.DPathElementCompileInfo;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.matching.Regex;
import scala.util.parsing.combinator.Parsers;
import scala.util.parsing.combinator.Parsers$;
import scala.util.parsing.combinator.Parsers$$tilde$;
import scala.util.parsing.combinator.Parsers$Error$;
import scala.util.parsing.combinator.Parsers$Failure$;
import scala.util.parsing.combinator.Parsers$NoSuccess$;
import scala.util.parsing.combinator.Parsers$Success$;
import scala.util.parsing.combinator.RegexParsers;
import scala.util.parsing.input.CharSequenceReader;
import scala.util.parsing.input.Reader;
import scala.xml.NamespaceBinding;

public class DFDLPathExpressionParser<T>
implements RegexParsers {
    public static final long OFFSET$4 = LazyVals$.MODULE$.getOffsetStatic(DFDLPathExpressionParser.class.getDeclaredField("$tilde$lzy1"));
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(DFDLPathExpressionParser.class.getDeclaredField("Error$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(DFDLPathExpressionParser.class.getDeclaredField("Failure$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DFDLPathExpressionParser.class.getDeclaredField("NoSuccess$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DFDLPathExpressionParser.class.getDeclaredField("Success$lzy1"));
    private volatile Object Success$lzy1;
    private volatile Object NoSuccess$lzy1;
    private volatile Object Failure$lzy1;
    private volatile Object Error$lzy1;
    private volatile Object $tilde$lzy1;
    private Regex whiteSpace;
    private final NamedQName qn;
    private final NodeInfo.Kind nodeInfoKind;
    private final NamespaceBinding namespaces;
    private final NS noPrefixNamespace;
    private final DPathCompileInfo context;
    private final boolean isEvaluatedAbove;
    private final BasicComponent host;
    private final boolean skipWhitespace;
    private final boolean verboseParse;
    private final Parsers.Parser SuccessAtEnd;
    private final Regex Digits;
    private final Parsers.Parser optDigits;
    private final Parsers.Parser Expon;
    private final Parsers.Parser plusMinus;
    private final Parsers.Parser DecimalLiteral;
    private final Parsers.Parser DoubleLiteral;
    private final Parsers.Parser StringLiteral;

    public DFDLPathExpressionParser(NamedQName qn, NodeInfo.Kind nodeInfoKind, NamespaceBinding namespaces, NS noPrefixNamespace, DPathCompileInfo context, boolean isEvaluatedAbove, BasicComponent host) {
        this.qn = qn;
        this.nodeInfoKind = nodeInfoKind;
        this.namespaces = namespaces;
        this.noPrefixNamespace = noPrefixNamespace;
        this.context = context;
        this.isEvaluatedAbove = isEvaluatedAbove;
        this.host = host;
        RegexParsers.$init$((RegexParsers)this);
        this.skipWhitespace = true;
        this.verboseParse = false;
        this.SuccessAtEnd = this.Parser((Function1 & Serializable)in -> this.Success().apply(in, (Reader)new CharSequenceReader((CharSequence)"")));
        this.Digits = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[0-9]+"));
        this.optDigits = this.regex(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[0-9]*")));
        this.Expon = this.regex(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[eE][+-]?[0-9]{1,3}")));
        this.plusMinus = this.regex(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[+-]?")));
        this.DecimalLiteral = this.literal(".").$tilde$greater(this::$init$$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            String string;
            String dig = string = x$1;
            return new BigDecimal("0." + dig);
        }).$bar(this::$init$$$anonfun$4);
        this.DoubleLiteral = this.literal(".").$tilde$greater(this::$init$$$anonfun$5).$tilde(this::$init$$$anonfun$6).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                String fraction = (String)tilde3._1();
                String exp = (String)tilde3._2();
                return "0." + fraction + exp;
            }
            throw new MatchError((Object)tilde2);
        }).$bar(this::$init$$$anonfun$8).$up$up((Function1 & Serializable)str -> Predef$.MODULE$.double2Double(Double.parseDouble(str)));
        String escapeQuot = "\\\"\\\"";
        String notQuot = "[^\"]";
        String escapeApos = "''";
        String notApos = "[^']";
        String doubleQuotedBody = DFDLPathExpressionParser.quotedBody$1(escapeQuot, notQuot);
        String singleQuotedBody = DFDLPathExpressionParser.quotedBody$1(escapeApos, notApos);
        String stringLit = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("(\\\"%s\\\")|(\\'%s\\')"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{doubleQuotedBody, singleQuotedBody}));
        Regex stringLitRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(stringLit));
        this.StringLiteral = this.regex(stringLitRegex).$up$up((Function1 & Serializable)sl -> {
            if (sl.length() == 2) {
                return "";
            }
            return sl.substring(1, sl.length() - 1);
        });
        Statics.releaseFence();
    }

    public final Parsers$Success$ Success() {
        Object object = this.Success$lzy1;
        if (object instanceof Parsers$Success$) {
            return (Parsers$Success$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Parsers$Success$)this.Success$lzyINIT1();
    }

    private Object Success$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Success$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Parsers$Success$ parsers$Success$ = null;
                    try {
                        parsers$Success$ = new Parsers$Success$((Parsers)this);
                        object2 = parsers$Success$ == null ? LazyVals.NullValue$.MODULE$ : parsers$Success$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Success$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return parsers$Success$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Parsers$NoSuccess$ NoSuccess() {
        Object object = this.NoSuccess$lzy1;
        if (object instanceof Parsers$NoSuccess$) {
            return (Parsers$NoSuccess$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Parsers$NoSuccess$)this.NoSuccess$lzyINIT1();
    }

    private Object NoSuccess$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.NoSuccess$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Parsers$NoSuccess$ parsers$NoSuccess$ = null;
                    try {
                        parsers$NoSuccess$ = new Parsers$NoSuccess$((Parsers)this);
                        object2 = parsers$NoSuccess$ == null ? LazyVals.NullValue$.MODULE$ : parsers$NoSuccess$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.NoSuccess$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return parsers$NoSuccess$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Parsers$Failure$ Failure() {
        Object object = this.Failure$lzy1;
        if (object instanceof Parsers$Failure$) {
            return (Parsers$Failure$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Parsers$Failure$)this.Failure$lzyINIT1();
    }

    private Object Failure$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Failure$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Parsers$Failure$ parsers$Failure$ = null;
                    try {
                        parsers$Failure$ = new Parsers$Failure$((Parsers)this);
                        object2 = parsers$Failure$ == null ? LazyVals.NullValue$.MODULE$ : parsers$Failure$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Failure$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return parsers$Failure$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Parsers$Error$ Error() {
        Object object = this.Error$lzy1;
        if (object instanceof Parsers$Error$) {
            return (Parsers$Error$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Parsers$Error$)this.Error$lzyINIT1();
    }

    private Object Error$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.Error$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Parsers$Error$ parsers$Error$ = null;
                    try {
                        parsers$Error$ = new Parsers$Error$((Parsers)this);
                        object2 = parsers$Error$ == null ? LazyVals.NullValue$.MODULE$ : parsers$Error$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.Error$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return parsers$Error$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public final Parsers$$tilde$ $tilde() {
        Object object = this.$tilde$lzy1;
        if (object instanceof Parsers$$tilde$) {
            return (Parsers$$tilde$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Parsers$$tilde$)this.$tilde$lzyINIT1();
    }

    private Object $tilde$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.$tilde$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Parsers$$tilde$ parsers$$tilde$ = null;
                    try {
                        parsers$$tilde$ = new Parsers$$tilde$((Parsers)this);
                        object2 = parsers$$tilde$ == null ? LazyVals.NullValue$.MODULE$ : parsers$$tilde$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.$tilde$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return parsers$$tilde$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$4, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Regex whiteSpace() {
        return this.whiteSpace;
    }

    public void scala$util$parsing$combinator$RegexParsers$_setter_$whiteSpace_$eq(Regex x$0) {
        this.whiteSpace = x$0;
    }

    public /* synthetic */ Parsers.Parser scala$util$parsing$combinator$RegexParsers$$super$positioned(Function0 p) {
        return Parsers.positioned$((Parsers)this, (Function0)p);
    }

    public /* synthetic */ Parsers.Parser scala$util$parsing$combinator$RegexParsers$$super$err(String msg) {
        return Parsers.err$((Parsers)this, (String)msg);
    }

    public /* synthetic */ Parsers.Parser scala$util$parsing$combinator$RegexParsers$$super$phrase(Parsers.Parser p) {
        return Parsers.phrase$((Parsers)this, (Parsers.Parser)p);
    }

    public CompiledExpression<T> compile(String expr) {
        CompiledExpression compiledExpression;
        CompiledDPath compiledDPath;
        WholeExpression tree = this.getExpressionTree(expr);
        try {
            compiledDPath = tree.compiledDPath();
        }
        catch (PathExpressionNoContextError e) {
            this.host.SDW(WarnID$ExpressionCompilationSkipped$.MODULE$, "Expression compilation skipped due to path expression in unreferenced element, group, or complex type: " + expr, (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            compiledDPath = new CompiledDPath((Seq<RecipeOp>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RecipeOp[]{RuntimeAbortOp$.MODULE$.apply(expr)}));
        }
        CompiledDPath recipe = compiledDPath;
        Object value = recipe.runExpressionForConstant(this.context.schemaFileLocation(), this.context, this.host.tunable());
        Option<Object> option = DataValue$.MODULE$.getOptionAnyRef$extension(value);
        if (option instanceof Some) {
            Object constantValue = ((Some)option).value();
            if (constantValue == null) {
                throw Assert$.MODULE$.abort("Invariant broken: constantValue.!=(null)");
            }
            ConstantExpression<Object> res = new ConstantExpression<Object>(this.qn, this.nodeInfoKind, constantValue);
            compiledExpression = res;
        } else if (None$.MODULE$.equals(option)) {
            Set<DPathElementCompileInfo> contentReferencedElementInfos = tree.contentReferencedElementInfos();
            Set<DPathElementCompileInfo> valueReferencedElementInfos = tree.valueReferencedElementInfos();
            compiledExpression = new RuntimeExpressionDPath(this.qn, this.nodeInfoKind, recipe, expr, this.context, this.isEvaluatedAbove, contentReferencedElementInfos, valueReferencedElementInfos);
        } else {
            throw new MatchError(option);
        }
        CompiledExpression res = compiledExpression;
        return res;
    }

    public boolean skipWhitespace() {
        return this.skipWhitespace;
    }

    public <T> Parsers.Parser<T> Parser(Function1<Reader<Object>, Parsers.ParseResult<T>> f) {
        return new Parsers.Parser<T>(f, this){
            private final Function1 f$1;
            private final /* synthetic */ DFDLPathExpressionParser $outer;
            {
                this.f$1 = f$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super((Parsers)$outer);
            }

            public Parsers.ParseResult apply(Reader in) {
                return (Parsers.ParseResult)this.f$1.apply((Object)in);
            }

            public Parsers.Parser WS() {
                return this.$outer.regex(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s")));
            }

            public Parsers.Parser OptRepWhiteSpace() {
                return this.WS().$times();
            }

            public Parsers.Parser $tilde(Function0 q) {
                LazyRef lazyRef = new LazyRef();
                return this.flatMap((Function1 & Serializable)a -> this.OptRepWhiteSpace().flatMap((Function1 & Serializable)x -> DFDLPathExpressionParser.org$apache$daffodil$core$dpath$DFDLPathExpressionParser$$anon$1$$_$p$3(lazyRef, q).map((Function1 & Serializable)b -> new Parsers$.tilde((Parsers)this.$outer, a, b)))).named("~");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$tilde$$anonfun$1(scala.runtime.LazyRef scala.Function0 java.lang.Object ), $tilde$$anonfun$1$$anonfun$1$$anonfun$1(java.lang.Object java.lang.Object ), $tilde$$anonfun$1$$anonfun$1(java.lang.Object scala.runtime.LazyRef scala.Function0 java.lang.Object )}, serializedLambda);
            }
        };
    }

    public boolean verboseParse() {
        return this.verboseParse;
    }

    public <T> Parsers.Parser<T> log(Function0<Parsers.Parser<T>> p, String name) {
        if (!this.verboseParse()) {
            return (Parsers.Parser)p.apply();
        }
        return this.Parser((Function1 & Serializable)in -> {
            Parsers.ParseResult r;
            block1: {
                Logger LoggerImpl_this = Logger$.MODULE$.log();
                if (LoggerImpl_this.underlying().isTraceEnabled()) {
                    LoggerImpl_this.underlying().trace("trying {} at {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{name, in}), Object.class));
                }
                r = ((Parsers.Parser)p.apply()).apply(in);
                Logger LoggerImpl_this2 = Logger$.MODULE$.log();
                if (!LoggerImpl_this2.underlying().isTraceEnabled()) break block1;
                LoggerImpl_this2.underlying().trace("end {} --> {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{name, in}), Object.class));
            }
            return r;
        });
    }

    public WholeExpression getExpressionTree(String expr) {
        Some some;
        Parsers.NoSuccess realResult;
        Parsers.NoSuccess noSuccess;
        Parsers.ParseResult pResult = this.parse(this.phrase(this.wrapAsSuccess(this::$anonfun$1).$tilde(this::$anonfun$2)), expr);
        Parsers.ParseResult parseResult = pResult;
        if (parseResult instanceof Parsers.Success && ((Parsers.Success)parseResult).scala$util$parsing$combinator$Parsers$Success$$$outer() == this) {
            Parsers.Success success = this.Success().unapply((Parsers.Success)parseResult);
            Parsers$.tilde tilde2 = (Parsers$.tilde)success._1();
            Reader reader = success._2();
            Parsers$.tilde res = tilde2;
            Parsers$.tilde tilde3 = res;
            if (tilde3 == null) {
                throw new MatchError((Object)tilde3);
            }
            Parsers$.tilde tilde4 = this.$tilde().unapply(tilde3);
            Parsers.ParseResult wrappedResult = (Parsers.ParseResult)tilde4._1();
            Parsers.ParseResult wrappedResult2 = wrappedResult;
            noSuccess = wrappedResult2;
        } else if (parseResult instanceof Parsers.NoSuccess && ((Parsers.NoSuccess)parseResult).scala$util$parsing$combinator$Parsers$NoSuccess$$$outer() == this) {
            Parsers.NoSuccess ns;
            noSuccess = ns = (Parsers.NoSuccess)parseResult;
        } else {
            throw new MatchError((Object)parseResult);
        }
        Parsers.NoSuccess noSuccess2 = realResult = noSuccess;
        if (noSuccess2 instanceof Parsers.Success && ((Parsers.Success)noSuccess2).scala$util$parsing$combinator$Parsers$Success$$$outer() == this) {
            Parsers.Success success = this.Success().unapply((Parsers.Success)noSuccess2);
            WholeExpression wholeExpression = (WholeExpression)success._1();
            Reader reader = success._2();
            WholeExpression expressionAST = wholeExpression;
            Reader next = reader;
            expressionAST.init();
            return expressionAST;
        }
        if (noSuccess2 instanceof Parsers.NoSuccess && noSuccess2.scala$util$parsing$combinator$Parsers$NoSuccess$$$outer() == this && !(some = this.NoSuccess().I().unapply(noSuccess2)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)some.get();
            String msg = (String)tuple2._1();
            Reader next = (Reader)tuple2._2();
            String nextString = this.convertNextToString((Reader<Object>)next);
            throw this.context.SDE("Unable to parse expression. Message: %s\nNext: %s.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{msg, nextString}));
        }
        throw new MatchError((Object)noSuccess2);
    }

    public String convertNextToString(Reader<Object> next) {
        Reader nextRdr = next;
        StringBuilder nextString = new StringBuilder();
        for (int i = 0; !nextRdr.atEnd() && i < 30; ++i) {
            nextString.append(BoxesRunTime.unboxToChar((Object)nextRdr.first()));
            nextRdr = nextRdr.rest();
        }
        return nextString.toString();
    }

    public <T> Parsers.Parser<Parsers.ParseResult<T>> wrapAsSuccess(Function0<Parsers.Parser<T>> p) {
        return this.Parser((Function1 & Serializable)in -> {
            Parsers.ParseResult parseResult = ((Parsers.Parser)p.apply()).apply(in);
            if (parseResult instanceof Parsers.NoSuccess && ((Parsers.NoSuccess)parseResult).scala$util$parsing$combinator$Parsers$NoSuccess$$$outer() == this) {
                Parsers.NoSuccess ns = (Parsers.NoSuccess)parseResult;
                return this.Success().apply((Object)ns, in);
            }
            Parsers.ParseResult s = parseResult;
            return this.Success().apply((Object)s, in);
        });
    }

    public String ContextItemExpr() {
        return ".";
    }

    public String AbbrevReverseStep() {
        return "..";
    }

    public Parsers.Parser<String> SupportedForwardAxis() {
        return this.literal("child").$less$tilde(this::SupportedForwardAxis$$anonfun$1).$bar(this::SupportedForwardAxis$$anonfun$2);
    }

    public Parsers.Parser<String> UnsupportedForwardAxis() {
        return this.literal("descendant").$less$tilde(this::UnsupportedForwardAxis$$anonfun$1).$bar(this::UnsupportedForwardAxis$$anonfun$2).$bar(this::UnsupportedForwardAxis$$anonfun$3).$bar(this::UnsupportedForwardAxis$$anonfun$4).$bar(this::UnsupportedForwardAxis$$anonfun$5).$bar(this::UnsupportedForwardAxis$$anonfun$6);
    }

    public Parsers.Parser<String> SupportedReverseAxis() {
        return this.literal("parent").$less$tilde(this::SupportedReverseAxis$$anonfun$1);
    }

    public Parsers.Parser<String> UnsupportedReverseAxis() {
        return this.literal("ancestor").$less$tilde(this::UnsupportedReverseAxis$$anonfun$1).$bar(this::UnsupportedReverseAxis$$anonfun$2).$bar(this::UnsupportedReverseAxis$$anonfun$3).$bar(this::UnsupportedReverseAxis$$anonfun$4);
    }

    public Parsers.Parser<String> EqualityComp() {
        return this.literal("eq").$bar(this::EqualityComp$$anonfun$1).$bar(this::EqualityComp$$anonfun$2).$bar(this::EqualityComp$$anonfun$3);
    }

    public Parsers.Parser<String> NumberComp() {
        return this.literal("lt").$bar(this::NumberComp$$anonfun$1).$bar(this::NumberComp$$anonfun$2).$bar(this::NumberComp$$anonfun$3).$bar(this::NumberComp$$anonfun$4).$bar(this::NumberComp$$anonfun$5).$bar(this::NumberComp$$anonfun$6).$bar(this::NumberComp$$anonfun$7);
    }

    public Parsers.Parser<String> Comp() {
        return this.EqualityComp().$bar(this::Comp$$anonfun$1);
    }

    public Parsers.Parser<WholeExpression> TopLevel() {
        return this.literal("{").$tilde$greater(this::TopLevel$$anonfun$1).$less$tilde(this::TopLevel$$anonfun$2).$up$up((Function1 & Serializable)xpr -> WholeExpression$.MODULE$.apply(this.nodeInfoKind, (Expression)xpr, this.namespaces, this.noPrefixNamespace, this.context, this.host));
    }

    public Parsers.Parser<Reader<Object>> SuccessAtEnd() {
        return this.SuccessAtEnd;
    }

    public Parsers.Parser<Expression> Expr() {
        return this.ExprSingle();
    }

    public Parsers.Parser<Expression> ExprSingle() {
        return this.IfExpr().$bar(this::ExprSingle$$anonfun$1);
    }

    public Parsers.Parser<Expression> IfExpr() {
        return this.log(this::IfExpr$$anonfun$1, "if");
    }

    public Parsers.Parser<Expression> OrExpr() {
        return this.log(this::OrExpr$$anonfun$1, "or");
    }

    public Parsers.Parser<Expression> AndExpr() {
        return this.log(this::AndExpr$$anonfun$1, "and");
    }

    public Parsers.Parser<Expression> ComparisonExpr() {
        return this.log(this::ComparisonExpr$$anonfun$1, "compare");
    }

    public Parsers.Parser<Expression> AdditiveExpr() {
        return this.log(this::AdditiveExpr$$anonfun$1, "add");
    }

    public Parsers.Parser<Expression> MultiplicativeExpr() {
        return this.log(this::MultiplicativeExpr$$anonfun$1, "mult");
    }

    public Parsers.Parser<Expression> UnaryExpr() {
        return this.log(this::UnaryExpr$$anonfun$1, "unary");
    }

    public Parsers.Parser<Expression> ValueExpr() {
        return this.log(this::ValueExpr$$anonfun$1, "value");
    }

    public Parsers.Parser<PathExpression> PathExpr() {
        return this.log(this::PathExpr$$anonfun$1, "path");
    }

    public Parsers.Parser<RelativePathExpression> RelativePathExpr() {
        return this.log(this::RelativePathExpr$$anonfun$1, "relativePath");
    }

    public Parsers.Parser<StepExpression> StepExpr() {
        return this.log(this::StepExpr$$anonfun$1, "step");
    }

    public Parsers.Parser<StepExpression> AxisStep() {
        return this.Reverse().$bar(this::AxisStep$$anonfun$1);
    }

    public Parsers.Parser<UpStepExpression> Reverse() {
        return this.literal(this.AbbrevReverseStep()).$tilde$greater(this::Reverse$$anonfun$1).$up$up((Function1 & Serializable)_$17 -> Up$.MODULE$.apply((Option<PredicateExpression>)_$17)).$bar(this::Reverse$$anonfun$3).$bar(this::Reverse$$anonfun$4);
    }

    public Parsers.Parser<DownStepExpression> Forward() {
        return this.literal(this.ContextItemExpr()).$tilde$greater(this::Forward$$anonfun$1).$up$up((Function1 & Serializable)_$18 -> Self$.MODULE$.apply((Option<PredicateExpression>)_$18)).$bar(this::Forward$$anonfun$3).$bar(this::Forward$$anonfun$4).$bar(this::Forward$$anonfun$5);
    }

    public Parsers.Parser<PredicateExpression> Predicate() {
        return this.log(this::Predicate$$anonfun$1, "predicate");
    }

    public Parsers.Parser<PrimaryExpression> PrimaryExpr() {
        return this.log(this::PrimaryExpr$$anonfun$1, "primary");
    }

    public Parsers.Parser<LiteralExpression> Literal() {
        return this.log(this::Literal$$anonfun$1, "literal");
    }

    public Parsers.Parser<Number> NumericLiteral() {
        return this.DoubleLiteral().$bar(this::NumericLiteral$$anonfun$1).$bar(this::NumericLiteral$$anonfun$2);
    }

    public Parsers.Parser<VariableRef> VarRef() {
        return this.literal("$").$tilde$greater(this::VarRef$$anonfun$1).$up$up((Function1 & Serializable)_$21 -> VariableRef$.MODULE$.apply((String)_$21));
    }

    public Parsers.Parser<ParenthesizedExpression> ParenthesizedExpr() {
        return this.literal("(").$tilde$greater(this::ParenthesizedExpr$$anonfun$1).$less$tilde(this::ParenthesizedExpr$$anonfun$2).$up$up((Function1 & Serializable)_$22 -> ParenthesizedExpression$.MODULE$.apply((Expression)_$22));
    }

    public Parsers.Parser<FunctionCallExpression> FunctionCall() {
        return this.log(this::FunctionCall$$anonfun$1, "functionCall");
    }

    public Parsers.Parser<List<Expression>> ArgList() {
        return this.log(this::ArgList$$anonfun$1, "argList");
    }

    public Parsers.Parser<String> StepName() {
        return this.log(this::StepName$$anonfun$1, "stepName");
    }

    public Parsers.Parser<String> Wildcard() {
        return this.literal("*").$bar(this::Wildcard$$anonfun$1).$bar(this::Wildcard$$anonfun$2);
    }

    public Parsers.Parser<String> NodeTest() {
        return this.KindTest().$bar(this::NodeTest$$anonfun$1);
    }

    public Parsers.Parser<String> NameTest() {
        return this.StepName();
    }

    public Parsers.Parser<Nothing$> KindTest() {
        return this.log(this::KindTest$$anonfun$1, "kindTest");
    }

    public Parsers.Parser<Nothing$> ProcessingInstructionTest() {
        return this.log(this::ProcessingInstructionTest$$anonfun$1, "processingInstructionTest");
    }

    public Parsers.Parser<Nothing$> CommentTest() {
        return this.log(this::CommentTest$$anonfun$1, "commentTest");
    }

    public Parsers.Parser<Nothing$> TextTest() {
        return this.log(this::TextTest$$anonfun$1, "textTest");
    }

    public Parsers.Parser<Nothing$> AnyKindTest() {
        return this.log(this::AnyKindTest$$anonfun$1, "anyKindTest");
    }

    public Parsers.Parser<String> RefName() {
        return this.log(this::RefName$$anonfun$1, "refName");
    }

    public Parsers.Parser<String> QualifiedName() {
        return this.regex(this.PrefixedName()).$bar(this::QualifiedName$$anonfun$1);
    }

    public Regex PrefixedName() {
        return QNameRegex$.MODULE$.QName();
    }

    public Regex UnprefixedName() {
        return QNameRegex$.MODULE$.NCName();
    }

    public Parsers.Parser<BigInteger> IntegerLiteral() {
        return this.regex(this.Digits()).$up$up((Function1 & Serializable)_$28 -> new BigInteger((String)_$28));
    }

    public Regex Digits() {
        return this.Digits;
    }

    public Parsers.Parser<String> optDigits() {
        return this.optDigits;
    }

    public Parsers.Parser<String> Expon() {
        return this.Expon;
    }

    public Parsers.Parser<String> plusMinus() {
        return this.plusMinus;
    }

    public Parsers.Parser<BigDecimal> DecimalLiteral() {
        return this.DecimalLiteral;
    }

    public Parsers.Parser<Double> DoubleLiteral() {
        return this.DoubleLiteral;
    }

    public Parsers.Parser<String> StringLiteral() {
        return this.StringLiteral;
    }

    private final Parsers.Parser $init$$$anonfun$2() {
        return this.regex(this.Digits());
    }

    private final Parsers.Parser $init$$$anonfun$4$$anonfun$1$$anonfun$1() {
        return this.optDigits();
    }

    private final Parsers.Parser $init$$$anonfun$4$$anonfun$1() {
        return this.literal(".").$tilde$greater(this::$init$$$anonfun$4$$anonfun$1$$anonfun$1);
    }

    private final Parsers.Parser $init$$$anonfun$4() {
        return this.regex(this.Digits()).$tilde(this::$init$$$anonfun$4$$anonfun$1).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                String digit = (String)tilde3._1();
                String optDig = (String)tilde3._2();
                return new BigDecimal(digit + "." + optDig);
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser $init$$$anonfun$5() {
        return this.regex(this.Digits());
    }

    private final Parsers.Parser $init$$$anonfun$6() {
        return this.Expon();
    }

    private final Parsers.Parser $init$$$anonfun$8$$anonfun$1$$anonfun$1() {
        return this.optDigits();
    }

    private final Parsers.Parser $init$$$anonfun$8$$anonfun$1() {
        return this.literal(".").$tilde$greater(this::$init$$$anonfun$8$$anonfun$1$$anonfun$1).$qmark();
    }

    private final Parsers.Parser $init$$$anonfun$8$$anonfun$2() {
        return this.Expon();
    }

    private static final String $init$$$anonfun$8$$anonfun$3$$anonfun$1() {
        return "0";
    }

    private final Parsers.Parser $init$$$anonfun$8() {
        return this.regex(this.Digits()).$tilde(this::$init$$$anonfun$8$$anonfun$1).$tilde(this::$init$$$anonfun$8$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2;
            Parsers$.tilde tilde3;
            Parsers$.tilde tilde4 = x$1;
            if (tilde4 != null && (tilde3 = (Parsers$.tilde)(tilde2 = this.$tilde().unapply(tilde4))._1()) != null) {
                Parsers$.tilde tilde5 = this.$tilde().unapply(tilde3);
                String intPart = (String)tilde5._1();
                Option fraction = (Option)tilde5._2();
                String exp = (String)tilde2._2();
                return intPart + "." + fraction.getOrElse(DFDLPathExpressionParser::$init$$$anonfun$8$$anonfun$3$$anonfun$1) + exp;
            }
            throw new MatchError((Object)tilde4);
        });
    }

    private static final String quotedBody$1(String esc, String not) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("(%s|%s)*"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{esc, not}));
    }

    private static final Parsers.Parser p$lzyINIT1$1(LazyRef p$lzy1$1, Function0 q$1) {
        Parsers.Parser parser;
        LazyRef lazyRef = p$lzy1$1;
        synchronized (lazyRef) {
            parser = (Parsers.Parser)(p$lzy1$1.initialized() ? p$lzy1$1.value() : p$lzy1$1.initialize((Object)((Parsers.Parser)q$1.apply())));
        }
        return parser;
    }

    public static final Parsers.Parser org$apache$daffodil$core$dpath$DFDLPathExpressionParser$$anon$1$$_$p$3(LazyRef p$lzy1$2, Function0 q$2) {
        return (Parsers.Parser)(p$lzy1$2.initialized() ? p$lzy1$2.value() : DFDLPathExpressionParser.p$lzyINIT1$1(p$lzy1$2, q$2));
    }

    private final Parsers.Parser $anonfun$1() {
        return this.TopLevel();
    }

    private final Parsers.Parser $anonfun$2() {
        return this.SuccessAtEnd();
    }

    private final Parsers.Parser SupportedForwardAxis$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser SupportedForwardAxis$$anonfun$2$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser SupportedForwardAxis$$anonfun$2() {
        return this.literal("self").$less$tilde(this::SupportedForwardAxis$$anonfun$2$$anonfun$1);
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$2$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$2() {
        return this.literal("attribute").$less$tilde(this::UnsupportedForwardAxis$$anonfun$2$$anonfun$1);
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$3$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$3() {
        return this.literal("descendant-or-self").$less$tilde(this::UnsupportedForwardAxis$$anonfun$3$$anonfun$1);
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$4$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$4() {
        return this.literal("following-sibling").$less$tilde(this::UnsupportedForwardAxis$$anonfun$4$$anonfun$1);
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$5$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$5() {
        return this.literal("following").$less$tilde(this::UnsupportedForwardAxis$$anonfun$5$$anonfun$1);
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$6$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedForwardAxis$$anonfun$6() {
        return this.literal("namespace").$less$tilde(this::UnsupportedForwardAxis$$anonfun$6$$anonfun$1);
    }

    private final Parsers.Parser SupportedReverseAxis$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedReverseAxis$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedReverseAxis$$anonfun$2$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedReverseAxis$$anonfun$2() {
        return this.literal("preceding-sibling").$less$tilde(this::UnsupportedReverseAxis$$anonfun$2$$anonfun$1);
    }

    private final Parsers.Parser UnsupportedReverseAxis$$anonfun$3$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedReverseAxis$$anonfun$3() {
        return this.literal("preceding").$less$tilde(this::UnsupportedReverseAxis$$anonfun$3$$anonfun$1);
    }

    private final Parsers.Parser UnsupportedReverseAxis$$anonfun$4$$anonfun$1() {
        return this.literal("::");
    }

    private final Parsers.Parser UnsupportedReverseAxis$$anonfun$4() {
        return this.literal("ancestor-or-self").$less$tilde(this::UnsupportedReverseAxis$$anonfun$4$$anonfun$1);
    }

    private final Parsers.Parser EqualityComp$$anonfun$1() {
        return this.literal("ne");
    }

    private final Parsers.Parser EqualityComp$$anonfun$2() {
        return this.literal("!=");
    }

    private final Parsers.Parser EqualityComp$$anonfun$3() {
        return this.literal("=");
    }

    private final Parsers.Parser NumberComp$$anonfun$1() {
        return this.literal("le");
    }

    private final Parsers.Parser NumberComp$$anonfun$2() {
        return this.literal("gt");
    }

    private final Parsers.Parser NumberComp$$anonfun$3() {
        return this.literal("ge");
    }

    private final Parsers.Parser NumberComp$$anonfun$4() {
        return this.literal("<=");
    }

    private final Parsers.Parser NumberComp$$anonfun$5() {
        return this.literal(">=");
    }

    private final Parsers.Parser NumberComp$$anonfun$6() {
        return this.literal("<");
    }

    private final Parsers.Parser NumberComp$$anonfun$7() {
        return this.literal(">");
    }

    private final Parsers.Parser Comp$$anonfun$1() {
        return this.NumberComp();
    }

    private final Parsers.Parser TopLevel$$anonfun$1() {
        return this.Expr();
    }

    private final Parsers.Parser TopLevel$$anonfun$2() {
        return this.literal("}");
    }

    private final Parsers.Parser ExprSingle$$anonfun$1() {
        return this.OrExpr();
    }

    private final Parsers.Parser IfExpr$$anonfun$1$$anonfun$1() {
        return this.literal("(");
    }

    private final Parsers.Parser IfExpr$$anonfun$1$$anonfun$2$$anonfun$1() {
        return this.literal(")");
    }

    private final Parsers.Parser IfExpr$$anonfun$1$$anonfun$2() {
        return this.Expr().$less$tilde(this::IfExpr$$anonfun$1$$anonfun$2$$anonfun$1);
    }

    private final Parsers.Parser IfExpr$$anonfun$1$$anonfun$3$$anonfun$1() {
        return this.ExprSingle();
    }

    private final Parsers.Parser IfExpr$$anonfun$1$$anonfun$3() {
        return this.literal("then").$tilde$greater(this::IfExpr$$anonfun$1$$anonfun$3$$anonfun$1);
    }

    private final Parsers.Parser IfExpr$$anonfun$1$$anonfun$4$$anonfun$1() {
        return this.ExprSingle();
    }

    private final Parsers.Parser IfExpr$$anonfun$1$$anonfun$4() {
        return this.literal("else").$tilde$greater(this::IfExpr$$anonfun$1$$anonfun$4$$anonfun$1);
    }

    private final Parsers.Parser IfExpr$$anonfun$1() {
        return this.literal("if").$tilde$greater(this::IfExpr$$anonfun$1$$anonfun$1).$tilde$greater(this::IfExpr$$anonfun$1$$anonfun$2).$tilde(this::IfExpr$$anonfun$1$$anonfun$3).$tilde(this::IfExpr$$anonfun$1$$anonfun$4).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2;
            Parsers$.tilde tilde3;
            Parsers$.tilde tilde4 = x$1;
            if (tilde4 != null && (tilde3 = (Parsers$.tilde)(tilde2 = this.$tilde().unapply(tilde4))._1()) != null) {
                Parsers$.tilde tilde5 = this.$tilde().unapply(tilde3);
                Expression tst = (Expression)tilde5._1();
                Expression th = (Expression)tilde5._2();
                Expression els = (Expression)tilde2._2();
                return IfExpression$.MODULE$.apply((List<Expression>)((List)new .colon.colon((Object)tst, (List)new .colon.colon((Object)th, (List)new .colon.colon((Object)els, (List)Nil$.MODULE$)))));
            }
            throw new MatchError((Object)tilde4);
        });
    }

    private final Parsers.Parser OrExpr$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.AndExpr();
    }

    private final Parsers.Parser OrExpr$$anonfun$1$$anonfun$1() {
        return this.literal("or").$tilde$greater(this::OrExpr$$anonfun$1$$anonfun$1$$anonfun$1).$times();
    }

    private final Parsers.Parser OrExpr$$anonfun$1() {
        return this.AndExpr().$tilde(this::OrExpr$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)x$12 -> {
            Parsers$.tilde tilde2 = x$12;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                Expression a1 = (Expression)tilde3._1();
                Nil$ nil$ = package$.MODULE$.Nil();
                Object object = tilde3._2();
                if (!(nil$ != null ? !nil$.equals(object) : object != null)) {
                    return a1;
                }
                Parsers$.tilde tilde4 = this.$tilde().unapply(tilde2);
                Expression a12 = (Expression)tilde4._1();
                List aMore = (List)tilde4._2();
                return (Expression)aMore.foldLeft((Object)a12, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Expression a = (Expression)tuple2._1();
                        Expression b = (Expression)tuple2._2();
                        return OrExpression$.MODULE$.apply((List<Expression>)((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser AndExpr$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.ComparisonExpr();
    }

    private final Parsers.Parser AndExpr$$anonfun$1$$anonfun$1() {
        return this.literal("and").$tilde$greater(this::AndExpr$$anonfun$1$$anonfun$1$$anonfun$1).$times();
    }

    private final Parsers.Parser AndExpr$$anonfun$1() {
        return this.ComparisonExpr().$tilde(this::AndExpr$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)x$12 -> {
            Parsers$.tilde tilde2 = x$12;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                Expression a1 = (Expression)tilde3._1();
                Nil$ nil$ = package$.MODULE$.Nil();
                Object object = tilde3._2();
                if (!(nil$ != null ? !nil$.equals(object) : object != null)) {
                    return a1;
                }
                Parsers$.tilde tilde4 = this.$tilde().unapply(tilde2);
                Expression a12 = (Expression)tilde4._1();
                List aMore = (List)tilde4._2();
                return (Expression)aMore.foldLeft((Object)a12, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Expression a = (Expression)tuple2._1();
                        Expression b = (Expression)tuple2._2();
                        return AndExpression$.MODULE$.apply((List<Expression>)((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))));
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser ComparisonExpr$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.AdditiveExpr();
    }

    private final Parsers.Parser ComparisonExpr$$anonfun$1$$anonfun$1() {
        return this.Comp().$tilde(this::ComparisonExpr$$anonfun$1$$anonfun$1$$anonfun$1).$qmark();
    }

    private final Parsers.Parser ComparisonExpr$$anonfun$1() {
        return this.AdditiveExpr().$tilde(this::ComparisonExpr$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)x -> {
            Parsers$.tilde tilde2 = x;
            if (tilde2 != null) {
                Parsers$.tilde tilde3;
                Parsers$.tilde tilde4 = this.$tilde().unapply(tilde2);
                Option option = (Option)tilde4._2();
                Expression a1 = (Expression)tilde4._1();
                if (option instanceof Some && (tilde3 = (Parsers$.tilde)((Some)option).value()) != null) {
                    Parsers$.tilde tilde5 = this.$tilde().unapply(tilde3);
                    String vc = (String)tilde5._1();
                    Expression a2 = (Expression)tilde5._2();
                    return ComparisonExpression$.MODULE$.apply(vc, (List<Expression>)((List)new .colon.colon((Object)a1, (List)new .colon.colon((Object)a2, (List)Nil$.MODULE$))));
                }
                Parsers$.tilde tilde6 = this.$tilde().unapply(tilde2);
                Expression a12 = (Expression)tilde6._1();
                if (None$.MODULE$.equals(tilde6._2())) {
                    return a12;
                }
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser AdditiveExpr$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.literal("-");
    }

    private final Parsers.Parser AdditiveExpr$$anonfun$1$$anonfun$1$$anonfun$2() {
        return this.MultiplicativeExpr();
    }

    private final Parsers.Parser AdditiveExpr$$anonfun$1$$anonfun$1() {
        return this.literal("+").$bar(this::AdditiveExpr$$anonfun$1$$anonfun$1$$anonfun$1).$tilde(this::AdditiveExpr$$anonfun$1$$anonfun$1$$anonfun$2).$times();
    }

    private final Parsers.Parser AdditiveExpr$$anonfun$1() {
        return this.MultiplicativeExpr().$tilde(this::AdditiveExpr$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)x$12 -> {
            Parsers$.tilde tilde2 = x$12;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                Expression m1 = (Expression)tilde3._1();
                List mMore = (List)tilde3._2();
                return (Expression)mMore.foldLeft((Object)m1, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Parsers$.tilde tilde2 = (Parsers$.tilde)tuple2._2();
                        Expression a = (Expression)tuple2._1();
                        if (tilde2 != null) {
                            Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                            String op = (String)tilde3._1();
                            Expression b = (Expression)tilde3._2();
                            return AdditiveExpression$.MODULE$.apply(op, (List<Expression>)((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))));
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.literal("div");
    }

    private final Parsers.Parser MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$2() {
        return this.literal("idiv");
    }

    private final Parsers.Parser MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$3() {
        return this.literal("mod");
    }

    private final Parsers.Parser MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$4() {
        return this.UnaryExpr();
    }

    private final Parsers.Parser MultiplicativeExpr$$anonfun$1$$anonfun$1() {
        return this.literal("*").$bar(this::MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$1).$bar(this::MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$2).$bar(this::MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$3).$tilde(this::MultiplicativeExpr$$anonfun$1$$anonfun$1$$anonfun$4).$times();
    }

    private final Parsers.Parser MultiplicativeExpr$$anonfun$1() {
        return this.UnaryExpr().$tilde(this::MultiplicativeExpr$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)x$12 -> {
            Parsers$.tilde tilde2 = x$12;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                Expression u1 = (Expression)tilde3._1();
                List uMore = (List)tilde3._2();
                return (Expression)uMore.foldLeft((Object)u1, (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Parsers$.tilde tilde2 = (Parsers$.tilde)tuple2._2();
                        Expression a = (Expression)tuple2._1();
                        if (tilde2 != null) {
                            Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                            String op = (String)tilde3._1();
                            Expression b = (Expression)tilde3._2();
                            return MultiplicativeExpression$.MODULE$.apply(op, (List<Expression>)((List)new .colon.colon((Object)a, (List)new .colon.colon((Object)b, (List)Nil$.MODULE$))));
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser UnaryExpr$$anonfun$1$$anonfun$1() {
        return this.literal("+");
    }

    private final Parsers.Parser UnaryExpr$$anonfun$1$$anonfun$2() {
        return this.ValueExpr();
    }

    private final Parsers.Parser UnaryExpr$$anonfun$1() {
        return this.literal("-").$bar(this::UnaryExpr$$anonfun$1$$anonfun$1).$qmark().$tilde(this::UnaryExpr$$anonfun$1$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                Option option = (Option)tilde3._1();
                if (option instanceof Some) {
                    String op = (String)((Some)option).value();
                    Expression v = (Expression)tilde3._2();
                    return UnaryExpression$.MODULE$.apply(op, v);
                }
                Parsers$.tilde tilde4 = this.$tilde().unapply(tilde2);
                if (None$.MODULE$.equals(tilde4._1())) {
                    Expression v = (Expression)tilde4._2();
                    return v;
                }
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser ValueExpr$$anonfun$1$$anonfun$1() {
        return this.PathExpr();
    }

    private final Parsers.Parser ValueExpr$$anonfun$1() {
        return this.PrimaryExpr().$bar(this::ValueExpr$$anonfun$1$$anonfun$1);
    }

    private final Parsers.Parser PathExpr$$anonfun$1$$anonfun$1() {
        return this.RelativePathExpr();
    }

    private final Parsers.Parser PathExpr$$anonfun$1$$anonfun$3$$anonfun$1() {
        return this.RelativePathExpr();
    }

    private final Parsers.Parser PathExpr$$anonfun$1$$anonfun$3() {
        return this.literal("/").$tilde$greater(this::PathExpr$$anonfun$1$$anonfun$3$$anonfun$1).$up$up((Function1 & Serializable)r -> RootPathExpression$.MODULE$.apply((Option<RelativePathExpression>)Some$.MODULE$.apply(r)));
    }

    private final Parsers.Parser PathExpr$$anonfun$1$$anonfun$4() {
        return this.literal("/").$up$up((Function1 & Serializable)r -> RootPathExpression$.MODULE$.apply((Option<RelativePathExpression>)None$.MODULE$));
    }

    private final Parsers.Parser PathExpr$$anonfun$1$$anonfun$5() {
        return this.RelativePathExpr();
    }

    private final Parsers.Parser PathExpr$$anonfun$1() {
        return this.literal("//").$tilde$greater(this::PathExpr$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)_$15 -> this.context.SDE("'//' is unsupported in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]))).$bar(this::PathExpr$$anonfun$1$$anonfun$3).$bar(this::PathExpr$$anonfun$1$$anonfun$4).$bar(this::PathExpr$$anonfun$1$$anonfun$5);
    }

    private final Parsers.Parser RelativePathExpr$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.StepExpr();
    }

    private final Parsers.Parser RelativePathExpr$$anonfun$1$$anonfun$1() {
        return this.literal("/").$tilde$greater(this::RelativePathExpr$$anonfun$1$$anonfun$1$$anonfun$1).$times();
    }

    private final Parsers.Parser RelativePathExpr$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1() {
        return this.StepExpr();
    }

    private final Parsers.Parser RelativePathExpr$$anonfun$1$$anonfun$3$$anonfun$1() {
        return this.literal("//").$tilde$greater(this::RelativePathExpr$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1).$times();
    }

    private final Parsers.Parser RelativePathExpr$$anonfun$1$$anonfun$3() {
        return this.StepExpr().$tilde(this::RelativePathExpr$$anonfun$1$$anonfun$3$$anonfun$1).$up$up((Function1 & Serializable)_$16 -> this.context.SDE("'//' is unsupported in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    private final Parsers.Parser RelativePathExpr$$anonfun$1() {
        return this.StepExpr().$tilde(this::RelativePathExpr$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                StepExpression s1 = (StepExpression)tilde3._1();
                List moreSteps = (List)tilde3._2();
                return RelativePathExpression$.MODULE$.apply((List<StepExpression>)moreSteps.$colon$colon((Object)s1), this.isEvaluatedAbove);
            }
            throw new MatchError((Object)tilde2);
        }).$bar(this::RelativePathExpr$$anonfun$1$$anonfun$3);
    }

    private final Parsers.Parser StepExpr$$anonfun$1$$anonfun$1() {
        return this.VarRef().$up$up((Function1 & Serializable)varRef -> this.context.SDE("Variables cannot be used in path expressions.  Error: $%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{varRef.qnameString()})));
    }

    private final Parsers.Parser StepExpr$$anonfun$1() {
        return this.AxisStep().$bar(this::StepExpr$$anonfun$1$$anonfun$1);
    }

    private final Parsers.Parser AxisStep$$anonfun$1() {
        return this.Forward();
    }

    private final Parsers.Parser Reverse$$anonfun$1() {
        return this.Predicate().$qmark();
    }

    private final Parsers.Parser Reverse$$anonfun$3$$anonfun$1() {
        return this.NodeTest();
    }

    private final Parsers.Parser Reverse$$anonfun$3$$anonfun$2() {
        return this.Predicate().$qmark();
    }

    private final Parsers.Parser Reverse$$anonfun$3() {
        return this.SupportedReverseAxis().$tilde$greater(this::Reverse$$anonfun$3$$anonfun$1).$tilde(this::Reverse$$anonfun$3$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                String qn = (String)tilde3._1();
                Option p = (Option)tilde3._2();
                return Up2$.MODULE$.apply(qn, (Option<PredicateExpression>)p);
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser Reverse$$anonfun$4$$anonfun$1() {
        return this.NodeTest();
    }

    private final Parsers.Parser Reverse$$anonfun$4$$anonfun$2() {
        return this.Predicate().$qmark();
    }

    private final Parsers.Parser Reverse$$anonfun$4() {
        return this.UnsupportedReverseAxis().$tilde(this::Reverse$$anonfun$4$$anonfun$1).$tilde(this::Reverse$$anonfun$4$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                Parsers$.tilde name = (Parsers$.tilde)tilde3._1();
                return this.context.SDE("'%s::' is an unsupported axis in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name}));
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser Forward$$anonfun$1() {
        return this.Predicate().$qmark();
    }

    private final Parsers.Parser Forward$$anonfun$3$$anonfun$1() {
        return this.NodeTest();
    }

    private final Parsers.Parser Forward$$anonfun$3$$anonfun$2() {
        return this.Predicate().$qmark();
    }

    private final Parsers.Parser Forward$$anonfun$3() {
        return this.SupportedForwardAxis().$tilde(this::Forward$$anonfun$3$$anonfun$1).$tilde(this::Forward$$anonfun$3$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            DownStepExpression downStepExpression;
            Parsers$.tilde tilde2;
            Parsers$.tilde tilde3 = x$1;
            if (tilde3 == null) throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
            Parsers$.tilde tilde4 = this.$tilde().unapply(tilde3);
            Parsers$.tilde tilde5 = (Parsers$.tilde)tilde4._1();
            if (tilde5 != null && "self".equals((tilde2 = this.$tilde().unapply(tilde5))._1())) {
                String qn = (String)tilde2._2();
                Option p = (Option)tilde4._2();
                downStepExpression = Self2$.MODULE$.apply(qn, (Option<PredicateExpression>)p);
                return downStepExpression;
            } else {
                Parsers$.tilde tilde6;
                Parsers$.tilde tilde7 = this.$tilde().unapply(tilde3);
                Parsers$.tilde tilde8 = (Parsers$.tilde)tilde7._1();
                if (tilde8 == null || !"child".equals((tilde6 = this.$tilde().unapply(tilde8))._1())) throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                String qn = (String)tilde6._2();
                Option p = (Option)tilde7._2();
                downStepExpression = NamedStep$.MODULE$.apply(qn, (Option<PredicateExpression>)p);
            }
            return downStepExpression;
        });
    }

    private final Parsers.Parser Forward$$anonfun$4$$anonfun$1() {
        return this.Predicate().$qmark();
    }

    private final Parsers.Parser Forward$$anonfun$4() {
        return this.UnsupportedForwardAxis().$tilde(this::Forward$$anonfun$4$$anonfun$1).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                String name = (String)tilde3._1();
                return this.context.SDE("'%s::' is an unsupported axis in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name}));
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser Forward$$anonfun$5$$anonfun$1() {
        return this.Predicate().$qmark();
    }

    private final Parsers.Parser Forward$$anonfun$5() {
        return this.NodeTest().$tilde(this::Forward$$anonfun$5$$anonfun$1).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                String qn = (String)tilde3._1();
                Option p = (Option)tilde3._2();
                return NamedStep$.MODULE$.apply(qn, (Option<PredicateExpression>)p);
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser Predicate$$anonfun$1$$anonfun$1() {
        return this.Expr();
    }

    private final Parsers.Parser Predicate$$anonfun$1$$anonfun$2() {
        return this.literal("]");
    }

    private final Parsers.Parser Predicate$$anonfun$1() {
        return this.literal("[").$tilde$greater(this::Predicate$$anonfun$1$$anonfun$1).$less$tilde(this::Predicate$$anonfun$1$$anonfun$2).$up$up((Function1 & Serializable)_$19 -> PredicateExpression$.MODULE$.apply((Expression)_$19));
    }

    private final Parsers.Parser PrimaryExpr$$anonfun$1$$anonfun$1() {
        return this.Literal();
    }

    private final Parsers.Parser PrimaryExpr$$anonfun$1$$anonfun$2() {
        return this.VarRef();
    }

    private final Parsers.Parser PrimaryExpr$$anonfun$1$$anonfun$3() {
        return this.ParenthesizedExpr();
    }

    private final Parsers.Parser PrimaryExpr$$anonfun$1() {
        return this.FunctionCall().$bar(this::PrimaryExpr$$anonfun$1$$anonfun$1).$bar(this::PrimaryExpr$$anonfun$1$$anonfun$2).$bar(this::PrimaryExpr$$anonfun$1$$anonfun$3);
    }

    private final Parsers.Parser Literal$$anonfun$1$$anonfun$1() {
        return this.NumericLiteral();
    }

    private final Parsers.Parser Literal$$anonfun$1() {
        return this.StringLiteral().$bar(this::Literal$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)_$20 -> LiteralExpression$.MODULE$.apply(_$20));
    }

    private final Parsers.Parser NumericLiteral$$anonfun$1() {
        return this.DecimalLiteral();
    }

    private final Parsers.Parser NumericLiteral$$anonfun$2() {
        return this.IntegerLiteral();
    }

    private final Parsers.Parser VarRef$$anonfun$1() {
        return this.RefName();
    }

    private final Parsers.Parser ParenthesizedExpr$$anonfun$1() {
        return this.Expr();
    }

    private final Parsers.Parser ParenthesizedExpr$$anonfun$2() {
        return this.literal(")");
    }

    private final Parsers.Parser FunctionCall$$anonfun$1$$anonfun$1() {
        return this.ArgList();
    }

    private final Parsers.Parser FunctionCall$$anonfun$1() {
        return this.RefName().$tilde(this::FunctionCall$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                String qn = (String)tilde3._1();
                List arglist = (List)tilde3._2();
                return FunctionCallExpression$.MODULE$.apply(qn, (List<Expression>)arglist);
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser ArgList$$anonfun$1$$anonfun$1() {
        return this.literal(")");
    }

    private final Parsers.Parser ArgList$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1() {
        return this.ExprSingle();
    }

    private final Parsers.Parser ArgList$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1() {
        return this.literal(",").$tilde$greater(this::ArgList$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1$$anonfun$1).$times();
    }

    private final Parsers.Parser ArgList$$anonfun$1$$anonfun$3$$anonfun$1() {
        return this.ExprSingle().$tilde(this::ArgList$$anonfun$1$$anonfun$3$$anonfun$1$$anonfun$1);
    }

    private final Parsers.Parser ArgList$$anonfun$1$$anonfun$3$$anonfun$2() {
        return this.literal(")");
    }

    private final Parsers.Parser ArgList$$anonfun$1$$anonfun$3() {
        return this.literal("(").$tilde$greater(this::ArgList$$anonfun$1$$anonfun$3$$anonfun$1).$less$tilde(this::ArgList$$anonfun$1$$anonfun$3$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2 = x$1;
            if (tilde2 != null) {
                Parsers$.tilde tilde3 = this.$tilde().unapply(tilde2);
                Expression e1 = (Expression)tilde3._1();
                List moreEs = (List)tilde3._2();
                return moreEs.$colon$colon((Object)e1);
            }
            throw new MatchError((Object)tilde2);
        });
    }

    private final Parsers.Parser ArgList$$anonfun$1() {
        return this.literal("(").$tilde(this::ArgList$$anonfun$1$$anonfun$1).$up$up((Function1 & Serializable)_$23 -> package$.MODULE$.Nil()).$bar(this::ArgList$$anonfun$1$$anonfun$3);
    }

    private final Parsers.Parser StepName$$anonfun$1$$anonfun$1() {
        return this.Wildcard().$up$up((Function1 & Serializable)wc -> this.context.SDE("Wildcard is unsupported in DFDL Expression Syntax. Offending value was '%s'.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{wc})));
    }

    private final Parsers.Parser StepName$$anonfun$1() {
        return this.QualifiedName().$bar(this::StepName$$anonfun$1$$anonfun$1);
    }

    private final Parsers.Parser Wildcard$$anonfun$1$$anonfun$1() {
        return this.literal(":");
    }

    private final Parsers.Parser Wildcard$$anonfun$1$$anonfun$2() {
        return this.literal("*");
    }

    private final Parsers.Parser Wildcard$$anonfun$1() {
        return this.regex(QNameRegex$.MODULE$.NCName()).$tilde(this::Wildcard$$anonfun$1$$anonfun$1).$tilde(this::Wildcard$$anonfun$1$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2;
            Parsers$.tilde tilde3;
            Parsers$.tilde tilde4 = x$1;
            if (tilde4 != null && (tilde3 = (Parsers$.tilde)(tilde2 = this.$tilde().unapply(tilde4))._1()) != null) {
                Parsers$.tilde tilde5 = this.$tilde().unapply(tilde3);
                String ncname = (String)tilde5._1();
                String c = (String)tilde5._2();
                String wc = (String)tilde2._2();
                return ncname + c + wc;
            }
            throw new MatchError((Object)tilde4);
        });
    }

    private final Parsers.Parser Wildcard$$anonfun$2$$anonfun$1() {
        return this.literal(":");
    }

    private final Parsers.Parser Wildcard$$anonfun$2$$anonfun$2() {
        return this.regex(QNameRegex$.MODULE$.NCName());
    }

    private final Parsers.Parser Wildcard$$anonfun$2() {
        return this.literal("*").$tilde(this::Wildcard$$anonfun$2$$anonfun$1).$tilde(this::Wildcard$$anonfun$2$$anonfun$2).$up$up((Function1 & Serializable)x$1 -> {
            Parsers$.tilde tilde2;
            Parsers$.tilde tilde3;
            Parsers$.tilde tilde4 = x$1;
            if (tilde4 != null && (tilde3 = (Parsers$.tilde)(tilde2 = this.$tilde().unapply(tilde4))._1()) != null) {
                Parsers$.tilde tilde5 = this.$tilde().unapply(tilde3);
                String wc = (String)tilde5._1();
                String c = (String)tilde5._2();
                String ncname = (String)tilde2._2();
                return wc + c + ncname;
            }
            throw new MatchError((Object)tilde4);
        });
    }

    private final Parsers.Parser NodeTest$$anonfun$1() {
        return this.NameTest();
    }

    private final Parsers.Parser KindTest$$anonfun$1$$anonfun$1() {
        return this.CommentTest();
    }

    private final Parsers.Parser KindTest$$anonfun$1$$anonfun$2() {
        return this.TextTest();
    }

    private final Parsers.Parser KindTest$$anonfun$1$$anonfun$3() {
        return this.AnyKindTest();
    }

    private final Parsers.Parser KindTest$$anonfun$1() {
        return this.ProcessingInstructionTest().$bar(this::KindTest$$anonfun$1$$anonfun$1).$bar(this::KindTest$$anonfun$1$$anonfun$2).$bar(this::KindTest$$anonfun$1$$anonfun$3);
    }

    private final Parsers.Parser ProcessingInstructionTest$$anonfun$1$$anonfun$1() {
        return this.literal("(");
    }

    private final Parsers.Parser ProcessingInstructionTest$$anonfun$1$$anonfun$2() {
        return this.StringLiteral().$qmark();
    }

    private final Parsers.Parser ProcessingInstructionTest$$anonfun$1$$anonfun$3() {
        return this.literal(")");
    }

    private final Parsers.Parser ProcessingInstructionTest$$anonfun$1() {
        return this.literal("processing-instruction").$tilde(this::ProcessingInstructionTest$$anonfun$1$$anonfun$1).$tilde(this::ProcessingInstructionTest$$anonfun$1$$anonfun$2).$tilde(this::ProcessingInstructionTest$$anonfun$1$$anonfun$3).$up$up((Function1 & Serializable)_$24 -> this.context.SDE("Use of processing-instruction() is unsupported in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    private final Parsers.Parser CommentTest$$anonfun$1$$anonfun$1() {
        return this.literal("(");
    }

    private final Parsers.Parser CommentTest$$anonfun$1$$anonfun$2() {
        return this.literal(")");
    }

    private final Parsers.Parser CommentTest$$anonfun$1() {
        return this.literal("comment").$tilde(this::CommentTest$$anonfun$1$$anonfun$1).$tilde(this::CommentTest$$anonfun$1$$anonfun$2).$up$up((Function1 & Serializable)_$25 -> this.context.SDE("Use of comment() is unsupported in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    private final Parsers.Parser TextTest$$anonfun$1$$anonfun$1() {
        return this.literal("(");
    }

    private final Parsers.Parser TextTest$$anonfun$1$$anonfun$2() {
        return this.literal(")");
    }

    private final Parsers.Parser TextTest$$anonfun$1() {
        return this.literal("text").$tilde(this::TextTest$$anonfun$1$$anonfun$1).$tilde(this::TextTest$$anonfun$1$$anonfun$2).$up$up((Function1 & Serializable)_$26 -> this.context.SDE("Use of text() is unsupported in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    private final Parsers.Parser AnyKindTest$$anonfun$1$$anonfun$1() {
        return this.literal("(");
    }

    private final Parsers.Parser AnyKindTest$$anonfun$1$$anonfun$2() {
        return this.literal(")");
    }

    private final Parsers.Parser AnyKindTest$$anonfun$1() {
        return this.literal("node").$tilde(this::AnyKindTest$$anonfun$1$$anonfun$1).$tilde(this::AnyKindTest$$anonfun$1$$anonfun$2).$up$up((Function1 & Serializable)_$27 -> this.context.SDE("Use of node() is unsupported in DFDL Expression Syntax.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
    }

    private final Parsers.Parser RefName$$anonfun$1() {
        return this.QualifiedName();
    }

    private final Parsers.Parser QualifiedName$$anonfun$1() {
        return this.regex(this.UnprefixedName());
    }
}

