/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import com.google.common.base.Strings;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Attr;

public abstract class RoleDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        RoleDescriptor roleDescriptor = (RoleDescriptor)parentObject;
        if (childObject instanceof Extensions) {
            roleDescriptor.setExtensions((Extensions)childObject);
        } else if (childObject instanceof Signature) {
            roleDescriptor.setSignature((Signature)childObject);
        } else if (childObject instanceof KeyDescriptor) {
            roleDescriptor.getKeyDescriptors().add((KeyDescriptor)childObject);
        } else if (childObject instanceof Organization) {
            roleDescriptor.setOrganization((Organization)childObject);
        } else if (childObject instanceof ContactPerson) {
            roleDescriptor.getContactPersons().add((ContactPerson)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        RoleDescriptor roleDescriptor = (RoleDescriptor)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("ID")) {
                roleDescriptor.setID(attribute.getValue());
                attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            } else if (attribute.getLocalName().equals("validUntil") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                roleDescriptor.setValidUntil(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
            } else if (attribute.getLocalName().equals("cacheDuration")) {
                roleDescriptor.setCacheDuration(DOMTypeSupport.stringToDuration((String)attribute.getValue()));
            } else if (attribute.getLocalName().equals("protocolSupportEnumeration")) {
                StringTokenizer protocolTokenizer = new StringTokenizer(attribute.getValue(), " ");
                while (protocolTokenizer.hasMoreTokens()) {
                    roleDescriptor.addSupportedProtocol(protocolTokenizer.nextToken());
                }
            } else if (attribute.getLocalName().equals("errorURL")) {
                roleDescriptor.setErrorURL(attribute.getValue());
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            this.processUnknownAttribute((AttributeExtensibleXMLObject)roleDescriptor, attribute);
        }
    }
}

