/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.RM10Constants;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.VersionTransformer;
import org.apache.cxf.ws.rm.v200502.AckRequestedType;
import org.apache.cxf.ws.rm.v200502.SequenceFaultType;
import org.apache.cxf.ws.rm.v200502.SequenceType;
import org.apache.cxf.ws.rm.v200502.TerminateSequenceType;
import org.apache.cxf.ws.rm.v200702.CloseSequenceType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceResponseType;
import org.apache.cxf.ws.rm.v200702.CreateSequenceType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class EncoderDecoder10Impl
extends EncoderDecoder {
    public static final EncoderDecoder10Impl INSTANCE = new EncoderDecoder10Impl();
    private static AtomicReference<JAXBContext> jaxbContextReference = new AtomicReference();
    private static final Logger LOG = LogUtils.getL7dLogger(EncoderDecoder10Impl.class);

    private EncoderDecoder10Impl() {
    }

    @Override
    public String getWSRMNamespace() {
        return "http://schemas.xmlsoap.org/ws/2005/02/rm";
    }

    @Override
    public String getWSANamespace() {
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    }

    @Override
    public RMConstants getConstants() {
        return RM10Constants.INSTANCE;
    }

    @Override
    public Class<?> getCreateSequenceType() {
        return org.apache.cxf.ws.rm.v200502.CreateSequenceType.class;
    }

    @Override
    public Class<?> getCreateSequenceResponseType() {
        return org.apache.cxf.ws.rm.v200502.CreateSequenceResponseType.class;
    }

    @Override
    public Class<?> getTerminateSequenceType() {
        return TerminateSequenceType.class;
    }

    @Override
    public Class<?> getTerminateSequenceResponseType() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected JAXBContext getContext() throws JAXBException {
        JAXBContext jaxbContext = jaxbContextReference.get();
        if (jaxbContext != null) return jaxbContext;
        Class<EncoderDecoder10Impl> clazz = EncoderDecoder10Impl.class;
        synchronized (EncoderDecoder10Impl.class) {
            jaxbContext = jaxbContextReference.get();
            if (jaxbContext != null) return jaxbContext;
            Class<?> clas = RMUtils.getWSRM200502Factory().getClass();
            jaxbContext = JAXBContext.newInstance((String)PackageUtils.getPackageName(clas), (ClassLoader)clas.getClassLoader());
            jaxbContextReference.set(jaxbContext);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return jaxbContext;
        }
    }

    @Override
    protected void buildHeaders(SequenceType seq, Collection<SequenceAcknowledgement> acks, Collection<org.apache.cxf.ws.rm.v200702.AckRequestedType> reqs, boolean last, List<Header> headers) throws JAXBException {
        if (null != seq) {
            LOG.log(Level.FINE, "encoding sequence into RM header");
            org.apache.cxf.ws.rm.v200502.SequenceType toseq = VersionTransformer.convert200502(seq);
            if (last) {
                toseq.setLastMessage(new SequenceType.LastMessage());
            }
            JAXBElement<org.apache.cxf.ws.rm.v200502.SequenceType> element = RMUtils.getWSRM200502Factory().createSequence(toseq);
            headers.add((Header)new SoapHeader(element.getName(), element, this.getDataBinding(), true));
        }
        if (null != acks) {
            LOG.log(Level.FINE, "encoding sequence acknowledgement(s) into RM header");
            for (SequenceAcknowledgement ack : acks) {
                headers.add((Header)new SoapHeader(new QName(this.getConstants().getWSRMNamespace(), "SequenceAcknowledgement"), (Object)VersionTransformer.convert200502(ack), this.getDataBinding()));
            }
        }
        if (null != reqs) {
            LOG.log(Level.FINE, "encoding acknowledgement request(s) into RM header");
            for (org.apache.cxf.ws.rm.v200702.AckRequestedType req : reqs) {
                headers.add((Header)new SoapHeader(new QName(this.getConstants().getWSRMNamespace(), "AckRequested"), RMUtils.getWSRM200502Factory().createAckRequested(VersionTransformer.convert200502(req)), this.getDataBinding()));
            }
        }
    }

    @Override
    protected Object buildHeaderFaultObject(SequenceFault sf) {
        SequenceFaultType flt = new SequenceFaultType();
        flt.setFaultCode(sf.getFaultCode());
        Object detail = sf.getDetail();
        if (detail instanceof Element) {
            flt.getAny().add(detail);
        } else if (detail instanceof Identifier) {
            flt.getAny().add(VersionTransformer.convert200502((Identifier)detail));
        } else if (detail instanceof SequenceAcknowledgement) {
            flt.getAny().add(VersionTransformer.convert200502((SequenceAcknowledgement)detail));
        }
        Element data = sf.getExtraDetail();
        if (data != null) {
            flt.getAny().add(data);
        }
        return flt;
    }

    @Override
    public Element encodeSequenceAcknowledgement(SequenceAcknowledgement ack) throws JAXBException {
        DocumentFragment doc = DOMUtils.getEmptyDocument().createDocumentFragment();
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.marshal((Object)VersionTransformer.convert200502(ack), (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public Element encodeIdentifier(Identifier id) throws JAXBException {
        DocumentFragment doc = DOMUtils.getEmptyDocument().createDocumentFragment();
        Marshaller marshaller = this.getContext().createMarshaller();
        marshaller.marshal((Object)VersionTransformer.convert200502(id), (Node)doc);
        return (Element)doc.getFirstChild();
    }

    @Override
    public SequenceType decodeSequenceType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, org.apache.cxf.ws.rm.v200502.SequenceType.class);
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502.SequenceType)jaxbElement.getValue());
    }

    @Override
    public CloseSequenceType decodeSequenceTypeCloseSequence(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, org.apache.cxf.ws.rm.v200502.SequenceType.class);
        org.apache.cxf.ws.rm.v200502.SequenceType seq = (org.apache.cxf.ws.rm.v200502.SequenceType)jaxbElement.getValue();
        if (seq.isSetLastMessage()) {
            CloseSequenceType close = new CloseSequenceType();
            close.setIdentifier(VersionTransformer.convert(seq.getIdentifier()));
            close.setLastMsgNumber(seq.getMessageNumber());
            return close;
        }
        return null;
    }

    @Override
    public SequenceAcknowledgement decodeSequenceAcknowledgement(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        org.apache.cxf.ws.rm.v200502.SequenceAcknowledgement ack = (org.apache.cxf.ws.rm.v200502.SequenceAcknowledgement)unmarshaller.unmarshal((Node)elem);
        return VersionTransformer.convert(ack);
    }

    @Override
    public org.apache.cxf.ws.rm.v200702.AckRequestedType decodeAckRequestedType(Element elem) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext().createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Node)elem, AckRequestedType.class);
        return VersionTransformer.convert((AckRequestedType)jaxbElement.getValue());
    }

    @Override
    public Object convertToSend(CreateSequenceType create) {
        return VersionTransformer.convert200502(create);
    }

    @Override
    public Object convertToSend(CreateSequenceResponseType create) {
        return VersionTransformer.convert200502(create);
    }

    @Override
    public Object convertToSend(org.apache.cxf.ws.rm.v200702.TerminateSequenceType term) {
        return VersionTransformer.convert200502(term);
    }

    @Override
    public CreateSequenceType convertReceivedCreateSequence(Object create) {
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502.CreateSequenceType)create);
    }

    @Override
    public CreateSequenceResponseType convertReceivedCreateSequenceResponse(Object response) {
        return VersionTransformer.convert((org.apache.cxf.ws.rm.v200502.CreateSequenceResponseType)response);
    }

    @Override
    public org.apache.cxf.ws.rm.v200702.TerminateSequenceType convertReceivedTerminateSequence(Object term) {
        return VersionTransformer.convert((TerminateSequenceType)term);
    }
}

