/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.utils;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.configuration.MutableConfiguration;
import org.apache.cxf.common.logging.LogUtils;

public final class JCacheUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JCacheUtils.class);
    private static final boolean JCACHE_INSTALLED;

    private JCacheUtils() {
    }

    public static <K, V> Cache<K, V> getOrCreate(CacheManager cacheManager, String name, Class<K> kclass, Class<V> vclass) {
        return JCacheUtils.getOrCreate(cacheManager, name, kclass, vclass, Function.identity());
    }

    public static <K, V> Cache<K, V> getOrCreate(CacheManager cacheManager, String name, Class<K> kclass, Class<V> vclass, Function<MutableConfiguration<K, V>, MutableConfiguration<K, V>> customizer) {
        Cache cache = cacheManager.getCache(name, kclass, vclass);
        if (cache != null) {
            return cache;
        }
        MutableConfiguration<K, V> cacheConfiguration = new MutableConfiguration<K, V>();
        cacheConfiguration = customizer.apply(cacheConfiguration.setTypes(kclass, vclass));
        return cacheManager.createCache(name, cacheConfiguration);
    }

    public static boolean isJCacheInstalled() {
        return JCACHE_INSTALLED;
    }

    static {
        boolean jcacheInstalled = false;
        try {
            Class<?> caching = Class.forName("javax.cache.Caching");
            Class<?> cachingProvider = Class.forName("javax.cache.spi.CachingProvider");
            if (caching != null) {
                jcacheInstalled = MethodHandles.publicLookup().findStatic(caching, "getCachingProvider", MethodType.methodType(cachingProvider)).invoke() != null;
            }
        }
        catch (Throwable e) {
            LOG.fine("No JCache SPIs detected on classpath: " + e.getMessage());
        }
        JCACHE_INSTALLED = jcacheInstalled;
    }
}

