/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.function.DoubleUnaryOperator;
import org.apache.commons.statistics.inference.Arguments;

class BracketFinder {
    private static final double EPS_MIN = 1.0E-21;
    private static final double GOLD = 1.618033988749895;
    private final double growLimit;
    private final int maxEvaluations;
    private int evaluations;
    private double lo;
    private double hi;
    private double mid;
    private double fLo;
    private double fHi;
    private double fMid;

    BracketFinder() {
        this(100.0, 100000);
    }

    BracketFinder(double growLimit, int maxEvaluations) {
        Arguments.checkStrictlyPositive(growLimit);
        Arguments.checkStrictlyPositive(maxEvaluations);
        this.growLimit = growLimit;
        this.maxEvaluations = maxEvaluations;
    }

    boolean search(DoubleUnaryOperator func, double a, double b, double min, double max) {
        double fB;
        this.evaluations = 0;
        DoubleUnaryOperator range = min < max ? x -> {
            if (x > min) {
                return x < max ? x : max;
            }
            return min;
        } : DoubleUnaryOperator.identity();
        double xA = range.applyAsDouble(a);
        double xB = range.applyAsDouble(b);
        double fA = this.value(func, xA);
        if (fA < (fB = this.value(func, xB))) {
            double tmp = xA;
            xA = xB;
            xB = tmp;
            tmp = fA;
            fA = fB;
            fB = tmp;
        }
        double xC = range.applyAsDouble(xB + 1.618033988749895 * (xB - xA));
        double fC = this.value(func, xC);
        while (fC < fB) {
            double fW;
            double tmp1 = (xB - xA) * (fB - fC);
            double tmp2 = (xB - xC) * (fB - fA);
            double val = tmp2 - tmp1;
            double denom = 2.0 * Math.copySign(Math.max(Math.abs(val), 1.0E-21), val);
            double w = range.applyAsDouble(xB - ((xB - xC) * tmp2 - (xB - xA) * tmp1) / denom);
            double wLim = range.applyAsDouble(xB + this.growLimit * (xC - xB));
            if ((w - xC) * (xB - w) > 0.0) {
                fW = this.value(func, w);
                if (fW < fC) {
                    xA = xB;
                    xB = w;
                    fA = fB;
                    fB = fW;
                    break;
                }
                if (fW > fB) {
                    xC = w;
                    fC = fW;
                    break;
                }
                w = range.applyAsDouble(xC + 1.618033988749895 * (xC - xB));
                fW = this.value(func, w);
            } else if ((w - wLim) * (xC - w) > 0.0) {
                fW = this.value(func, w);
                if (fW < fC) {
                    xB = xC;
                    xC = w;
                    w = range.applyAsDouble(xC + 1.618033988749895 * (xC - xB));
                    fB = fC;
                    fC = fW;
                    fW = this.value(func, w);
                }
            } else if ((w - wLim) * (wLim - xC) >= 0.0) {
                w = wLim;
                fW = this.value(func, w);
            } else {
                w = range.applyAsDouble(xC + 1.618033988749895 * (xC - xB));
                fW = this.value(func, w);
            }
            xA = xB;
            fA = fB;
            xB = xC;
            fB = fC;
            xC = w;
            fC = fW;
        }
        this.mid = xB;
        this.fMid = fB;
        if (xC < xA) {
            this.lo = xC;
            this.fLo = fC;
            this.hi = xA;
            this.fHi = fA;
        } else {
            this.lo = xA;
            this.fLo = fA;
            this.hi = xC;
            this.fHi = fC;
        }
        return this.lo < this.mid && this.mid < this.hi;
    }

    int getEvaluations() {
        return this.evaluations;
    }

    double getLo() {
        return this.lo;
    }

    double getFLo() {
        return this.fLo;
    }

    double getHi() {
        return this.hi;
    }

    double getFHi() {
        return this.fHi;
    }

    double getMid() {
        return this.mid;
    }

    double getFMid() {
        return this.fMid;
    }

    private double value(DoubleUnaryOperator func, double x) {
        if (this.evaluations >= this.maxEvaluations) {
            throw new IllegalStateException("Too many evaluations: " + this.evaluations);
        }
        ++this.evaluations;
        return func.applyAsDouble(x);
    }
}

